<?php
## Connection Class


class ExtraShieldAPI{

  var $LicenseKey;
  var $ID;
  var $ExtraShieldID;
  var $SecurityCode;
  var $HashCode;
  var $ServiceURL;
  var $ServicePORT;
  var $Query;
  var $TimeOut;
  var $Debug;
  var $DebugArray;
  var $FailedLoginCounts;
  var $cTempDir;
  var $cTempSessionFile;
  var $Error_Code;
  var $Error_Type;
  var $Error_Message;
  var $Queries_Remaining;
  var $LockTimeRemaining;


  function ExtraShieldAPI() {
    $this->ServiceURL = "http://vld.extrashield.com";
    $this->ServicePORT = 80;
    $this->TimeOut = 10;
    $this->Debug = 0;
    $this->DebugArray = array();
    $this->FailedLoginCounts=0;
    $this->Error_Code="";
    $this->Error_Type="";
    $this->Error_Message="";
    $this->Queries_Remaining=0;
    $this->LockTimeRemaining = 0;

  }

  function set_Licence($VID,$LK){
    $this->LicenseKey = $LK;
    $this->ID = $VID;
    if ($this->Debug == 1){$this->DebugArray[] = "Your ID set to : ".$this->ID;
                           $this->DebugArray[] = "LicenseKey set to : ".$this->LicenseKey;}
  }

  function Check($EID,$SecCode){
    if (($this->ValidateSecCode($SecCode) == "VALID") && ($this->ValidateEID(strtolower($EID))== "VALID")){
         $this->cTempDir = $this->get_tempDir();
         $this->ExtraShieldID = strtolower($EID);
         $this->SecurityCode  = $SecCode;
         $this->get_Lock();
         if ($this->LockTimeRemaining == "0"){
             if ($this->Debug == 1){$this->DebugArray[] = "Starting to check if ".$this->ExtraShieldID."'s Current Code is : ".$this->SecurityCode;}
             $this->set_HCode();
             $this->set_Query();
             $ServerResp = $this->server_connect($this->ServiceURL,$this->ServicePORT,$this->Query,$this->TimeOut);
             ## parse ServerResponse
             $ServerResponseArray = $this->parseServerResponse($ServerResp);
             $ServerRespParts= explode("|",$ServerResp);
             $ValidResponse = md5($this->LicenseKey.$this->ExtraShieldID.$this->SecurityCode."VALID");
             if ($this->Debug == 1){$this->DebugArray[] = "[Waiting For]  :".$ValidResponse;}
             if ($ServerRespParts[0] == $ValidResponse){
                 if ($this->Debug == 1){$this->DebugArray[] = "[SUCCESS] :: ".$this->ExtraShieldID." supplied the right security code.";}
                 return "VALID";
             }else{
                 if ($this->Debug == 1){$this->DebugArray[] = "[FAILED]  :: Server Response: ".$ServerResp;}
                 if ($this->Error_Type == "U" && $this->Error_Code == "3"){
                     $this->set_Lock($this->LockTimeRemaining);
                 }
                 return "INVALID";
             }
         }else{return "INVALID";}
    }else{return "INVALID";}
  }

  function ValidateSecCode($SecCode){
    $Check = preg_replace("([0-9]+)","",$SecCode);
    if (empty($Check) && strlen($SecCode) == 6){
        return "VALID";
    }
    $this->Error_Type="L";
    $this->Error_Code="1";
    $this->Error_Message="Invalid Security Code, should be 6 digits.";
    if ($this->Debug == 1){$this->DebugArray[] = "[FAILED] Invalid Security Code, should be 6 digits.";}
  }

  function ValidateEID($EID){
    if (strlen($EID) == 12){
        sscanf($EID,'%4s%8s',$TokenPrefix, $TokenID);
        $PrefixCheck = preg_replace("([a-z]+)","",$TokenPrefix);
        $IDCheck = preg_replace("([0-9]+)","",$TokenID);
        if (empty($PrefixCheck) && strlen($TokenPrefix) == 4 && empty($IDCheck) && strlen($TokenID) == 8){
            return "VALID";
        }
    }
    $this->Error_Type="L";
    $this->Error_Code="2";
    $this->Error_Message="Invalid ExtraShieldID.";
    if ($this->Debug == 1){$this->DebugArray[] = "[FAILED] Invalid ExtraShieldID.";}
  }

  function set_HCode(){
    $this->HashCode = md5($this->LicenseKey.$this->ExtraShieldID.$this->SecurityCode);
    if ($this->Debug == 1){$this->DebugArray[] = "Generating HashCode as md5(LicenseKey.ExtraShieldID.SecurityCode) i.e., md5(".$this->LicenseKey.$this->ExtraShieldID.$this->SecurityCode.");";
                           $this->DebugArray[] = "Generated HashCode : ".$this->HashCode;}
  }

  function set_Query(){
    $this->Query = "license_id=".$this->ID."&hash=".$this->HashCode."&extrashield_id=".$this->ExtraShieldID."&security_code=".$this->SecurityCode;
    if ($this->Debug == 1){$this->DebugArray[] = "Generating GET Query : ".$this->Query;}
  }

  function get_tempDir(){
    if ( isset($this->cTempDir)){return $this->cTempDir;}
    if (!function_exists('sys_get_temp_dir')){
        if($temp=getenv('TMP')){$cTempDir = $temp;}
        elseif($temp=getenv('TEMP')){$cTempDir = $temp;}
        elseif($temp=getenv('TMPDIR')){$cTempDir = $temp;}
        else{ $temp=tempnam(__FILE__,'');
              if (file_exists($temp)){
                  unlink($temp);
                  $cTempDir = dirname($temp);
              }else{
                  if ($this->Debug == 1){$this->DebugArray[] = "Unable to create temporary directory, try setting it manually using \$this->set_TempDir()";}
                  return null;
              }
        }
    }else{ $cTempDir = sys_get_temp_dir();}
    if ($this->Debug == 1){$this->DebugArray[] = "Setting Temp Directory to : ".$cTempDir;}
    return $cTempDir;
  }

  function read_tempFile($FileName){
    $handle = @fopen($this->cTempDir."/".$FileName, "r");
    if ($handle){
        if ($this->Debug == 1){$this->DebugArray[] = "Reading Temp File : ".$this->cTempDir."/".$FileName;}
        $i=0;
        while (!feof($handle)){
               $lines[] = fgets($handle, 4096);
               $i++;
               if(!empty($lines[$i-1])){if ($this->Debug == 1){$this->DebugArray[] = "Reading Temp File Line [".$i."] : ".$lines[$i-1];}}
        }
        fclose($handle);
    }
    return $lines;
  }

  function write_tempFile($FileName, $Lines, $WriteMode){
    $handle = @fopen($this->cTempDir."/".$FileName, $WriteMode);
    if ($handle){
        if ($this->Debug == 1){$this->DebugArray[] = "Writing To Temp File : ".$this->cTempDir."/".$FileName;}
        foreach ($Lines as $LineNo=>$Line){
                 fwrite($handle, $Line."\n");
                 if ($this->Debug == 1){$this->DebugArray[] = "Writing To Temp File Line [".$LineNo++."] : ".$Line;}
        }
        fclose($handle);
    }
  }

  function get_Lock(){
    $this->cTempSessionFile=md5($this->ExtraShieldID);
    if(file_exists($this->cTempDir."/".$this->cTempSessionFile)){
       $line=$this->read_tempFile($this->cTempSessionFile);
       $cTimeNow=gmdate("U");
       if ($line[0] > $cTimeNow){
           $this->LockTimeRemaining = $line[0] - $cTimeNow;
           $this->Error_Type="L";
           $this->Error_Code="3";
           $this->Error_Message="Security Code check has failed too many times, please try again in [ ".$this->get_formattedTime($this->LockTimeRemaining)." ] ";
       }else{
           unlink($this->cTempDir."/".$this->cTempSessionFile);
       }
    }
  }

  function set_Lock($TimeRemaining){
    $this->cTempSessionFile=md5($this->ExtraShieldID);
    $cTimeNow=gmdate("U");
    $bTime=$cTimeNow+$TimeRemaining;
    $this->write_tempFile($this->cTempSessionFile, array($bTime), "w");
  }

  function get_formattedTime($lTime){
   if ($lTime < 3600 ){ return date('i\ \M\i\n\u\t\e\s\ \:\ s\ \S\e\c\o\n\d\s',$lTime);}
   else{ return date('H\ \H\o\u\r\s\ \:\ i\ \M\i\n\u\t\e\s\ \:\ s\ \S\e\c\o\n\d\s',$lTime);}
  }

  function parseServerResponse($Message){
    if ($this->Debug == 1){$this->DebugArray[] = "Parsing Server Reponse :";}
    $MessageArray = explode('|',$Message);
    foreach ($MessageArray as $MessageItem){
       list($Item, $IValue) = explode('=', $MessageItem);
       if ($Item == "error_type"){$this->Error_Type=$IValue;if ($this->Debug == 1){$this->DebugArray[] = "\$this->Error_Type Set To : ".$this->Error_Type;}}
       if ($Item == "error_code"){$this->Error_Code=$IValue;if ($this->Debug == 1){$this->DebugArray[] = "\$this->Error_Code Set To : ".$this->Error_Code;}}
       if ($Item == "message"){$this->Error_Message=$IValue;if ($this->Debug == 1){$this->DebugArray[] = "\$this->Error_Message Set To : ".$this->Error_Message;}}
       if ($Item == "lock_time_remaining"){$this->LockTimeRemaining=$IValue;if ($this->Debug == 1){$this->DebugArray[] = "\$this->LockTimeRemaining Set To : ".$this->LockTimeRemaining;}}
       if ($Item == "r_queries"){$this->Queries_Remaining=$IValue;if ($this->Debug == 1){$this->DebugArray[] = "\$this->Queries_Remaining Set To : ".$this->Queries_Remaining;}}
    }
  }

  function server_connect($URL,$Port,$Query,$TimeOut){
    if ($this->Debug == 1){$this->DebugArray[] = "Connecting to Server: ".$URL;}
    if (extension_loaded('curl')) {
        if ($this->Debug == 1){$this->DebugArray[] = "Using cURL";}
        $cu = curl_init();
        curl_setopt($cu, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($cu, CURLOPT_URL, $URL);
        curl_setopt($cu, CURLOPT_TIMEOUT, $TimeOut);
        curl_setopt($cu, CURLOPT_POST,1);
        curl_setopt($cu, CURLOPT_POSTFIELDS,$Query);

        $ReturnedResp = curl_exec($cu);
        $ReturnedErrors = curl_error($cu);
        $ServerRespCodes = curl_getinfo($cu);
        curl_close($cu);

        if ($ServerRespCodes['http_code'] != 200){
            if ($this->Debug == 1){$this->DebugArray[] = "[FAILED] Couldn't connect to server. cURL Error : ".$ReturnedErrors. "Response Code: ".$ServerRespCodes['http_code'];}
                $this->Error_Type="L";
                $this->Error_Code="4";
                $this->Error_Message="Couldn't connect to server. cURL Error : ".$ReturnedErrors. "Response Code: ".$ServerRespCodes['http_code']."";
                return "FAILED";
          }else{
               $ServerResp = rtrim($ReturnedResp);
               if ($this->Debug == 1){$this->DebugArray[] = "Server Response :".$ServerResp;}
        }
    }else{
        if ($this->Debug == 1){$this->DebugArray[] = "cURL not installed on this server, using fsockopen";}
        $ReturnedResp ="";
        @$fp = fsockopen($URL,$Port,$errno,$errstr,$TimeOut);
        if($fp){
           fputs($fp, "POST / HTTP/1.1\r\n");
           fputs($fp, "Host: $URL\r\n");
           fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
           fputs($fp, "Content-length: ".strlen($Query)."\r\n");
           fputs($fp, "Connection: close\r\n\r\n");
           fputs($fp, $Query."\r\n\r\n");
           while(!feof($fp)) $ReturnedResp .= fgets($fp,1024);
           fclose($fp);
        }else{
           if ($this->Debug == 1){$this->DebugArray[] = "[FAILED] Couldn't connect to server. fsockopen Error No.:".$errno." Error Desc.:".$errstr;}
               $this->Error_Type="L";
               $this->Error_Code="5";
               $this->Error_Message="Couldn't connect to server. fsockopen Error No.:".$errno." Error Desc.:".$errstr;
               return "FAILED";
        }

        $RespLines = explode("\n", $ReturnedResp);
        $ServerRespCode = $RespLines[0];
        $isValidResponse = strrpos ($ServerRespCode, "200");
        if ($isValidResponse === false){
            if ($this->Debug == 1){$this->DebugArray[] = "[FAILED] Server Response Code: ".$RespLines[0];}
                $this->Error_Type="L";
                $this->Error_Code="6";
                $this->Error_Message="Server Response Code: ".$RespLines[0];
            return "FAILED";
        }else{
           $ServerResp = rtrim($RespLines[count($RespLines)-2]);
           if ($this->Debug == 1){$this->DebugArray[] = "Server Response :".$ServerResp;}
        }
    }
    ## If we reached here, then we've a valid server response
    return $ServerResp;
  }

  function set_TempDir($ccTempDir){
    $temp=tempnam($ccTempDir,"");
    if (dirname($temp) === $ccTempDir){
        unlink($temp);
        $this->cTempDir = $ccTempDir;
        if ($this->Debug == 1){$this->DebugArray[] = "Setting Temp Directory Manually to : ".$this->cTempDir;}
     }else{
        if ($this->Debug == 1){$this->DebugArray[] = "Unable to create temporary directory, try setting it manually using \$this->set_TempDir()";}
        return null;
    }
  }

  function get_LocalIP(){
    $ServerResp = $this->server_connect("http://www.whatismyip.com/automation/n09230945.asp",$this->ServicePORT,"",$this->TimeOut);
    if ($ServerResp != "FAILED"){
        return $this->is_validIP($ServerResp);
    }else{
        return "FAILED";
    }
  }

  function register_plugin($RegToken){
    $LicenseArray=array();
    $ServerResp = $this->server_connect("http://www.extrashield.com/register.php",$this->ServicePORT,"token=".$RegToken,$this->TimeOut);
    if ($ServerResp != "FAILED"){
        $ServerRespParts= explode("|",$ServerResp);
        if (($ServerRespParts[0] === "OK") && ($this->isMD5Hash($ServerRespParts[2]) === "VALID") ){
            $LicenseArray['License_ID']=$ServerRespParts[1];
            $LicenseArray['License_CODE']=$ServerRespParts[2];
            return $LicenseArray;
        }else{return "FAILED";}
    }else{return "FAILED";}
  }


  function is_validIP($IP){
    $cIP = ip2long($IP);
    $fIP = long2ip($cIP);
    if ($fIP != "0.0.0.0"){return $fIP;}
    else {return "INVALID";}
  }

  function isMD5Hash($Data,$Len=32){
    $Check = preg_replace("([0-9a-f]+)","",$Data);
    if (empty($Check) && strlen($Data) == $Len){
        return "VALID";
    }
  }

  function get_DebugArray(){
    return $this->DebugArray;
  }

  function set_Debug(){
    $this->Debug = 1;
  }

  function get_Error_Code(){
    return $this->Error_Code;
  }

  function get_Error_Type(){
    return $this->Error_Type;
  }

  function get_Error_Message(){
    return $this->Error_Message;
  }

  function get_Queries_Remaining(){
    return $this->Queries_Remaining;
  }

  function get_LockTimeRemaining(){
    return $this->LockTimeRemaining;
  }

}
?>
