<?php
/**
 * Plugin Name:       Export Pattern & Block Location
 * Plugin URI:        https://wordpress.org/plugins/export-pattern-block-location/
 * Description:       Search for CSS classes, Gutenberg blocks and WordPress patterns in posts/pages/CPTs content and export results to CSV.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            Bubuku
 * Author URI:        https://www.bubuku.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       export-pattern-block-location
 * Domain Path:       /languages
 *
 * @package ExportPatternBlockLocation
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Plugin constants.
 */
define( 'EPBL_VERSION', '1.0.0' );
define( 'EPBL_PLUGIN_FILE', __FILE__ );
define( 'EPBL_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'EPBL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'EPBL_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Autoloader for plugin classes.
 *
 * @since 1.0.0
 *
 * @param string $class_name The class name to load.
 */
function epbl_autoloader( $class_name ) {
	// Check if the class is in our namespace.
	$namespace = 'ExportPatternBlockLocation\\';

	if ( strpos( $class_name, $namespace ) !== 0 ) {
		return;
	}

	// Remove namespace prefix.
	$class_name = str_replace( $namespace, '', $class_name );

	// Convert class name to filename.
	// REST_API -> class-rest-api.php
	$class_file = 'class-' . strtolower( str_replace( '_', '-', $class_name ) ) . '.php';

	// Build the file path.
	$file_path = EPBL_PLUGIN_DIR . 'includes/' . $class_file;

	// Load the file if it exists.
	if ( file_exists( $file_path ) ) {
		require_once $file_path;
	}
}
spl_autoload_register( 'epbl_autoloader' );

/**
 * Returns the main instance of the plugin.
 *
 * @since 1.0.0
 *
 * @return ExportPatternBlockLocation\Plugin
 */
function epbl() {
	return \ExportPatternBlockLocation\Plugin::instance();
}

// Initialize the plugin.
epbl();
