<?php

$week_days = array('Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun');
$template_data_inner 	= (array)json_decode($template_data);
if( !empty($template_data) && !isset($template_data_inner['message']) && !isset($template_data_inner['msg']) && $template_data != 'null' && !isset($template_data_inner[0]) ) :
	$shortcode_domain_name = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';
	$api_endpoint_url = '';
	if( !empty($shortcode_domain_name) ):
		$api_endpoint_url = rtrim($shortcode_domain_name, '/');
	endif;
	$activity_title 		= $template_data_inner['activity_title'];
	$activity_teaser 		= $template_data_inner['activity_teaser'];
	$activity_description 	= (isset($template_data_inner['activity_description'])) ? $template_data_inner['activity_description'] : '';
	$currency 				= $template_data_inner['currency'];
	$fromprice 				= $template_data_inner['fromprice'];
	$activity_types 		= isset($template_data_inner['activity_types']) ? implode(' | ', $template_data_inner['activity_types']) : '';
	$address 				= isset($template_data_inner['address']) ? (array)$template_data_inner['address'] : '';
	$activityprovider 		= isset($address['activityprovider']) ? $address['activityprovider'] : '';
	$inner_address 			= isset($address['address']) ? $address['address'] : '';
	$thumbnail 				= $template_data_inner['images'];
	$items 					= $template_data_inner['items'];
	$eabs_cart_page 		= !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : ''; ?>

	<div class="eabs_main-block">
		<input type="hidden" class="eabs_api-domain" value="<?php echo esc_url($api_endpoint_url); ?>">
		<input type="hidden" class="eabs_current-page" value="<?php echo esc_url(get_permalink(get_the_ID())); ?>">
		<input type="hidden" class="eabs_redirect-cart" value="<?php echo esc_url(get_permalink($eabs_cart_page)); ?>">
		<input type="hidden" class="eabs_ajax-cart" id="eabs_ajax-cart" value="<?php echo esc_url(admin_url( 'admin-ajax.php' )); ?>">
		<div class="eabs_activities-main">
			<div class="eabs_inner-col eabs_activity-title">
				<h1><?php echo esc_html($activity_title); ?></h1>
				<h3 class="eabs_heading-nospace"><?php echo esc_html($activity_teaser); ?></h3>
				<p><?php echo nl2br(esc_html($activity_description)); ?></p>
				<div class="mb-2">
					<?php echo esc_html__('Tags', 'experience-activities-booking-system'); ?>
					<?php echo esc_html(': '.$activity_types); ?>
				</div>
				<h4 class="mb-2 eabs_heading-nospace">
					<?php echo esc_html__('from', 'experience-activities-booking-system'); ?>
					<?php echo esc_html(' '.$currency.' '.number_format($fromprice, 2)); ?>
				</h4>
				<a name="top"></a>
				
				<?php 
				if( isset($template_data_inner['items']) && !empty($template_data_inner['items']) && count($template_data_inner['items']) > 1 ) : ?>
					<div class="container-fluid">
						<h4 class="eabs_heading-nospace"><?php echo esc_html__('Available activities', 'experience-activities-booking-system'); ?></h4>
						<div class="eabs_activities-main eabs_more-activity"><?php
							foreach ($template_data_inner['items'] as $mk_list => $mk_value) : ?>
								<div class="eabs_inner-col eabs_inner-img">
									<a href="#<?php echo esc_attr($mk_value->item); ?>" class="stretched-link">
										<div class="card bg-dark text-white border-0 rounded-0"><?php 
											/** activities slider */
											if( !empty($mk_value->images) ):
												foreach ($mk_value->images as $img_key => $img_val) : ?>
													<img class="card-img" src="<?php echo esc_url('https://drlhqgc7z3iss.cloudfront.net'.$img_val->img); ?>" alt="<?php echo esc_attr($img_val->description); ?>"><?php
													break;
												endforeach;
											endif; ?>
											<div class="card-img-overlay">
												<h5 class="card-title"><?php echo esc_html($mk_value->title); ?></h5>
												<p class="card-text">
													<?php echo esc_html__('from', 'experience-activities-booking-system'); ?>
													<?php echo esc_html(' '.$currency.' '.number_format($mk_value->fromprice, 2)); ?>
												</p>
											</div>
										</div>
									</a>
								</div><?php
							endforeach; ?>
						</div>
					</div><?php
				endif;

				if( !empty($address) ): ?>
					<div class="col-sm-auto eabs_add_text">
						<div>
							<strong><?php echo esc_html__('Address', 'experience-activities-booking-system'); ?>:</strong>
						</div><?php
						foreach ($address as $address_key => $address_value) { ?>
							<div>
								<?php echo esc_html($address_value); ?>
							</div><?php
						} ?>
					</div><?php
				endif; ?>
			</div>
			<div class="eabs_inner-col eabs__activity-img">
				<img class="img-fluid" src="<?php echo esc_url('https://drlhqgc7z3iss.cloudfront.net'.$thumbnail->img); ?>" alt="<?php echo esc_attr($thumbnail->description); ?>">
			</div>
		</div>
		
		<?php 
		if( isset($template_data_inner['items']) && !empty($template_data_inner['items']) ) :
			foreach ($template_data_inner['items'] as $key => $value) : ?>
				<hr />
				<div class="eabs_activities-main" id="<?php echo esc_attr($value->item); ?>">
					<div class="eabs_inner-col eabs_activity-title"><?php
						if( $value->instantbooking == true ) : ?>
							<h6 class="eabs_heading-nospace">
								<span class="badge rounded-0 badge-success mt-3 activity_book-type success" data-toggle="tooltip" data-placement="top" title="The booking for this activity will be confirmed at check-out"><?php echo esc_html__('Instant Booking', 'experience-activities-booking-system'); ?></span>
							</h6><?php
						else : ?>
							<h6 class="eabs_heading-nospace">
								<span class="badge rounded-0 badge-dark mt-3 activity_book-type dark" data-toggle="tooltip" data-placement="top" title="The booking for this activity will need to be approved by the activity provider at check-out"><?php echo esc_html__('On Request', 'experience-activities-booking-system'); ?></span>
							</h6><?php
						endif; ?>
						<h3 class="eabs_heading-nospace"><?php echo esc_html($value->title); ?></h3>
						<p class="eabs_txt-p"><?php echo nl2br(esc_html($value->description)); ?></p>
						<div></div>
						<h4 class="mb-2 eabs_price-txt eabs_heading-nospace">
							<?php echo esc_html__('from', 'experience-activities-booking-system'); ?>
							<?php echo esc_html(' '.$currency.' '.number_format($value->fromprice,2)); ?>
						</h4>
					</div>
					<div class="eabs_inner-col eabs__activity-img eabs_slider-container"><?php
						if( !empty($value->images) ):
							foreach ($value->images as $img_key => $img_val) : ?>
								<div class="eabs_slider-img">
									<img class="img-fluid" src="<?php echo esc_url('https://drlhqgc7z3iss.cloudfront.net'.$img_val->img); ?>" alt="<?php echo esc_attr($img_val->description); ?>">
									<div class="eabs_slider-desc"><?php if( isset($img_val->description) && !empty($img_val->description)): echo esc_html($img_val->description); endif; ?></div>
								</div><?php
							endforeach; ?>
							<a class="eabs_prev-slide eabs_slide-btn" data-item="1" data-index="-1">❮</a>
							<a class="eabs_next-slide eabs_slide-btn" data-item="1" data-index="1">❯</a><?php
						endif; ?>
					</div>
				</div>
				<div class="eabs_activities-main">
					<div class="eabs_inner-col">
						<div class="eabs_inner-tbl eabs_inner-tbl-data">
							<div class="">
								<h5 class="eabs_heading-nospace"><?php echo esc_html__('Duration', 'experience-activities-booking-system'); ?>:</h5>
							</div>
							<div class="">
								<p><?php if($value->duration != 'none') : echo esc_html($value->duration); else: echo esc_html__('Variable', 'experience-activities-booking-system'); endif; ?></p>
							</div>
						</div>
						<div class="eabs_inner-tbl eabs_inner-tbl-data">
							<div class="">
								<h5 class="eabs_heading-nospace">
									<?php echo esc_html__('Cancellation', 'experience-activities-booking-system'); ?><?php echo esc_html(':'); ?>
								</h5>
							</div>
							<div class="">
								<p><?php 
									if( !empty($value->cancellation) ) : 
										echo esc_html($value->cancellation); 
									else : 
										echo esc_html__('Free of charge at any time', 'experience-activities-booking-system'); 
									endif; ?></p>
							</div>
						</div>
						<div class="eabs_inner-tbl eabs_inner-tbl-data">
							<div class="">
								<h5 class="eabs_heading-nospace"><?php echo esc_html__('Payment', 'experience-activities-booking-system'); ?>:</h5>
							</div>
							<div class="">
								<p><?php if( !empty($value->payment_modality) ) : echo esc_html($value->payment_modality); else : echo esc_html__('At the activity provider', 'experience-activities-booking-system'); endif; ?></p>
							</div>
						</div>
						<div class="eabs_inner-tbl eabs_inner-tbl-data">
							<div class="">
								<h5 class="eabs_heading-nospace"><?php echo esc_html__('Payment methods', 'experience-activities-booking-system'); ?>:</h5>
							</div>
							<div class="">
								<div class="eabs_inner-tbl eabs_inner-methods-data"><?php 
								if (isset($template_data_inner['paymentmethods']) && !empty($template_data_inner['paymentmethods']) && in_array("Stripe", $template_data_inner['paymentmethods'])): echo esc_html__('At the time of booking', 'experience-activities-booking-system');
									elseif( isset($template_data_inner['paymentmethods']) && !empty($template_data_inner['paymentmethods']) ):
										foreach ($template_data_inner['paymentmethods'] as $k_inner => $v_inner) :
											echo '&nbsp; <img src="https://drlhqgc7z3iss.cloudfront.net'.'/site-assets/'.esc_attr($v_inner).'.jpg" alt="'.$v_inner.'" height="25" data-toggle="tooltip" data-placement="top" class="eabs_payment-method" title="" data-original-title="'.esc_attr($v_inner).'">';
										endforeach;
									endif;
								?></div>
							</div>
						</div>
						<div class="eabs_bus-hours">
							<div class="eabs_bus-heading">
								<h5 class="eabs_heading-nospace"><?php echo esc_html__('Business hours', 'experience-activities-booking-system'); ?>:</h5>
							</div>
							<div class="eabs_payment-method">
								<?php 
								if( !empty($value->opening_hours) ):
									foreach ($value->opening_hours as $dkey => $dval) : ?>
										<div class="eabs_inner-methods">
											<div class="eabs_inner-methods-heading">
												<p><?php echo esc_html__($dkey); ?></p>
											</div>
											<div class="eabs_inner-methods-time"><?php
												foreach ($dval as $dval_key => $dval_time):
													if( $dval_time->opens == $dval_time->closes ): ?>
														<p>
															<?php echo eabs_time_language_localization($dval_time->opens, $language); ?>
															<?php echo esc_html__( ' (activity start time)', 'experience-activities-booking-system'); ?>
														</p><?php
													else: ?>
														<p><?php echo eabs_time_language_localization($dval_time->opens, $language).' - '.eabs_time_language_localization($dval_time->closes, $language); ?></p><?php
													endif;
												endforeach; ?>
											</div>
										</div><?php
									endforeach;
								endif;
								?>
							</div>
						</div>
					</div>
				</div><?php

				/** Calendor */
				if( !empty($template_data_inner['items']) ) :
					$eabs_mname 		= date('f', strtotime($value->availability[0]->date));
					$eabs_start 		= date('M', strtotime($value->availability[0]->date));
					$eabs_start_year 	= date('Y', strtotime($value->availability[0]->date));
					$eabs_year 			= date('Y', strtotime($value->availability[count($value->availability)-1]->date));
					$eabs_end 			= date('M', strtotime($value->availability[count($value->availability)-1]->date));

					foreach ($template_data_inner['items'] as $dt_key => $dt_value) {
						foreach ($dt_value->availability as $inner_dt_key => $inner_dt_value) {
							$loop_months[date('F', strtotime($inner_dt_value->date)).' '.date('Y', strtotime($inner_dt_value->date))] = date('M', strtotime($inner_dt_value->date));
						}
					}
					?>
					<hr />
					<div class="eabs_activities-calendor">
						<h3 class="eabs_heading-nospace"><?php echo esc_html__('Select the date that you’d like to complete the activity', 'experience-activities-booking-system'); ?></h3>
						<div class="eabs_activities-main  <?php if( count($loop_months) > 1  ){ echo esc_attr('eabs_multi-items'); } ?>">
							<?php

							$days = array(
								'Mon' => 0,
								'Tue' => 1,
								'Wed' => 2,
								'Thu' => 3,
								'Fri' => 4,
								'Sat' => 5,
								'Sun' => 6
							);

							$loop_count = 1;
							foreach ($loop_months as $month_key => $month_value) :
								$i = 1; 
								$skip_td = true;
								$calendar_month = explode(" ", $month_key) ?>
								<div class="eabs_inner-col <?php echo esc_attr($loop_count); ?> eabs_slide-<?php echo esc_attr($loop_count); ?>" data-item_id="<?php echo esc_attr($loop_count); $loop_count++; ?>">
									<h5 class="eabs_heading-nospace"><?php echo esc_html__($calendar_month[0]); ?> <?php echo esc_html($calendar_month[1]); ?></h5>
									<table class="eabs_table">
										<thead>
											<tr>
												<th><?php echo esc_html__('Mon', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Tue', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Wed', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Thu', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Fri', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Sat', 'experience-activities-booking-system'); ?></th>
												<th><?php echo esc_html__('Sun', 'experience-activities-booking-system'); ?></th>
											</tr>
										</thead>
										<tbody><?php
											$regularname 		= $value->regularname;
											$item_fromprice 	= $value->fromprice;
											$pickup 			= !empty( $value->pickup ) ? $value->pickup : false;
											$next_cal = false;
											
											$diff_cat_name = array();
											if( isset($value->price_category_translations) ):
												$diff_cat_name = $value->price_category_translations;
											endif;

											foreach($value->availability as $key => $val){
												$eabs_loop_start = date('M', strtotime($value->availability[0]->date));
												$eabs_curr_start = date('M', strtotime($val->date));

												$split_date 	= explode(" ",$val->date);
												if( $eabs_curr_start == $month_value ) :
													$itemdetails 	= (array)$val;
													$regularprice 	= isset($itemdetails['regularprice']) ? $itemdetails['regularprice'] : NULL;
													$soldout 		= false;
													if( isset( $itemdetails['regularprice'] ) && isset( $itemdetails['totalquota'] ) && is_int($itemdetails['totalquota']) && $itemdetails['totalquota'] == 0 ) :
														$soldout = true;
													else :
														$soldout = false;
													endif;
														
													if($i == 1){
														echo '<tr>';

													}
													foreach($days as $k => $v ){
														if($i == 1){
															for($j=1; $j<$days[$split_date[0]];$j++){
																echo '<td class="eabs_empty-td"></td>';
																$i++;
															}
														}
														if( $i == $days[$split_date[0]]){
															echo '<td class="eabs_empty-td"></td>';
															$i++;
															continue;
														}

														$quota = 0;
														if($itemdetails['totalquota'] == "onrequest" || $itemdetails['totalquota'] == "unlimited") :
															$quota = 9;
														elseif( isset($itemdetails['linked']) && $itemdetails['linked'] == true ) :
															if( $itemdetails['totalquota'] > 9 ) :
																$quota = 9;
															else :
																$quota = $itemdetails['totalquota'];
															endif;
														elseif( isset($itemdetails['linked']) && $itemdetails['linked'] == false ) :
															if( $itemdetails['regularquota'] > 9 ) :
																$quota = 9;
															else :
																$quota = $itemdetails['regularquota'];
															endif;
														endif;

														
														$time_dropdown = '';
														if( !empty($value->opening_hours) ) :
															$opening_hours = (array)$value->opening_hours;
															$time_dropdown = $obj_class->eabs_create_options_for_time($opening_hours, $split_date[0]);
														endif;

														if( $regularprice == $item_fromprice && $soldout == false) :
															$eabs_success = 'eabs-success';
														elseif(  $soldout == true ) :
															$eabs_success = 'eabs-danger';
														else :
															$eabs_success = 'eabs-secondary';
														endif;

														$price_categories = isset($itemdetails['price_categories']) ? $itemdetails['price_categories'] : array();
														if( isset($itemdetails['byhour']) && $itemdetails['byhour'] == 1 ) : 
															$item_type = 'by_hour';
														elseif( isset($itemdetails['linked']) && $itemdetails['linked'] == 1 ): 
															$item_type = 'by_inventor';
														else: 
															$item_type = '0';
														endif;

														eabs_get_template(
															'frontend/template-activity_calendor.php',
															array(
																'template_name' 				=> 'activity_calendor',
																'split_date'					=> $split_date,
																'split_index'					=> $i,
																'split_date_full'				=> explode('-', $split_date[1]),
																'activity_id'					=> $template_data_inner['_id'],
																'item_id'						=> $value->item,
																'item_type'						=> $item_type,
																'instantbooking'				=> $value->instantbooking,
																'regularname'					=> $regularname,
																'fromprice'						=> $fromprice,
																'item_fromprice'				=> isset($value->fromprice) ? $value->fromprice : $fromprice,
																'regularprice'					=> $regularprice,
																'currency'						=> $currency,
																'date'							=> date("Y-m-d", strtotime($split_date[1]) ),
																'single_day'					=> date("d", strtotime($split_date[1]) ),
																'totalquota' 					=> $quota,
																"soldout"						=> $soldout,
																'time_dropdown'					=> $time_dropdown,
																'eabs_success'					=> $eabs_success,
																'pickup'						=> $pickup,
																'price_categories'				=> $price_categories,
																'price_categories_translated'	=> (array)$diff_cat_name,
																'language'						=> $language,
																'itemdetails'					=> $itemdetails,
															)
														);
														$i++;
														break;
														
													}
													if($i == 8):
														echo '</tr>';
														$i = 1;
													endif;
												else :
													$i = 1;
												endif;
											}
											?>
										</tbody>
									</table>
								</div><?php
							endforeach; ?>
						</div><?php
						if( count($loop_months) > 1 ): ?>
							<div class="eabs_table-next">
								<div class="eabs_tabel-prev">
									<a href="javascript:void(0);" class="eabs_prev" data-item_anim="<?php echo esc_attr('1'); ?>"  data-current_item="eabs_slide-1"  style="display: none;">
										<?php echo esc_html__('Previous', 'experience-activities-booking-system'); ?>
									</a>
								</div>
								<div class="eabs_tabel-next">
									<a href="javascript:void(0);" class="eabs_next" data-item_anim="<?php echo esc_attr('1'); ?>" data-current_item="eabs_slide-1" data-item_total="eabs_slide-<?php echo esc_attr($loop_count-1); ?>">
									<?php echo esc_html__('Next', 'experience-activities-booking-system'); ?>
								</a>
								</div>
							</div><?php
						endif; ?>
					</div><?php
				endif;
			endforeach;

		endif; ?>
	</div><?php
else:
	if( isset($template_data_inner['message']) ): ?>
		<p class="eabs_error-add"><?php echo esc_html($template_data_inner['message']); ?></p>
		<?php
elseif( isset($template_data_inner['msg']) ): ?>
		<p class="eabs_error-add"><?php echo esc_html($template_data_inner['msg']); ?></p><?php
	else: ?>
		<p class="eabs_error-add"><?php echo esc_html__('No found', 'experience-activities-booking-system'); ?></p><?php
	endif;
endif;