<?php get_header();

$CheckoutItems = array();
$qr_domain_url  = !empty( get_option( '_eabs_shortcode_qr_domain' ) ) ? ( rtrim( esc_url(get_option( '_eabs_shortcode_qr_domain' )), '/') ) : '';
$shortcode_domain_url = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';



if( !empty($checkout_items) && isset($checkout_items['items']) ): 
    $CheckoutItems = $checkout_items['items'];
endif;

if( isset($checkout_items['orderid']) ):
    $orderid = $checkout_items['orderid'];
else:
    $orderid = $cart_id;
endif;


?>

<div id="eabs_checkout-page">
    <div class="eabs_checkout-title">
        <h3 class="eabs_heading-nospace"><?php echo esc_html__('Booking confirmation', 'experience-activities-booking-system'); ?></h3>
    </div>
    <div class="eabs_cart-items"><?php
        if( !empty($CheckoutItems) && !empty( $shortcode_domain_url ) ): ?>
            <div class="checkout-booking title">
                <h4 class="eabs_heading-nospace">
                    <?php echo esc_html__( 'Booking number', 'experience-activities-booking-system'); ?><?php echo esc_html( ': '.$checkout_items['orderid']); ?>
                </h4>
            </div><?php
            foreach ($CheckoutItems as $item_key => $item) {
                $language = isset($checkout_items['language']) ? $checkout_items['language'] : 'en';

                if( isset($item['redemptionid']) ):
                    $redemptionid = $item['redemptionid'];
                else:
                    $redemptionid = '';
                endif; ?>
                <div class="eabs-items"><?php
                    if( $item['ok'] == true ): ?>
                        <div class="col-sm-auto py-3 eabs__cart-check-img">
                            <img src="<?php echo esc_url('https://drlhqgc7z3iss.cloudfront.net/'.$item['thumbnail']); ?>">
                        </div>
                        <div class="col">
                            <div class="row justify-content-between">
                                <div class="col-sm-auto pt-3">
                                    <h5 class="eabs_heading-nospace">
                                        <?php echo esc_html($item['activity_title']); ?>
                                    </h5>
                                </div>
                                <div class="col-sm-auto pt-3">
                                    <h5 class="eabs_heading-nospace">
                                        <?php echo esc_html__('Total', 'experience-activities-booking-system'); ?><?php echo esc_html(': '.$checkout_items['currency'].' '.number_format($item['total'], 2, '.', ',')); ?>
                                    </h5>
                                    <?php if( isset($item['vat'])): ?>
                                        <h6 class="eabs_heading-nospace">
                                            <?php echo esc_html__('VAT', 'experience-activities-booking-system'); ?><?php echo esc_html(': '.$checkout_items['currency'].' '.number_format($item['vat'], 2, '.', ',')); ?> 
                                        </h6>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row justify-content-between">
                                <div class="col-sm-auto">
                                    <strong><?php echo esc_html__('Quantity', 'experience-activities-booking-system'); ?>: </strong><span><?php echo esc_html($item['qty']); ?></span>
                                </div>
                                <div class="col-sm-auto">
                                    <strong><?php 
                                        if( $item['pricecategory'] != 'regular' ){ 
                                            echo esc_html__('Price per', 'experience-activities-booking-system'); 
                                            echo esc_html(' '.$item['pricecategory']); 
                                        }else{ 
                                            echo esc_html__('Price per person', 'experience-activities-booking-system');
										} ?>: </strong><?php echo esc_html($checkout_items['currency'].' '.number_format($item['unitprice'], 2, '.', ',')); ?> </div>
                            </div>
                            <div class="row justify-content-between">
                                <div class="col-sm-auto">
									<strong><?php echo esc_html__('Date', 'experience-activities-booking-system'); ?>: </strong><?php echo esc_html(date('M d, Y', strtotime($item['date']) )); ?>
                                </div>
                                <div class="col-sm-auto">
                                    <strong><?php echo esc_html__('Status', 'experience-activities-booking-system'); ?>: </strong>
									<?php
                                    if( isset($item['status']) && $item['status'] == 'onrequest' ):
                                        echo esc_html__('Pending confirmation', 'experience-activities-booking-system');
                                    else:
                                        echo esc_html__('Confirmed', 'experience-activities-booking-system');
                                    endif; ?>
                                </div>
                            </div>
                            <div class="row justify-content-left">
                                <div class="col-sm-auto">
                                    <?php
                                    if( isset($item['time']) ): ?>
									<div><strong><?php echo esc_html__('Time', 'experience-activities-booking-system'); ?>:</strong> <?php echo eabs_time_language_localization( $item['time'], $language  ); ?></div><?php
                                    else: ?>
                                        <div>
                                            <strong><?php echo esc_html__('Business hours', 'experience-activities-booking-system'); ?>:</strong>
                                        </div><?php
                                        foreach ($item['opening_hours'] as $h_key => $h_value) {
                                            echo '<div>'.eabs_time_language_localization( $h_value['opens'], $language ).'-'.eabs_time_language_localization( $h_value['closes'], $language ).'</div>';
                                        }
                                    endif; ?>
                                </div>
                            </div>
                            <div class="row justify-content-between">
                                <?php
                                if( isset($item['address']) ): ?>
                                    <div class="col-sm-auto">
                                        <div>
                                            <strong><?php echo esc_html__('Address', 'experience-activities-booking-system'); ?>:</strong>
                                        </div><?php
                                        foreach ($item['address'] as $address_key => $address_value) {
                                            echo '<div>'.esc_html($address_value).'</div>';                                        
                                        } ?>
                                    </div><?php
                                endif; ?>
                                <div class="col-sm-auto">
                                    <div>
                                        <strong><?php echo esc_html__('Business hours', 'experience-activities-booking-system'); ?>:</strong>
                                    </div>
                                    <?php
                                    if( isset($item['opening_hours']) ):
                                        foreach ($item['opening_hours'] as $h_key => $h_value) {
                                            echo '<div>'.eabs_time_language_localization($h_value['opens'], $language ).' - '.eabs_time_language_localization($h_value['closes'], $language ).'</div>';
                                        }
                                    endif; ?>
                                </div>
                            </div>
                            <div class="row justify-content-between eabs_checkout-qrcode">
                                <div class="col-sm-auto eabs_checkout-left">
                                    <div class="row justify-content-left">
                                        <div class="col-sm-auto"><strong><?php echo esc_html__('Duration', 'experience-activities-booking-system'); ?>: </strong><?php 
                                            if( isset($item['duration']) && $item['duration'] != 'none' ) :
                                                echo esc_html( $item['duration']); 
                                            else: 
                                                echo esc_html__('Variable', 'experience-activities-booking-system');
                                            endif; ?>											
                                        </div>
                                    </div>
                                    <div class="row justify-content-left">
                                        <div class="col-sm-auto"><strong><?php echo esc_html__('Cancellation', 'experience-activities-booking-system'); ?>: </strong><?php 
                                            if( isset($item['cancellation']) && !empty($item['cancellation']) ) : 
                                                echo esc_html($item['cancellation']); 
                                            else:
                                                echo esc_html__('Free of charge at any time', 'experience-activities-booking-system'); 
                                            endif; ?>											
                                        </div>
                                    </div>
                                    <div class="row justify-content-left">
                                        <div class="col-sm-auto"><strong><?php echo esc_html__('Payment', 'experience-activities-booking-system'); ?>: </strong><?php 
                                            if (in_array("Stripe", $item['paymentmethods'])): echo esc_html__('Already paid', 'experience-activities-booking-system');
                                            elseif( !empty($item['payment_modality']) ) : 
                                                echo esc_html($item['payment_modality']); 
                                            else: 
                                                echo esc_html__('At the activity provider', 'experience-activities-booking-system');
                                            endif; ?>											
                                        </div>
                                    </div>
                                    <div class="row justify-content-left mb-3">
                                        <?php if (isset($item['paymentmethods']) && !empty($item['paymentmethods']) && !in_array("Stripe", $item['paymentmethods'])): ?>
                                        <div class="col-sm-auto eabs_inner-tbl eabs_inner-methods-data">
                                            <strong><?php echo esc_html__('Payment methods', 'experience-activities-booking-system'); ?>:</strong>
											<?php
												if( isset($item['paymentmethods']) && !empty($item['paymentmethods']) ):
													foreach ($item['paymentmethods'] as $k_inner => $v_inner) :
														echo '&nbsp; <img src="https://drlhqgc7z3iss.cloudfront.net'.'/site-assets/'.esc_attr($v_inner).'.jpg" alt="'.esc_attr($v_inner).'" height="25" data-toggle="tooltip" data-placement="top" title="" class="eabs_payment-method" data-original-title="'.esc_attr($v_inner).'">';
													endforeach;
												endif; ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-sm-auto eabs_checkout-right">
                                    <div class="row justify-content-left">
                                        <div class="col-sm-auto">
                                            <strong><?php echo esc_html__('Redemption code', 'experience-activities-booking-system'); ?></strong><img class="img-fluid" src="<?php if( !empty($qr_domain_url) ): echo $qr_domain_url; else: echo "https://cms.uppliv.com"; endif; ?>/qrcode/redeem/<?php echo esc_attr($orderid); ?>/<?php echo esc_attr($redemptionid); ?>/image.jpg">
                                        </div>
                                    </div>
                                    <div class="row justify-content-left">
                                        <div class="col-sm-auto">
                                            <strong><?php echo esc_html__('Please present this code to the activity provider upon arrival', 'experience-activities-booking-system'); ?></strong>
                                        </div>
                                    </div>
                                </div>
                            </div><?php
                            if( $item['ok'] == false ): ?>
                                <div class="eabs_alert-danger" role="alert"><?php
                                    if( $item['error'] == "not enough availability" ):
                                        echo esc_html__('No longer available', 'experience-activities-booking-system');
                                    elseif( $item['error'] == "item does not exist" ):
                                        echo esc_html__('Activity not available anymore', 'experience-activities-booking-system');
                                    elseif( $item['error'] == "pastdate" ):
                                        echo esc_html__('This activity has been removed from the shopping cart because it has already taken place', 'experience-activities-booking-system');
                                    endif; ?>
                                </div><?php
                            else:
                                if( isset($item['warning']) ):
                                    if( $item['warning'] == "price decreased" ): ?>
                                        <div class="eabs_alert-success" role="alert"><?php
                                            echo esc_html__('The price of this activity has decreased', 'experience-activities-booking-system'); ?>
                                        </div><?php
                                    elseif( $item['warning']=="price increased" ): ?>
                                        <div class="eabs_alert-danger" role="alert"><?php
                                            echo esc_html__('The price of this activity has increased', 'experience-activities-booking-system'); ?>
                                        </div><?php
                                    endif;
                                endif;
                            endif;
                            ?>
                        </div><?php
                    endif; ?>
                </div><?php
            } ?>

            <div class="eabs_cart-footer">
                <div class="col-sm-auto">
                    <h5 class="eabs_heading-nospace">
                        <?php echo esc_html__('Total', 'experience-activities-booking-system'); ?><?php echo esc_html(': '.$checkout_items['currency'].' '.number_format($checkout_items['total'], 2, '.', ',')); ?>
                    </h5>
                    <?php if (isset($checkout_items['stripe_order_total'])): ?>
                            <h5 class="eabs_heading-nospace">
                            <?php echo esc_html__('Already paid', 'experience-activities-booking-system'); ?>
                            <?php echo esc_html(': '.$checkout_items['currency'].' '.number_format($checkout_items['stripe_order_total'], 2, '.', ',')); ?>
                        </h5>
                    <?php endif; ?>                
                    <h6 class="eabs_heading-nospace">
                        <?php echo esc_html__('VAT', 'experience-activities-booking-system'); ?><?php echo esc_html(': '.$checkout_items['currency'].' '.number_format($checkout_items['total_vat'], 2, '.', ',')); ?>
                    </h6>                                    
                </div>
            </div><?php
        else: ?>
            <p><?php echo esc_html__('The shopping checkout is empty', 'experience-activities-booking-system'); ?></p><?php
        endif;
        ?>
    </div>
</div>
<?php get_footer(); ?>