<?php get_header();
$all_items = array();

if( !empty($cart_items) && isset($cart_items['items']) ){
    $all_items = $cart_items['items'];
}

?>

<div id="eabs_cart-page">
    <input type="hidden" class="eabs_ajax-cart" id="eabs_ajax-cart" value="<?php echo esc_url(admin_url( 'admin-ajax.php' )); ?>">
    <div class="container">
        <div class="eabs_cart-heading">
            <h3 class="eabs_heading-nospace"><?php echo esc_html__('Shopping cart', 'experience-activities-booking-system'); ?></h3>
        </div>
        <div class="eabs_cart-items"><?php
            if( !empty($all_items) ):
				$language = isset($cart_items['language']) ? esc_html($cart_items['language']) : 'en';
                $stripe_order_total = isset($cart_items['stripe_order_total']) ? esc_html($cart_items['stripe_order_total']) : '';
                $stripe_payment_url = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )).'/stripe_payment/' ) : '';
                

                foreach ($all_items as $item_key => $item) { ?>
                    <div class="eabs-items"><?php
                        if( $item['ok'] == true ): ?>
                            <div class="col-sm-auto py-3 eabs__cart-check-img">
                                <img src="<?php echo esc_url('https://drlhqgc7z3iss.cloudfront.net/'.$item['thumbnail']); ?>">
                            </div>
                            <div class="col">
                                <div class="row justify-content-between">
                                    <div class="col-sm-auto pt-3"><?php
                                        $cart_activity_pg = ( isset( $item['wp_page_url'] ) && !empty($item['wp_page_url']) ) ? $item['wp_page_url'] : '#'; ?>
                                        <a href="<?php echo esc_url( $cart_activity_pg ); ?>">
                                            <h5 class="eabs_heading-nospace"><?php echo esc_html($item['activity_title']); ?></h5>
                                        </a>
                                    </div>
                                    <div class="col-sm-auto pt-3">
                                        <h5 class="eabs_heading-nospace eabs_heading-h5">
                                            <?php echo esc_html__('Total', 'experience-activities-booking-system'); ?>
                                            <?php echo esc_html(': '.$cart_items['currency'].' '.number_format($item['total'], 2, '.', ',')); ?>
                                        </h5>
                                        <?php if( isset($item['vat'])): ?>
                                            <h6 class="eabs_heading-nospace">
                                                <?php echo esc_html__('VAT', 'experience-activities-booking-system'); ?>
                                                <?php echo esc_html(': '.$cart_items['currency'].' '.number_format($item['vat'], 2, '.', ',')); ?>
                                            </h6>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-sm-auto">
                                        <strong><?php echo esc_html__('Quantity', 'experience-activities-booking-system'); ?>:</strong>           
                                        <form action="<?php echo esc_url(get_the_permalink()); ?>" method="post">
                                            <input type="hidden" id="cartindex" name="cartindex" value="<?php echo esc_attr($item['cartindex']); ?>">
                                            <input type="hidden" id="changeqty" name="changeqty" value="true">
                                            <select class="eabs_cart-qty-change" name="eabs_item_quantity" data-qty="<?php echo esc_attr($item['cartindex']); ?>"><?php
                                            $item_availableqty = ( ($item['availableqty'] == 'unlimited' || $item['availableqty'] == 'onrequest' ) ) ? 9 : $item['availableqty'];
                                                for($i=0; $i<=$item_availableqty; $i++):
                                                    if( $item['qty'] == $i ):
                                                        $sel = 'selected';
                                                    else:
                                                        $sel = '';
                                                    endif;
                                                    echo '<option value="'.esc_attr($i).'" '.esc_attr($sel).'>'.esc_html($i).'</option>';
                                                endfor; ?>
                                            </select>
                                        </form>
                                    </div>
                                    <div class="col-sm-auto eabs_txt-str">
                                        <strong>
                                            <?php if( $item['pricecategory'] != 'regular' ){ 
                                                echo esc_html__('Price per', 'experience-activities-booking-system'); 
                                                echo esc_html(' '.$item['pricecategory'].':'); 
                                            }else{ 
                                                echo esc_html__('Price per person', 'experience-activities-booking-system'); 
                                                echo esc_html(': '); 
                                            } ?>
                                        </strong> <?php echo esc_html($cart_items['currency'].' '.number_format($item['unitprice'], 2, '.', ',')); ?> </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-sm-auto">
										<strong><?php echo esc_html__('Date', 'experience-activities-booking-system'); ?>:</strong> <?php echo esc_html(date('M d, Y', strtotime($item['date']) )); ?>
                                    </div>
                                    <div class="col-sm-auto" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php if( $item['availableqty'] == 'onrequest' ): echo esc_attr('The booking for this activity will need to be approved by the activity provider at check-out'); else: esc_attr('The booking for this activity will be confirmed at check-out'); endif; ?>">
                                        <strong><?php echo esc_html__('Status', 'experience-activities-booking-system'); ?>: </strong>
										<?php
                                        if( $item['availableqty'] == 'onrequest' ):
                                            echo esc_html__('On request', 'experience-activities-booking-system');
                                        else:
                                            echo esc_html__('Instant booking', 'experience-activities-booking-system');
                                        endif; ?>
										
                                    </div>
                                </div>
                                <div class="row justify-content-left">
                                    <div class="col-sm-auto">
                                        <?php
                                        if( isset($item['time']) ): ?>
                                            <div>
												<strong><?php echo esc_html__('Time', 'experience-activities-booking-system'); ?>: </strong><?php echo eabs_time_language_localization( $item['time'], $language ); ?></div><?php
                                        else: ?>
                                            <div>
                                                <strong><?php echo esc_html__('Business hours', 'experience-activities-booking-system'); ?>:</strong>
                                            </div><?php
                                            foreach ($item['opening_hours'] as $h_key => $h_value) {
                                                echo '<div>'.eabs_time_language_localization($h_value['opens'], $language ).'-'.eabs_time_language_localization($h_value['closes'], $language).'</div>';
                                            }
                                        endif; ?>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <?php
                                    if( isset($item['address']) ): ?>
                                        <div class="col-sm-auto">
                                            <div><strong><?php echo esc_html__('Address', 'experience-activities-booking-system'); ?>:</strong></div><?php
                                            foreach ($item['address'] as $address_key => $address_value) {
                                                echo '<div>'.esc_html($address_value).'</div>';                                        
                                            } ?>
                                        </div><?php
                                    endif; ?>
                                    <div class="col-sm-auto">
                                        <div><strong><?php echo esc_html__('Business hours', 'experience-activities-booking-system'); ?>:</strong></div>
                                        <?php
                                        if( isset($item['opening_hours']) ):
                                            foreach ($item['opening_hours'] as $h_key => $h_value) {
                                                echo '<div>'.eabs_time_language_localization($h_value['opens'], $language).' - '.eabs_time_language_localization($h_value['closes'], $language).'</div>';
                                            }
                                        endif; ?>
                                    </div>
                                </div>
                                <div class="row justify-content-left">
                                    <div class="col-sm-auto"><strong><?php echo esc_html__('Duration', 'experience-activities-booking-system'); ?>:</strong> 
										<?php 
											if($item['duration'] != 'none') :
												echo esc_html( $item['duration']); 
											else: 
												echo esc_html__('Variable', 'experience-activities-booking-system'); 
											endif; ?>
										
									</div>
                                </div>
                                <div class="row justify-content-left">
                                    <div class="col-sm-auto">
										<strong><?php echo esc_html__('Cancellation', 'experience-activities-booking-system'); ?>:</strong> <?php if( !empty($item['cancellation']) ) : echo esc_html($item['cancellation']); else : echo esc_html__('Free of charge at any time', 'experience-activities-booking-system'); endif; ?> </div>
                                </div>
                                <div class="row justify-content-left">
                                    <div class="col-sm-auto">
										<strong><?php echo esc_html__('Payment', 'experience-activities-booking-system'); ?>:</strong> <?php if( !empty($item['payment_modality']) ) : echo esc_html($item['payment_modality']); else : echo esc_html__('At the activity provider', 'experience-activities-booking-system'); endif; ?>
									</div>
                                </div>
                                <div class="row justify-content-left mb-3">
                                    <div class="col-sm-auto eabs__payment-img">
                                        <strong><?php echo esc_html__('Payment methods', 'experience-activities-booking-system'); ?>:</strong><?php
                                        if (isset($item['paymentmethods']) && !empty($item['paymentmethods']) && in_array("Stripe", $item['paymentmethods'])): echo esc_html__('At the time of booking', 'experience-activities-booking-system');
                                        elseif( isset($item['paymentmethods']) && !empty($item['paymentmethods']) ):
                                            foreach ($item['paymentmethods'] as $k_inner => $v_inner) :
                                                echo '&nbsp; <img src="https://drlhqgc7z3iss.cloudfront.net'.'/site-assets/'.esc_attr($v_inner).'.jpg" alt="'.esc_attr($v_inner).'" height="25" data-toggle="tooltip" data-placement="top" title="" class="eabs_payment-method" data-original-title="'.esc_attr($v_inner).'">';
                                            endforeach;
                                        endif; ?>                                
                                    </div>
                                </div><?php

                                if( isset($item['warning']) ):
                                    if( $item['warning'] == "price decreased" ): ?>
                                        <div class="eabs_alert-success" role="alert"><?php
                                            echo esc_html__('The price of this activity has decreased', 'experience-activities-booking-system'); ?>
                                        </div><?php
                                    elseif( $item['warning']=="price increased" ): ?>
                                        <div class="eabs_alert-danger" role="alert"><?php
                                            echo esc_html__('The price of this activity has increased', 'experience-activities-booking-system'); ?>
                                        </div><?php
                                    endif;
                                endif;
                                ?>
                            </div><?php
                        else:
                            if( isset($item['error']) ): ?>
                                <div class="eabs_alert-danger" role="alert"><?php
                                    if( $item['error'] == "not enough availability" ):
                                        echo esc_html__('No longer available', 'experience-activities-booking-system');
                                    elseif( $item['error'] == "item does not exist" ):
                                        echo esc_html__('Activity not available anymore', 'experience-activities-booking-system');
                                    elseif( $item['error'] == "pastdate" ):
                                        echo esc_html__('This activity has been removed from the shopping cart because it has already taken place', 'experience-activities-booking-system');
                                    endif; ?>
                                </div><?php
                            endif;
                        endif; ?>
                    </div><?php
                } ?>

                <div class="eabs_cart-footer">
                    <div class="col-sm-auto">
                        <h5 class="eabs_heading-nospace">
                            <?php echo esc_html__('Total', 'experience-activities-booking-system'); ?>
                            <?php echo esc_html(': '.$cart_items['currency'].' '.number_format($cart_items['total'], 2, '.', ',')); ?>
                        </h5>
                        <?php if ($stripe_order_total!==''): ?>
                            <h5 class="eabs_heading-nospace">
                            <?php echo esc_html__('Payable now', 'experience-activities-booking-system'); ?>
                            <?php echo esc_html(': '.$cart_items['currency'].' '.number_format($stripe_order_total, 2, '.', ',')); ?>
                        </h5>
                        <?php endif; ?>
                
                        <h6 class="eabs_heading-nospace">
                            <?php echo esc_html__('VAT', 'experience-activities-booking-system'); ?>
                            <?php echo esc_html(': '.$cart_items['currency'].' '.number_format($cart_items['total_vat'], 2, '.', ',')); ?>
                        </h6>                                    
                    </div>
                </div><?php
            else: ?>
                <p><?php echo esc_html__('The shopping cart is empty','experience-activities-booking-system'); ?></p><?php
            endif;
            ?>
        </div>
    </div><?php

    if( !empty($all_items) ): ?>
        <div class="container mt-2 <?php if ($stripe_order_total==''): echo esc_attr('eabs_booking-form');  endif; ?>">
            <h3 class="eabs_heading-nospace"><?php echo esc_html__('Complete booking', 'experience-activities-booking-system'); ?></h3>
            <form class="justify-content-center needs-validation" action='<?php if ($stripe_order_total!=''): echo esc_attr($stripe_payment_url)  ;elseif( !empty($checkout_page) ) : echo esc_attr(get_permalink($checkout_page)); endif; ?>' method='POST'>
                <h4 class="eabs_heading-nospace"><?php echo esc_html__('Contact details', 'experience-activities-booking-system'); ?></h4>
                <div class="form-group mt-3">
                    <label for="firstname">
                        <strong><?php echo esc_html__('First name', 'experience-activities-booking-system'); ?> *</strong>
                    </label>
                    <input type="text" class="form-control rounded-0" id="eabs_firstname" name="eabs_firstname" placeholder="<?php echo esc_html__('Enter first name', 'experience-activities-booking-system'); ?>" required>
                    <div class="eabs_invalid-feedback">
                    <?php echo esc_html__('Please enter your first name', 'experience-activities-booking-system'); ?>
                    </div>
                </div>
                <div class="form-group mt-3">
                    <label for="lastname">
                        <strong><?php echo esc_html__('Last name', 'experience-activities-booking-system'); ?> *</strong>
                    </label>
                    <input type="text" class="form-control rounded-0" id="eabs_lastname" name="eabs_lastname" placeholder="<?php echo esc_html__('Enter last name', 'experience-activities-booking-system'); ?>" required>
                    <div class="eabs_invalid-feedback">
                    <?php echo esc_html__('Please enter your last name', 'experience-activities-booking-system'); ?>
                    </div>
                </div>
                <div class="form-group mt-3">
                    <label for="email">
                        <strong><?php echo esc_html__('Email address', 'experience-activities-booking-system'); ?> *</strong>
                    </label>
                    <input type="email" class="form-control rounded-0" id="eabs_email" name="eabs_email" placeholder="<?php echo esc_html__('Enter email address', 'experience-activities-booking-system'); ?>" required>
                    <div class="eabs_invalid-feedback">
                    <?php echo esc_html__('Please enter your email address', 'experience-activities-booking-system'); ?>
                    </div>
                </div>
                <div class="form-check mt-3">
                    <input class="form-check-input rounded-0 eabs_accept_policy" type="checkbox" id="tcs" name="eabs_accept_policy" required>
                    <label class="form-check-label" for="tcs">
                        <?php

                        printf(
                            esc_html__( "By continuing, I accept uppliv's %1s and %2s.", 'experience-activities-booking-system' ),
                            sprintf(
                                '<a href="#privacymodal" role="button" class="eabs_cart-popup" data-hide="tcmodal" data-target="privacymodal">%s</a>',
                                esc_html__( 'privacy policy', 'experience-activities-booking-system' )
                            ),
                            sprintf(
                                '<a href="#tcmodal" role="button" class="eabs_cart-popup" data-hide="privacymodal" data-target="tcmodal">%s</a>',
                                esc_html__( 'terms and conditions', 'experience-activities-booking-system' )
                            )
                        );

                        if( !empty($TS_PP_content) ):
                            foreach ($TS_PP_content as $TS_key => $TS_value):
                                $modal_title = ( $TS_key == 'data_protection_policy' ) ? 'Privacy policy' : 'Terms and conditions';
                                $modal_id = ( $TS_key == 'data_protection_policy' ) ? 'privacymodal' : 'tcmodal'; ?>
                                <div class="eabs_modal" id="<?php echo esc_attr($modal_id); ?>" style="display: none;">
                                    <div class="header">
                                        <h5 class="eabs_heading-nospace"><?php echo esc_html__($modal_title, 'experience-activities-booking-system' ); ?></h5>
                                        <a href="#" class="cancel"><?php echo esc_html('X'); ?></a>
                                    </div>
                                    <div class="modal-body">
                                        <?php echo $TS_value; ?>
                                    </div>
                                </div><?php
                            endforeach;
                        endif; ?>
                    </label>
                    <div class="eabs_invalid-feedback">
                        <?php echo esc_html__('Please confirm that you agree to the privacy policy and terms and conditions', 'experience-activities-booking-system'); ?>
                    </div>
                </div>
                <input type="hidden" name="eabs_cartid" value="<?php echo esc_html($cart_id); ?>">
                <button type="submit" class="btn btn-outline-dark rounded-0 mt-3 mb-3 eabs_cart-booknow"><?php echo esc_html__('Book now', 'experience-activities-booking-system'); ?></button>
            </form>
        </div><?php
    endif; ?>
</div>
<?php get_footer(); ?>