<td class="<?php echo esc_attr($eabs_success); ?>"><?php
	$json_encode_data = array(
		'activity_id' 	=> $activity_id,
		'item_id' 		=> $item_id, 
		'date' 			=> $date,
		'totalquota' 	=> $totalquota
	);

	$select_name = array(
		$activity_id, 
		$item_id, 
		$split_date_full[0], 
		$split_date_full[1], 
		$split_date_full[2], 
		'instantbooking', 
		($instantbooking == 1) ? 'True' : 'False', 
		'regular', 
		$currency, 
		$regularprice
	);

	if( $soldout == false && $regularprice !== NULL ) : ?>
		<a class="eabs_open" href="item<?php echo esc_attr($item_id); ?>-<?php echo esc_attr($date); ?>" 
			data-activity='<?php echo json_encode($json_encode_data); ?>' 
			data-activity_hour="<?php echo esc_attr($item_type); ?>">
			<h5><?php echo esc_html($single_day); ?></h5>
			<small><?php echo esc_html__('from', 'experience-activities-booking-system'); ?></small><br>
			<small><?php echo esc_html($currency); ?></small><br>
			<small class="eabs_regular-price"><?php echo esc_html(number_format($regularprice, 2)); ?></small>
		</a><?php
	else : ?>
		<h5><?php echo esc_html($single_day); ?></h5>
		<small><?php if( $soldout == true ): echo esc_html__('Sold out', 'experience-activities-booking-system'); else: echo esc_html__('Closed', 'experience-activities-booking-system'); endif; ?></small><?php
	endif;
	if( $soldout == false && $regularprice !== NULL ) : ?>
		<div class="eabs_modal">
			<div class="header">
				<h5 class="eabs_heading-nospace"><?php echo esc_html__('Booking details', 'experience-activities-booking-system'); ?></h5>
				<a href="#" class="cancel"><?php echo esc_html('X'); ?></a>
			</div>
			<form>
				<div class="content">
					<div class="modal_header">
						<h6 class="eabs_heading-nospace"><?php echo esc_html($regularname.' '.$currency.' '.number_format($regularprice, 2)); ?></h6>
					</div>
					<div class="">
						<select class="eabs_qty-dropdown eabs_input-type eabd_select-box"
							name="<?php echo esc_attr( eabs_select_generate_name( $select_name ) ); ?>"
							data-activity_id="<?php echo esc_attr($activity_id); ?>" 
							data-language="<?php echo esc_attr($language); ?>" 
							data-activity_item_id="<?php echo esc_attr($item_id); ?>" 
							data-activity_type="<?php echo esc_attr($item_id); ?>" 
							data-activity_date="<?php echo esc_attr($split_date_full[0]); ?>-<?php echo esc_attr($split_date_full[1]); ?>-<?php echo esc_attr($split_date_full[2]); ?>" 
							data-pricecategory="<?php if( $instantbooking == true){ echo esc_attr('regular'); }else{ echo esc_attr('regular'); } ?>" 
							data-activity_currency="<?php echo esc_attr($currency); ?>" 
							data-activity_price="<?php echo esc_attr($item_fromprice); ?>"
						>
							<option value="Select"><?php echo esc_html__('Select', 'experience-activities-booking-system'); ?></option>
							<?php 
							for($i=1; $i<=$totalquota; $i++){
								echo '<option value="'.esc_attr($i).'">'.esc_attr($i).'</option>';
							} ?>
						</select>
					</div><?php

					if(!empty($price_categories) ):
						if( isset($price_categories_translated[$language]) ):
							$price_categories_translated = (array)$price_categories_translated[$language];
						endif;
						
						foreach ($price_categories as $key => $pr_inner) :
							$PC_quota = 0;
							$select_name = array(
								$activity_id, 
								$item_id, 
								$split_date_full[0], 
								$split_date_full[1], 
								$split_date_full[2], 
								'instantbooking', 
								($instantbooking == 1) ? 'True' : 'False', 
								!empty($pr_inner->category) ? $pr_inner->category : 'regular', 
								$currency, 
								$pr_inner->price
							);

							$price_category_name = isset($price_categories_translated[$pr_inner->category]) ? $price_categories_translated[$pr_inner->category] : $pr_inner->category;
							?>							
							<div class="modal_header">
								<h6 class="eabs_heading-nospace">
									<?php echo esc_html( $price_category_name); ?> <?php echo esc_html($currency); ?> <?php echo esc_html(number_format($pr_inner->price, 2)); ?>
								</h6>
							</div>
							<div class="">
								<select class="eabs_qty-dropdown eabs_input-type eabd_select-box"
									name="<?php echo esc_attr( eabs_select_generate_name( $select_name ) ); ?>"
									data-activity_id="<?php echo esc_attr($activity_id); ?>" 
									data-activity_item_id="<?php echo esc_attr($item_id); ?>" 
									data-language="<?php echo esc_attr($language); ?>" 
									data-activity_type="<?php echo esc_attr($item_id); ?>" 
									data-activity_date="<?php echo esc_attr($split_date_full[0]); ?>-<?php echo esc_attr($split_date_full[1]); ?>-<?php echo esc_attr($split_date_full[2]); ?>" 
									data-pricecategory="<?php if( !empty($pr_inner->category) ){ echo esc_attr($pr_inner->category); }else{ echo esc_attr('regular'); } ?>" data-activity_currency="<?php echo esc_attr($currency); ?>" 
									data-activity_price="<?php echo esc_attr($pr_inner->price); ?>">
									<option value="Select"><?php echo esc_html__('Select', 'experience-activities-booking-system'); ?></option><?php
										if( $itemdetails['totalquota'] == "onrequest" or $itemdetails['totalquota'] == "unlimited" ) :
											$PC_quota = 9;
										elseif( $itemdetails['linked'] == true ) :
											if( $itemdetails['totalquota'] > 9 ) :
												$PC_quota = 9;
											else :
												$PC_quota = $itemdetails['totalquota'];
											endif;
										elseif( $itemdetails['linked'] == false ) :
											if( $pr_inner->quota > 9 ) :
												$PC_quota = 9;
											else :
												$PC_quota = $pr_inner->quota;
											endif;
										endif;

										for( $i=1; $i<=$PC_quota; $i++):
											echo '<option value="'.esc_attr($i).'">'.esc_html($i).'</option>';
										endfor; ?>
								</select>
							</div><?php
						endforeach;
					endif; ?>

					<div class="modal_header">
						<h6 class="eabs_heading-nospace"><?php echo esc_html__('Select the time you’d like to complete the activity', 'experience-activities-booking-system'); ?></h6>
					</div>
					<div class="eabs_time">
						<select class="eabs_time-box eabs_input-type" id="<?php echo esc_attr( eabs_select_generate_name( array( $activity_id, $item_id, $split_date_full[0], $split_date_full[1], $split_date_full[2], 'time') ) ); ?>">
							<?php _e($time_dropdown, 'experience-activities-booking-system'); ?>
						</select>
					</div><?php

					if( $pickup ) : ?>
						<div class="modal_header">
							<h6 class="eabs_heading-nospace"><?php echo esc_html__('Please enter the address that you’d like to be picked up from', 'experience-activities-booking-system'); ?>:</h6>
						</div>
						<div class="">
							<input type="text" class="form-control rounded-0 eabs_input-type" id="eabs_pickup" name="eabs_pickup" placeholder="<?php echo esc_attr__('Enter your pick-up location', 'experience-activities-booking-system'); ?>" required="">
						</div><?php
					endif; ?>
				</div>
				<div class="footer">
					<button type="submit" class="btn rounded-0 btn-dark eabs_add-cart eabs_footer-btn"><?php echo esc_html__('Add to shopping cart', 'experience-activities-booking-system'); ?></button>
				</div>
			</form>
		</div><?php
	endif; ?>

</td>