<div class="wrap _di_shortcode_settings">
    <h2><?php echo esc_html__('Experience & Activities booking system', 'experience-activities-booking-system'); ?></h2>
    <h3><?php echo esc_html__('Getting started', 'experience-activities-booking-system'); ?></h3>
    <iframe width="560" height="315" src="<?php echo esc_url('https://www.youtube.com/embed/y9b-AybXexE'); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>    <h3><?php echo esc_html__('Sign-up', 'experience-activities-booking-system'); ?></h3>
    <div><a href="<?php echo esc_url('https://cms.uppliv.com/'); ?>" target="_blank"><?php echo esc_html__('Click here', 'experience-activities-booking-system'); ?></a></div>
    <h3><?php echo esc_html__('Create & manage your activities', 'experience-activities-booking-system'); ?></h3>
    <div><a href="<?php echo esc_url('https://cms.uppliv.com/cms/'); ?>" target="_blank"><?php echo esc_html__('Click here', 'experience-activities-booking-system'); ?></a></div>
    <h3><?php echo esc_html__('Manage your bookings', 'experience-activities-booking-system'); ?></h3>
    <div><a href="<?php echo esc_url('https://cms.uppliv.com/manage/orders/'); ?>" target="_blank"><?php echo esc_html__('Click here', 'experience-activities-booking-system'); ?></a></div>
    <div class="_di_shortcode_settings-form">
        <form action="" method="post" id="di_settings-form">
            <!-- General Settings options  -->
            <div id="di_general" class="di_tabcontent">
                <h3><?php echo esc_html__('General Settings', 'experience-activities-booking-system'); ?></h3>
                <table>
                    <tr>
                        <td><?php echo esc_html__('WordPress plug-in token', 'experience-activities-booking-system' ); ?></td>
                        <td><input type="text" required name="eabs_shortcode_key" value="<?php echo $_EABS_shortcode_key; ?>" /></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__('Enter API Domain URL', 'experience-activities-booking-system' ); ?></td>
                        <td><input type="url" required name="eabs_shortcode_domain" value="<?php echo $_EABS_shortcode_domain; ?>" /></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__('Enter QR Domain URL', 'experience-activities-booking-system' ); ?></td>
                        <td><input type="url" required name="eabs_shortcode_qr_domain" value="<?php echo $_EABS_shortcode_qr_domain; ?>" /></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__('Select cart page', 'experience-activities-booking-system'); ?></td>
                        <td>
                            <select name="eabs_shortcode_cart_page">
                                <option value=""><?php echo esc_attr('----' ); ?></option>
                                <?php 
                                $pages = get_pages(); 
                                foreach ( $pages as $page ) {

                                    if( $page->ID == $_EABS_shortcode_cart_page ){ 
                                        $sel = 'selected'; 
                                    }else{
                                        $sel = '';
                                    }

                                    $option = '<option value="' . esc_attr($page->ID) . '" '.esc_attr($sel).'>';
                                    $option .= esc_html($page->post_title);
                                    $option .= '</option>';
                                    echo $option;
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__('Select confirmation page', 'experience-activities-booking-system'); ?></td>
                        <td>
                            <select name="eabs_shortcode_checkout_page">
                                <option value=""><?php echo esc_attr('----'); ?></option>
                                <?php 
                                $pages = get_pages(); 
                                foreach ( $pages as $page ) {

                                    if( $page->ID == $_EABS_shortcode_checkout_page ){ 
                                        $sel = 'selected'; 
                                    }else{
                                        $sel = '';
                                    }

                                    $option = '<option value="' . esc_attr($page->ID) . '" '.esc_attr($sel).'>';
                                    $option .= esc_html($page->post_title);
                                    $option .= '</option>';
                                    echo $option;
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__('Display shopping cart in the page header', 'experience-activities-booking-system'); ?></td>
                        <td>
                            <label class="eabs_switch" for="checkbox">
                                <input type="checkbox" id="eabs_show_cart_icon" name="eabs_show_cart_icon" <?php if($_eabs_show_cart_icon){ echo esc_attr('checked'); } ?> />
                                <div class="eabs_slider eabs_round"></div>
                            </label>
                        </td>
                    </tr>
                </table>
            </div>

            <table>
                <tr>
                    <td>
                        <?php submit_button('','primary di_settings-save'); ?>
                    </td>
                    <td><?php wp_nonce_field( 'API_settings_nonce' ); ?></td>
                </tr>
            </table>
        </form>
    </div>
    <h3><?php echo esc_html__('Support', 'experience-activities-booking-system'); ?></h3>
    <div><?php echo esc_html__('If you encounter issues please raise a support ticket on our WordPress.org plug-in page. For support please contact', 'experience-activities-booking-system'); ?> <a href="mailto:support@uppliv.com"><?php echo esc_html('support@uppliv.com'); ?></a></div>
</div>