<?php
if( !function_exists( 'eabs_get_template' ) ) : 
   
    function eabs_get_template( $template_name, $args = array(), $template_path = '' ) {
        if( empty( $template_path ) ) :
            $template_path = EABS_PATH . '/templates/';
        endif;        
        
        $template = $template_path . $template_name;
        if ( ! file_exists( $template ) ) :
            return new WP_Error( 
                'error', 
                sprintf( 
                    __( '%s does not exist.', EABS_TEXTDOMAIN ), 
                    '<code>' . $template . '</code>' 
                ) 
            );
        endif;

        do_action( 'eabs_before_template_part', $template, $args, $template_path );

        if ( ! empty( $args ) && is_array( $args ) ) :
            extract( $args );
        endif;
        include $template;

        do_action( 'eabs_after_template_part', $template, $args, $template_path );
    }

endif;

if( !function_exists( 'eabs_hours_minutes_time' ) ) : 

    function eabs_hours_minutes_time( $hours = 0, $minutes = 0, $format = '%02d:%02d' ){
        $time = ( $hours * 60 ) + $minutes;

        if ($time < 1) {
            return;
        }
        $hours = floor($time / 60);
        $minutes = ($time % 60);

        if( $minutes == 00 ):
            return sprintf('%02d hours', $hours, $minutes);
        else:
            return sprintf('%02d hours %02d minutes', $hours, $minutes);
        endif;

    }

endif;

if( !function_exists( 'eabs_select_generate_name' ) ) : 

    function eabs_select_generate_name( $parameter = array() ){
        $name = '';

        if( !empty($parameter) ):
            foreach ($parameter as $key => $value) {
                $name .= $value.'(-)';
            }
        endif;

        return sprintf( '%s', rtrim($name, '(-)') );
    }

endif;

if( !function_exists( 'eabs_hours_convert' ) ) : 

    function eabs_hours_convert($time) {
        $explode = explode(':', $time);
        $hour = (int)$explode[0];
        $min = (int)$explode[1];
        $minutes = 0;
        if( $hour != 0 || $hour != 00 ){
            $minutes = $hour*60;
            $minutes += $min;
        }else{
            $minutes = $min;
        }
        
        if ($minutes < 1) {
            return;
        }
        $hours = floor($minutes / 60);
        $minutes = ($minutes % 60);
        
        if($hour > 0 && $min > 0 ){
            return sprintf('%01d hours %02d minutes', $hours, $minutes);
        }else if($hour > 0){
            return sprintf('%01d hours', $hours);
        }else if($min > 0){
            return sprintf('%01d minutes', $minutes);
        }
    }

endif;

if( !function_exists( 'eabs_new_nav_menu_items' ) ) : 

    function eabs_new_nav_menu_items($items) {
        $_eabs_show_cart_icon           = !empty( get_option( '_eabs_show_cart_icon' ) ) ? ( esc_html(get_option( '_eabs_show_cart_icon' )) ) : '';

        if( $_eabs_show_cart_icon ){
            $cart_page_id   = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $homelink       = '';

            $cart_obj_cnt = new WPEABS_Cart_View();
            $item_count = $cart_obj_cnt->eabs_get_cart_items_count();

            if( !empty($cart_page_id) ){
                $homelink = '<li class="menu-item-'.esc_attr($cart_page_id).' eabs_cart-li">
                    <a href="'.esc_url(get_permalink($cart_page_id)).'" class="eabs_cart-menu" aria-label="View your shopping cart">
                        <i class="fa fa-shopping-cart"></i>
                        <span class="cart-basket d-flex align-items-center justify-content-center">'.esc_html($item_count).'</span>
                    </a>
                </li>';
            }
            $items = $items . $homelink;
        }
        return $items;
    }
    add_filter( 'wp_nav_menu_items', 'eabs_new_nav_menu_items' );
endif;

if( !function_exists( 'eabs_content_filter_language' ) ) :

    function eabs_content_filter_language( $lang_txt = 'en' ){
        global $locale;
        
        $lang_array = array(
            'en_US' => 'en',
            'de_DE' => 'de',
            'fr_FR' => 'fr',
            'it_IT' => 'it',
            'ja'    => 'ja',
            'pt_PT' => 'pt',
            'sv_SE' => 'sv',
            'zh_CN' => 'zh',
        );
        
        if( array_search($lang_txt, $lang_array) ){
            $lang_txt = array_search($lang_txt, $lang_array);
        }else{
            $lang_txt = 'en';
        }
        
        $locale = $lang_txt;
        switch_to_locale( $lang_txt );

        EABS_load_text_domain();
    }
    
endif;

if( !function_exists( 'eabs_time_language_localization' ) ) :

    function eabs_time_language_localization( $time = '', $lang_txt = 'en' ){       
        $lang_array = array(
            'en_US' => 'en',
            'de_DE' => 'de',
            'fr_FR' => 'fr',
            'it_IT' => 'it',
            'ja'    => 'ja',
            'pt_PT' => 'pt',
            'sv_SE' => 'sv',
            'zh_CN' => 'zh',
        );
		
        if( array_search($lang_txt, $lang_array) != 'en_US' && array_search($lang_txt, $lang_array) != 'zh_CN' ){
            $time = date('H:i', strtotime($time));    
        }elseif( array_search($lang_txt, $lang_array) == 'zh_CN' ){
            $time = date('g:i', strtotime($time));    
            $ZN_time = date('H', strtotime($time));
            if ($ZN_time < "12") {
                $time = '<span>'.esc_html__( "morning", 'experience-activities-booking-system').'</span>'.$time;
            }else{
                $time = '<span>'.esc_html__( "afternoon", 'experience-activities-booking-system').'</span>'.$time;
            }
        }else{
            $time = date('g:i A', strtotime($time)); 
        }
        
        return $time;
    }
    
endif;

if (!function_exists('eabs_query_vars')) :
    function eabs_query_vars($qvars) {
$qvars[] = "email";
$qvars[] = "orderid";
return $qvars;
    }
add_filter('query_vars', 'eabs_query_vars');
endif;