<?php

if (!class_exists('WPEABS_Admin_View')) {

    class WPEABS_Admin_View{
        
        public $authenticat_key = '';
        public $api_endpoint    = '';
        
        function __construct() {
            $_EABS_shortcode_domain = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';

            if( !empty($_EABS_shortcode_domain) ):
                $this->api_endpoint = rtrim($_EABS_shortcode_domain, '/').'/api/v1.3/offer/search/details';
            else:
                $this->api_endpoint = '';
            endif;
            /** Initialize */
            $this->EABS_init();
        }

        public function EABS_init(){
            add_action( 'template_redirect', array( $this, 'eabs_language_redirect' ) );
            add_action( 'wp_head', array( $this, 'eabs_add_meta_box' ) );
            add_action( 'wp_footer', array( $this, 'eabs_enqueue_shortcode_scripts' ) );
            add_shortcode( 'EABS_activity', array( $this, 'eabs_shortcode_content' ) , 99, 1 );
        }

        public function eabs_add_meta_box() { ?>
            <meta name="viewport" content="width=device-width, initial-scale=1.0"><?php
        }

        public function eabs_enqueue_shortcode_scripts() {
            wp_enqueue_style( 'eabs-font-awesome-css', EABS_URL . 'assets/font-awesome.min.css' );
            wp_enqueue_style( 'eabs-plugin-css', EABS_URL . 'assets/course-grid.css' );
            wp_enqueue_script( 'eabs-plugin-script', EABS_URL . 'assets/eabs_script.js', array('jquery'), '1.1.0', true  );
        }

        public function EABS_get_user_data(){
            $udata['EABS_shortcode_key']            = !empty( get_option( '_eabs_shortcode_key' ) ) ? ( esc_html(get_option( '_eabs_shortcode_key' )) ) : '';
            $udata['EABS_shortcode_cart_page']      = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $udata['EABS_shortcode_checkout_page']  = !empty( get_option( '_eabs_shortcode_checkout_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_checkout_page' )) ) : '';
            $udata['EABS_content_language']         = !empty( get_option( '_eabs_content_language' ) ) ? ( esc_html(get_option( '_eabs_content_language' )) ) : '';

            return $udata;
        }

        public function EABS_shortcode_content__EABS_call($content_language = '', $oid = '', $startdate = ''){
            $authenticat_key    = '';
            $api_data           = array();
            $easb_obj           = new WPEABS_Admin_Integration();
            $au_key             = $this->EABS_get_user_data();

            if( !empty($au_key) && isset($au_key['EABS_shortcode_key']) ){
                $authenticat_key = $au_key['EABS_shortcode_key'];
            }
            if( empty($content_language) ){
                if( !empty($au_key) && isset($au_key['EABS_content_language']) ){
                    $content_language = $au_key['EABS_content_language'];
                }
            }
            
            $api_data = array(
                'api_key'   => $authenticat_key,
                'language'  => $content_language,
                'oid'       => $oid,
                'startdate' => $startdate,
            );
            
            $api_response = $easb_obj->EABS_curl_init($api_data, true);

            return $api_response;
        }

        public function eabs_language_redirect() {
            $cart_page_id       = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $checkout_page_id   = !empty( get_option( '_eabs_shortcode_checkout_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_checkout_page' )) ) : '';
            $user_data          = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';

            if( !empty($user_data) ){
                $cart_id = $user_data;
            }else{
                $cart_id = '';
            }
            
            if( is_page() && get_the_ID() == $cart_page_id ){
                $get_cart       = new WPEABS_Cart_View();
                $cart_items     = $get_cart->eabs_get_cart_items();
                $lang           = ( isset($cart_items['language']) && !empty($cart_items['language']) ) ? sanitize_text_field($cart_items['language']) : sanitize_text_field('en');

                $postfields     = '{
                    "language": "'.$lang.'"
                }';
                $post_type      = 'POST';
                $endpoint       = '/api/v1.1/compliancetexts';
                $TS_PP_content  = $get_cart->eabs_run_curl_operation($postfields, $endpoint, $post_type, true);

                eabs_content_filter_language($lang);
                eabs_get_template(
                    'frontend/template-cart.php',
                    array(
                        'template_name' => 'cart',
                        'cart_items'    => $cart_items,
                        'cart_id'       => $cart_id,
                        'checkout_page' => $checkout_page_id,
                        'TS_PP_content' => $TS_PP_content,
                    )
                );
                exit;
            }else if( is_page() && get_the_ID() == $checkout_page_id ){
                
                $get_checkout = new WPEABS_Checkout_View();
                $checkout_items = $get_checkout->get_checkout_items();
                $lang = ( isset($checkout_items['language']) && !empty($checkout_items['language']) ) ? $checkout_items['language'] : 'en';

                eabs_content_filter_language($lang);

                eabs_get_template(
                    'frontend/template-checkout.php',
                    array(
                        'template_name'     => 'checkout',
                        'checkout_items'    => $checkout_items,
                        'cart_id'           => $cart_id
                    )
                );
                exit;
            }
        }

        public function eabs_shortcode_content( $atts = array() ){
            ob_start();
            $au_key = $this->EABS_get_user_data();
            $api_data = array();
            
            extract( shortcode_atts( 
                array(
                    'language'  => '',
                    'oid'       => '',
                    'startdate' => date('Y-m-d'),
                ),$atts
            ));
            
            if( empty($language) ):
                $language = $this->eabs_get_site_language();
            endif;

            eabs_content_filter_language($language);
            $response = $this->EABS_shortcode_content__EABS_call($language, $oid, $startdate);

            eabs_get_template(
                'frontend/template-single_activity.php',
                array(
                    'template_name' => 'single_activity',
                    'template_data' => json_encode($response),
                    'language'      => $language,
                    'obj_class'     => $this,
                )
            );

            return ob_get_clean();
        }

        public function eabs_create_options_for_time($opening_hours, $day_name){
            ob_start();
            
            if( isset($opening_hours[$day_name]) ) :
                foreach ($opening_hours[$day_name] as $hours_key => $hours_value):
                    if( isset($hours_value) ) :
                        $get_opening_hours 	= $hours_value;
                        $starttime 			= $get_opening_hours->opens;
                        $endtime 			= $get_opening_hours->closes;
                        $starttimelist 		= explode( ':', $starttime);
                        $endtimelist 		= explode( ':', $endtime);

                        if($starttimelist[0] == $endtimelist[0] and $starttimelist[1] == $endtimelist[1]) :
                            echo '<option value="'.esc_attr($starttimelist[0].':'.$starttimelist[1]).'">'.esc_html($starttimelist[0].':'.$starttimelist[1]).'</option>';
                        else :
                            for( $time = $starttimelist[0]; $time <= ($endtimelist[0]+1); $time++ ) :
                                if( $time == $starttimelist[0] && $starttimelist[1] == "00" ) :
                                    echo '<option value="'.esc_attr($time.':00').'">'.esc_html($time.':00').'</option>';
                                    echo '<option value="'.esc_attr($time.':30').'">'.esc_html($time.':30').'</option>';
                                elseif( $time == $starttimelist[0] && $starttimelist[1] == "30" ):
                                    echo '<option value="'.esc_attr($time.':30').'">'.esc_html($time.':30').'</option>';
                                elseif( $time < $endtimelist[0] ) :
                                    echo '<option value="'.esc_attr($time.':00').'">'.esc_html($time.':00').'</option>';
                                    echo '<option value="'.esc_attr($time.':30').'">'.esc_html($time.':30').'</option>';
                                elseif( $time == $endtimelist[0] && $endtimelist[1] == "30" ) :
                                    echo '<option value="'.esc_attr($time.':00').'">'.esc_html($time.':00').'</option>';
                                endif;
                            endfor;
                        endif;
                    endif;
                endforeach;
            endif;

            return ob_get_clean();            
        }

        public function eabs_get_site_language(){
            $eabs_lang  = !empty( get_option( '_eabs_content_language' ) ) ? ( esc_html(get_option( '_eabs_content_language' )) ) : 'en';
            $admin_obj  = new WPEABS_Admin_Integration();
            $lang       = $admin_obj->EABS_get_language_list();
            
            if( !array_key_exists($eabs_lang, $lang) ):
                $eabs_lang   = 'en';
            endif;

            return $eabs_lang;
        }
    }

    new WPEABS_Admin_View();
}
?>