<?php

if (!class_exists('WPEABS_Checkout_View')) {

    class WPEABS_Checkout_View{
        
        public $authenticat_key = '';
        public $api_endpoint    = '';

        public function get_checkout_items(){
            $obj_admin = new WPEABS_Admin_Integration();
            $this->api_endpoint = $obj_admin->EABS_create_endpoint(true);

            $user_data = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
            $res = array();
            if (empty($user_data) && get_query_var('orderid')==='' ) {
                $res = esc_html('Not found any items in checkout.');
            }else{

                if( isset($_POST['eabs_firstname']) && !empty($_POST['eabs_firstname']) && 
                    isset($_POST['eabs_lastname'])  && !empty($_POST['eabs_lastname']) && 
                    isset($_POST['eabs_email'])     && !empty($_POST['eabs_email']) && 
                    isset($_POST['eabs_cartid'])    && !empty($_POST['eabs_cartid'])  ){
                    $get_cart_id    = sanitize_text_field($_POST['eabs_cartid']);
                    $post_type      = 'POST';
                    $endpoint       = '/api/v1.3/cart/checkout';
                    $postfields     = '{
                        "cartid": "'.sanitize_text_field($get_cart_id).'",
                        "email": "'.sanitize_email($_POST['eabs_email']).'",
                        "firstname": "'.sanitize_text_field($_POST['eabs_firstname']).'",
                        "lastname": "'.sanitize_text_field($_POST['eabs_lastname']).'"
                    }';

                    $obj_cart_curl = new WPEABS_Cart_View();
                    $res = $obj_cart_curl->eabs_run_curl_operation( $postfields, $endpoint, $post_type, true );

                    $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                    setcookie('eabs_cart_id', '', time()-3600, '/', $eabs_domain, false);
                } elseif (
                    get_query_var('orderid')!=='' && 
                    get_query_var('email')!==''
                ) {
                    $get_cart_id    = get_query_var('orderid');
                    $post_type      = 'POST';
                    $endpoint       = '/api/v1/order/get';
                    $postfields     = '{
                        "orderid": "'.$get_cart_id.'",
                        "email": "'.get_query_var('email').'"
                    }';

                    $obj_cart_curl = new WPEABS_Cart_View();
                    $res = $obj_cart_curl->eabs_run_curl_operation( $postfields, $endpoint, $post_type, true );

                    $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                    setcookie('eabs_cart_id', '', time()-3600, '/', $eabs_domain, false);
                }else{
                    $res = esc_html('Something went wrong.');
                }
            }

            return $res;
        }

    }

    new WPEABS_Checkout_View();
}
?>