<?php

if (!class_exists('WPEABS_Cart_View')) {

    class WPEABS_Cart_View{
        
        public $authenticat_key = '';
        // public $api_endpoint    = 'https://www.uppliv.com/';
        public $api_endpoint    = '';

        function __construct() {
            $_EABS_shortcode_domain = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';

            if( !empty($_EABS_shortcode_domain) ):
                $this->api_endpoint = rtrim($_EABS_shortcode_domain, '/');
            else:
                $this->api_endpoint = 'https://www.uppliv.com/';
            endif;
            /** Initialize */
            $this->eabs_cart_init();
        }

        public function eabs_cart_init(){
            // ----------- Ajax for create or add item in cart ---------------
            add_action( 'wp_ajax_nopriv_eabs_add_item_to_cart', array( $this, 'eabs_add_item_to_cart_func') );
            add_action( 'wp_ajax_eabs_add_item_to_cart', array( $this, 'eabs_add_item_to_cart_func') );
        }

        public function eabs_add_item_to_cart_func(){
            $cart_item  = array();
            $language   = isset($_POST['language']) ? sanitize_text_field($_POST['language']) : 'en';
            if( isset($_POST['cart_data']) && !empty($_POST['cart_data']) ):
                foreach($_POST['cart_data'] as $key => $data){
                    $cart_item[$key]['_id']             = $data['_id'];
                    $cart_item[$key]['item_id']         = $data['item'];
                    $cart_item[$key]['date']            = $data['date'];
                    $cart_item[$key]['time']            = $data['time'];
                    $cart_item[$key]['pricecategory']   = $data['pricecategory'];
                    $cart_item[$key]['unitprice']       = $data['unitprice'];
                    $cart_item[$key]['qty']             = $data['qty'];
                    $cart_item[$key]['wp_page_url']     = $data['wp_page_url'];
                    $cart_item[$key]['pickup']          = $data['pickup'];
                }
            endif;
            $eabs_api_key   = !empty( get_option( '_eabs_shortcode_key' ) ) ? ( esc_html(get_option( '_eabs_shortcode_key' )) ) : '';
            if( !empty($cart_item) && isset($cart_item) ):
                $cart_data  = array(
                    'language'      => $language,
                    'cart_items'    => $cart_item,
                    'api_key'       => $eabs_api_key
                );
                $cart_response = $this->eabs_cart_curl_oprtatin($cart_data);

                if( strpos($cart_response, 'Unable to add item to') >= 0 ){
                    echo esc_html($cart_response);
                }else if( $cart_response == true ){
                    echo esc_html('true');
                }else{
                    echo esc_html('false');
                }
            else:
                echo esc_html('false');
            endif;
            die;
        }

        public function eabs_cart_curl_oprtatin( $api_data = array() ){
            $items      = '';
            $user_data  = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
            $lang       = isset($api_data['language']) ? sanitize_text_field($api_data['language']) : 'en';
            if( !empty($api_data) && isset($api_data['cart_items']) ){
                foreach ($api_data['cart_items'] as $key => $value) {
                    $items .= '{
                        "_id": "'.$value['_id'].'",
                        "item": "'.$value['item_id'].'",
                        "date": "'.$value['date'].'",
                        "time": "'.$value['time'].'",
                        "pricecategory": "'.$value['pricecategory'].'",
                        "unitprice": '.$value['unitprice'].',
                        "qty": '.$value['qty'].',
                        "wp_page_url": "'.$value['wp_page_url'].'",
                        "pickup": "'.$value['pickup'].'"
                    },';
                }
            }
            $items = rtrim($items, ",");
            if (!empty($user_data) ) {
                $this->eabs_get_cart_items_count();
                $user_data  = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
            }

            if (empty($user_data) ) {
                
                $post_id = get_option('_eabs_shortcode_checkout_page');
				$post = get_post($post_id);
                $post_name = $post->post_name;
                $postfields = '{
                    "language": "'.$lang.'",
                    "items": [ '.$items.' ],
                    "wp_callback_url": "'.get_site_url().'/'.$post_name.'"
                }';
                $post_type      = 'POST';
                $endpoint       = '/api/v1.3/cart/create';
            }else{

                $get_cart_id    = $user_data;
                
                $postfields     = '{
                    "cartid": "'.$get_cart_id.'",
                    "items": [ '.$items.' ]
                }';
                $post_type      = 'PATCH';
                $endpoint       = '/api/v1.3/cart/item/add';
            }

            $res = $this->eabs_run_curl_operation($postfields, $endpoint, $post_type);
            return $res;
        }

        // ---------------- Curl operation
        public function eabs_run_curl_operation($postfields = '', $endpoint = '', $post_type = 'POST', $return = false){
            $obj_admin = new WPEABS_Admin_Integration();
            $this->api_endpoint = $obj_admin->EABS_create_endpoint(true);

            $endpoint_parameter = $endpoint;
            $endpoint           = $this->api_endpoint.$endpoint;

            $eabs_api_key       = !empty( get_option( '_eabs_shortcode_key' ) ) ? ( esc_html(get_option( '_eabs_shortcode_key' )) ) : '';
            $res = '';

            $args = array(
                'method'        => $post_type,
                'headers'       => array(
                    'Content-Type'  => 'application/json',
                    'Authorization' => 'Bearer '.$eabs_api_key,
                ),
                'body'          => $postfields,
            );
            $response = wp_remote_get( $endpoint, $args );
            if ( is_wp_error( $response ) ) {
                $error_message = $response->get_error_message();
                $res = "Something went wrong: $error_message";
            } else {
                $res    = json_decode( wp_remote_retrieve_body($response), JSON_OBJECT_AS_ARRAY );
                $result     = (array)$res;
            }
            
            if( !empty($result) ){
                $user_data  = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
                if( $endpoint_parameter == '/api/v1.3/cart/create' && isset($result['cartid']) && empty($user_data) ){
                    $eabs_domain = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                    setcookie('eabs_cart_id', $result['cartid'], strtotime( '+30 days' ), '/', $eabs_domain, false);
                }
                if( $return == true && !isset($result['message']) ){
                    return $result;
                }else{
                    if( isset($result['message']) ){
                        return $result['message'];
                    }else{
                        return true;
                    }
                }
            }else{
                return false;
            }
        }

        // -------------------------------------
        public function eabs_get_cart_items(){
            $cart_items = array();
            $user_data  = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
            if( !empty($user_data) ):
                if( isset($_POST['changeqty']) && $_POST['changeqty'] && isset($_POST['cartindex']) && !empty($_POST['cartindex'])  && isset($_POST['eabs_item_quantity']) && $_POST['eabs_item_quantity'] >= 0 ){
                    $cartindex          = sanitize_text_field($_POST['cartindex']);
                    $eabs_item_quantity = sanitize_text_field($_POST['eabs_item_quantity']);
                    
                    if( $eabs_item_quantity != 0 ){
                        $postfields     = '{
                            "cartid": "'.$user_data.'",
                            "items": [{"item": '.$cartindex.', "qty": '.$eabs_item_quantity.'}]
                        }';
                        $endpoint       = '/api/v1.3/cart/item/update';
                    }else{
                        $postfields     = '{
                            "cartid": "'.$user_data.'",
                            "items": ['.$cartindex.']
                        }';
                        $endpoint       = '/api/v1.3/cart/item/delete';
                    }

                    $cart_items         = $this->eabs_run_curl_operation($postfields, $endpoint, 'PATCH', true );

                    if( isset($cart_items['items']) && empty($cart_items['items']) ):
                        $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                        setcookie('eabs_cart_id', '', time()-3600, '/', $eabs_domain, false);
                    endif;
                }else{
                    $get_cart_id        = $user_data;
                    $postfields         = '{ "cartid": "'.$get_cart_id.'" }';
                    $cart_items         = $this->eabs_run_curl_operation($postfields, '/api/v1.3/cart/get', 'POST', true );

                    if( isset($cart_items['items']) && empty($cart_items['items']) ):
                        $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                        setcookie('eabs_cart_id', '', time()-3600, '/', $eabs_domain, false);
                    endif;
                }
            else:
                $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                setcookie('eabs_cart_id', '', time()-3600, '/', $eabs_domain, false);
                $cart_items     = sprintf('<p>%s</p>', 'The shopping cart is empty' );
            endif;

            return $cart_items;
        }

        // Get total number cart item
        public function eabs_get_cart_items_count(){
            $cart_items = array();
            $cnt        = 0;
            $user_data  = isset($_COOKIE['eabs_cart_id']) ? sanitize_text_field($_COOKIE['eabs_cart_id']) : '';
            if( !empty($user_data) ):
                $get_cart_id    = $user_data;
                $postfields     = '{ "cartid": "'.$get_cart_id.'" }';
                $cart_items     = $this->eabs_run_curl_operation($postfields, '/api/v1.3/cart/get', 'POST', true );
                if( isset($cart_items['items']) ){
                    $cnt        = count($cart_items['items']);
                }
            endif;

            if( $cnt == 0 && isset($_COOKIE['eabs_cart_id']) && !empty($_COOKIE['eabs_cart_id']) ){
                $eabs_domain    = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
                unset($_COOKIE['eabs_cart_id']);
            }

            return $cnt;
        }
    }
    new WPEABS_Cart_View();
}
?>