<?php

if (!class_exists('WPEABS_Admin_Integration')) {

    class WPEABS_Admin_Integration {

        // public $api_endpoint    = 'https://www.uppliv.com/api/v1.3/offer/search/details';
        public $api_endpoint    = '';
        public $authenticat_key = '';

        function __construct() {

            $_EABS_shortcode_domain = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';

            if( !empty($_EABS_shortcode_domain) ):
                $this->api_endpoint = rtrim($_EABS_shortcode_domain, '/').'/api/v1.3/offer/search/details';
            else:
                $this->api_endpoint = 'https://www.uppliv.com/api/v1.3/offer/search/details';
            endif;
            /** Initialize */
            $this->EABS_admin_init();
        }
        
        public function EABS_create_endpoint( $domain_only = false ){
            $_EABS_shortcode_domain = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';

            if( !empty($_EABS_shortcode_domain) ):
                if(  $domain_only == false ):
                    $this->api_endpoint = rtrim($_EABS_shortcode_domain, '/').'/api/v1.3/offer/search/details';
                else:
                    $this->api_endpoint = rtrim($_EABS_shortcode_domain, '/');
                endif;
            else:
                // if(  $domain_only == false ):
                //     $this->api_endpoint = 'https://www.uppliv.com/api/v1.3/offer/search/details';
                // else:
                $this->api_endpoint = '';
                // endif;
            endif;

            return $this->api_endpoint;
        }
        /** Execute and run hooks */
        public function EABS_admin_init(){

            /** Admin Submenu */
            add_action( 'admin_menu', array( $this, 'EABS_admin_menu' ) );

            // Add a post display state for special EABS pages.
		    add_filter( 'display_post_states', array( $this, 'EABS_add_display_post_states' ), 10, 2 );

        }

        /** Adding sub page for settings */
        public function EABS_admin_menu(){

            /** Register new page */
            $hook = add_menu_page(
                __( 'EABS', 'experience-activities-booking-system' ),
                __( 'EABS', 'experience-activities-booking-system' ),
                'manage_options',
                EABS_POST_TYPE,
                array( $this, 'EABS_page' ),
                'dashicons-schedule',
                3
            );

            add_action( "admin_enqueue_scripts", array( $this, 'eabs_admin_panel_style' ) );

            $eabs_shortcode_cart_page      = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $eabs_shortcode_checkout_page  = !empty( get_option( '_eabs_shortcode_checkout_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_checkout_page' )) ) : '';

            if( $eabs_shortcode_cart_page == '' || empty($eabs_shortcode_cart_page) ){
                $this->EABS_generate_pages(
                    array(
                        'meta_opt'  => '_eabs_shortcode_cart_page',
                        'title'     => 'Cart',          // page title
                        'slug'      => 'eabs-cart',     // page slug
                        'content'    => '',             // page content
                        'parent'    => '',              // page parent page
                        'status'    => 'publish',       // page status
                    ),
                    'insert'
                );
            }else{
                if( get_post_status($eabs_shortcode_cart_page) != 'publish' ){
                    $this->EABS_generate_pages(
                        array(
                            'meta_opt'  => '_eabs_shortcode_cart_page',
                            'id'        => $eabs_shortcode_cart_page,  // page id
                            'status'    => 'publish',       // page status
                        ),
                        'update'
                    );
                }
            }

            if( $eabs_shortcode_checkout_page == '' || empty($eabs_shortcode_checkout_page) ){
                $this->EABS_generate_pages(
                    array(
                        'meta_opt'  => '_eabs_shortcode_checkout_page',
                        'title'     => 'Confirmation',  // page title
                        'slug'      => 'confirmation',  // page slug
                        'content'   => '',             // page content
                        'parent'    => '',              // page parent page
                        'status'    => 'publish',       // page status
                    ),
                    'insert'
                );
            }else{
                if( get_post_status($eabs_shortcode_checkout_page) != 'publish' ){
                    $this->EABS_generate_pages(
                        array(
                            'meta_opt'  => '_eabs_shortcode_checkout_page',
                            'id'        => $eabs_shortcode_checkout_page,  // page id
                            'status'    => 'publish',       // page status
                        ),
                        'update'
                    );
                }
            }
        }

        // ------- Admin side design setting page
        public function eabs_admin_panel_style(){
            wp_enqueue_style( 'eabs-admin-style', EABS_URL . '/assets/eabs_admin-style.css' );
            wp_enqueue_script( 'eabs-admin-script', EABS_URL . '/assets/eabs_admin-script.js' );
        }

        public function EABS_generate_pages($pg_data = array(), $type = 'insert'){
            if( $type == 'insert' ){
                $page_meta_opt  = ( isset($pg_data['meta_opt']) && !empty( $pg_data['meta_opt'] ) ) ? $pg_data['meta_opt'] : '';
                $page_title     = ( isset($pg_data['title']) && !empty( $pg_data['title'] ) ) ? $pg_data['title'] : '';
                $page_slug      = ( isset($pg_data['slug']) && !empty( $pg_data['slug'] ) ) ? $pg_data['slug'] : '';
                $page_content   = ( isset($pg_data['content']) && !empty( $pg_data['content'] ) ) ? $pg_data['content'] : '';
                $page_parent    = ( isset($pg_data['parent']) && !empty( $pg_data['parent'] ) ) ? $pg_data['parent'] : '';
                $page_status    = ( isset($pg_data['status']) && !empty( $pg_data['status'] ) ) ? $pg_data['status'] : '';

                $page_data = array(
                    'post_status'    => $page_status,
                    'post_type'      => 'page',
                    'post_author'    => 1,
                    'post_name'      => $page_slug,
                    'post_title'     => $page_title,
                    'post_content'   => $page_content,
                    'post_parent'    => $page_parent,
                    'comment_status' => 'closed',
                );
                $page_id   = wp_insert_post( $page_data );

                if( !empty($page_id) && $page_id != 0 ){
                    update_option( $page_meta_opt, $page_id );
                }
            }elseif($type == 'update'){
                $page_meta_opt  = ( isset($pg_data['meta_opt']) && !empty( $pg_data['meta_opt'] ) )   ? $pg_data['meta_opt'] : '';
                $page_id        = ( isset($pg_data['id']) && !empty( $pg_data['id'] ) )   ? $pg_data['id'] : '';
                $page_status    = ( isset($pg_data['status']) && !empty( $pg_data['status'] ) )  ? $pg_data['status'] : '';

                $page_data = array(
                    'ID'          => $page_id,
                    'post_status' => $page_status,
                );
                wp_update_post( $page_data );
            }
        }

        public function EABS_get_language_list(){
            $lang = array(
                'en' => 'English',
                'de' => 'Deutsch',
                'fr' => 'Français',
                'it' => 'Italiano',
                'ja' => '日本人',
                'pt' => 'Português',
                'sv' => 'Svenska',
                'zh' => '中文',
            );
            return $lang;
        }

        /** Load setting page content */
        public function EABS_page(){
            
            $this->EABS_save_settings();
            $_EABS_shortcode_key            = !empty( get_option( '_eabs_shortcode_key' ) ) ? ( esc_html(get_option( '_eabs_shortcode_key' )) ) : '';
            $_EABS_shortcode_domain         = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';
            $_EABS_shortcode_qr_domain      = !empty( get_option( '_eabs_shortcode_qr_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_qr_domain' )) ) : '';
            $_EABS_shortcode_cart_page      = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $_EABS_shortcode_checkout_page  = !empty( get_option( '_eabs_shortcode_checkout_page' ) ) ? ( esc_html(get_option( '_eabs_shortcode_checkout_page' )) ) : '';
            $_EABS_content_language         = !empty( get_option( '_eabs_content_language' ) ) ? ( esc_html(get_option( '_eabs_content_language' )) ) : '';
            $_eabs_show_cart_icon           = !empty( get_option( '_eabs_show_cart_icon' ) ) ? ( esc_html(get_option( '_eabs_show_cart_icon' )) ) : '';

            $res        = $this->EABS_curl_init($_EABS_shortcode_key, true);
            $language   = $this->EABS_get_language_list();
            require_once EABS_PATH . 'templates/backend/eabs-general-settings.php';
        }

        /** Save setting page data */
        public function EABS_save_settings(){
            if( !empty($_POST) && check_admin_referer( 'API_settings_nonce' ) ){
                
                // sanitize_text_field
                $_EABS_shortcode_key            = isset( $_POST['eabs_shortcode_key' ] ) ? sanitize_text_field( $_POST[ 'eabs_shortcode_key' ] ) : '';
                $_EABS_shortcode_domain         = isset( $_POST['eabs_shortcode_domain' ] ) ? sanitize_url( $_POST[ 'eabs_shortcode_domain' ] ) : '';
                $_EABS_shortcode_qr_domain      = isset( $_POST['eabs_shortcode_qr_domain' ] ) ? sanitize_url( $_POST[ 'eabs_shortcode_qr_domain' ] ) : '';
                $_EABS_shortcode_cart_page      = isset( $_POST['eabs_shortcode_cart_page' ] ) ? ( sanitize_text_field($_POST[ 'eabs_shortcode_cart_page' ]) ) : '';
                $_EABS_shortcode_checkout_page  = isset( $_POST['eabs_shortcode_checkout_page' ] ) ? ( sanitize_text_field($_POST[ 'eabs_shortcode_checkout_page' ]) ) : '';
                $_EABS_content_language         = isset( $_POST['eabs_content_language' ] ) ? ( sanitize_text_field($_POST[ 'eabs_content_language' ]) ) : '';
                $_eabs_show_cart_icon           = isset( $_POST['eabs_show_cart_icon' ] ) ? ( sanitize_text_field($_POST[ 'eabs_show_cart_icon' ]) ) : false;
                $api_data = array();

                update_option( '_eabs_shortcode_key', $_EABS_shortcode_key );
                update_option( '_eabs_shortcode_domain', $_EABS_shortcode_domain );
                update_option( '_eabs_shortcode_qr_domain', $_EABS_shortcode_qr_domain );
                update_option( '_eabs_shortcode_cart_page', $_EABS_shortcode_cart_page );
                update_option( '_eabs_shortcode_checkout_page', $_EABS_shortcode_checkout_page );
                update_option( '_eabs_content_language', $_EABS_content_language );
                update_option( '_eabs_show_cart_icon', $_eabs_show_cart_icon );

                /** Validation user details */
                $api_data = array(
                    'api_key'   => $_EABS_shortcode_key,
                    'language'  => $_EABS_content_language,
                    'oid'       => '',
                );
                $validate = $this->EABS_curl_validate_authentication($api_data, true);

                if( !empty($validate) || isset($validate['msg']) ){
                    if( empty($validate['msg']) ){
                        $this->EABS_print_notice( 'Your Authentication key is invalid!', 'error' );
                    }else{
                        $this->EABS_print_notice( $validate['msg'], 'error' );
                    }
                }else{
                    $this->authenticat_key = $_EABS_shortcode_key;
                }
                $this->EABS_print_notice( 'Successfully saved the changes !' );
            }
        }

        /** API key and teneant reference name validation */
        public function EABS_curl_validate_authentication( $api_data = array(), $return_data = false ){
            $validate_user = false;
            $_EABS_shortcode_domain = !empty( get_option( '_eabs_shortcode_domain' ) ) ? ( esc_url(get_option( '_eabs_shortcode_domain' )) ) : '';
            
            $this->api_endpoint = $this->EABS_create_endpoint(true);

            $res = '';
            if( !empty($api_data) ){
                $api_key    = isset($api_data['api_key']) ? ( esc_html($api_data['api_key']) ) : '';    

                $args = array(
                    'method'        => 'POST',
                    'headers'       => array(
                        'Content-Type'  => 'application/json',
                        'Authorization' => 'Bearer '.$api_key,
                    ),
                );
                $response = wp_remote_get( $this->api_endpoint, $args );

                if ( is_wp_error( $response ) ) {
                    $error_message = $response->get_error_message();
                    $res = "Something went wrong: $error_message";
                } else {
                    $res    = json_decode( wp_remote_retrieve_body($response), JSON_OBJECT_AS_ARRAY );
                }

                if( !isset($res['msg']) ){
                    $res = array();    
                }
            }else{
                $res = array( 'msg' => 'Your Authentication key is invalid!' );
            }
            return $res;
        }

        /** API key and teneant reference name validation */
        public function EABS_curl_init( $api_data = array(), $return_data = false ){
            $this->api_endpoint = $this->EABS_create_endpoint();

            $res = '';
            $validate_user = false;
            if( !empty($api_data) ){
                $api_key    = isset($api_data['api_key']) ? ( sanitize_text_field($api_data['api_key']) ) : '';    
                $oid        = isset($api_data['oid']) ? ( sanitize_text_field($api_data['oid']) ) : '';
                $startdate  = ( isset($api_data['startdate']) && !empty($api_data['startdate'] ) ) ? ( esc_html($api_data['startdate'])) : date('Y-m-d');
            
                if( !isset($api_data['language']) && empty($api_data['language']) ){
                    $content_language = !empty( get_option( '_eabs_content_language' ) ) ? ( esc_html__(get_option( '_eabs_content_language' ), 'experience-activities-booking-system' ) ) : '';
                }else{
                    $content_language = esc_html($api_data['language']);
                }
                $postfields = '{
                    "daterange": 120,
                    "language": "'.$content_language.'",
                    "oid": "'.$oid.'",
                    "startdate": "'.$startdate.'"
                }';

                $args = array(
                    'method'        => 'POST',
                    'headers'       => array(
                        'Content-Type'  => 'application/json',
                        'Authorization' => 'Bearer '.$api_key,
                    ),
                    'body'          => $postfields,
                );

                // echo $this->api_endpoint.'<pre>'; print_r($args); die;
                $response = wp_remote_get( $this->api_endpoint, $args );

                if ( is_wp_error( $response ) ) {
                    $error_message = $response->get_error_message();
                    $res = "Something went wrong: $error_message";
                } else {
                    $res    = json_decode( wp_remote_retrieve_body($response), JSON_OBJECT_AS_ARRAY );
                }

                if( !empty($res) && isset($res['_id']) ){
                    $validate_user = true;
                }else{
                    $validate_user = false;
                }
            }else{
                $validate_user = false;
            }
            
            if( $return_data == false ){
                return $validate_user;
            }else{
                return $res;
            }
        }

        /** Load Notice page content */
        public function EABS_print_notice( $msg = '', $type = 'success' ){
            if( $msg != '' ){
                echo sprintf(
                    '<div class="notice notice-%s is-dismissible"><p>%s</p></div>', 
                    esc_attr($type), 
                    esc_html($msg)
                );
            }
        }

        public function EABS_add_display_post_states( $post_states, $post ) {
            $_EABS_shortcode_cart_page      = !empty( get_option( '_eabs_shortcode_cart_page' ) ) ? ( (int)esc_html(get_option( '_eabs_shortcode_cart_page' )) ) : '';
            $_EABS_shortcode_checkout_page  = !empty( get_option( '_eabs_shortcode_checkout_page' ) ) ? ( (int)esc_html(get_option( '_eabs_shortcode_checkout_page' )) ) : '';

            if ( $_EABS_shortcode_cart_page === $post->ID ) {
                $post_states['eabs_integration_cart_page'] = __( 'EABS Cart Page', 'experience-activities-booking-system' );
            }
            
            if ( $_EABS_shortcode_checkout_page === $post->ID ) {
                $post_states['eabs_integration_course_page'] = __( 'EABS Checkout Page', 'experience-activities-booking-system' );
            }

            return $post_states;
        }
    }
    new WPEABS_Admin_Integration();
}
?>