/*
  Author: Ming's IT Services Ltd.
  Date: 2018-09-01
  Email: mingtl2010@gmail.com
  Copyright: All rights reserved.
*/
var expense_drop_counter = 0, allCorrect = true, startTimeEmpty = false, endTimeEmpty = false, endTimeEarlierThanStartTime = false;
var startTimeWrongDateFormat = false, endTimeWrongDateFormat = false, endTimeNotEqualToNextStartTime = false;

jQuery(function() {
    jQuery('input.timepicker').each(function(){
        jQuery(this).datetimepicker({
            format:'H:i',
            datepicker:false,
        });
    });
});

//validate date xxxx-xx-xx
function isValidDate(dateString) {
  var regEx = /^\d{4}-\d{2}-\d{2}$/;
  if(!dateString.match(regEx)) return false;  // Invalid format
  var d = new Date(dateString);
  var dNum = d.getTime();
  if(!dNum && dNum !== 0) return false; // NaN value, Invalid date
  return d.toISOString().slice(0,10) === dateString;
}

function getDateFromUTCString(d, getDate) {
    //Sat, 12 Aug 2017 00:00:00 GMT
    var n = d.toUTCString();
    var re = / (20[0-9][0-9]) /;
    var r = n.split(re);
    var myYear = r[1];
    var rex = /, /;
    var r1 = r[0].split(rex);
    var s = r1[1].split(" ");
    var h = '';
    if (getDate === undefined) {
        getDate = 0;
    }
    if(getDate === 1) {//return Mon, ... Sat
        return mytrans.Myweek[r1[0]];
    } else {
        var myDay = s[0];
        var mon = s[1].toLowerCase();
        var days = {'jan':'01', 'feb':'02', 'mar':'03', 'apr':'04', 'may':'05', 'jun':'06', 'jul':'07', 'aug':'08', 'sep':'09', 'oct':'10', 'nov':'11', 'dec':'12'};
        var myMonth = days[mon];    
        h = myYear + '-' + myMonth + '-' + myDay;
        if(getDate === 0) {
            return h;
        } else if(getDate === 2) {//return Sat, 2017-08-06
            return mytrans.Myweek[r1[0]] + ', ' + h;
        }
    }
}

function onFromDateChangeDateTime(mydate, element) {
    var timepickerID = jQuery(element).attr('id');
    if(jQuery(element).val() !== '') {
        updateComposeAreaHeaderDate();
    }
}

function getDayBeginning(mydate) {
    var d = new Date(mydate);
    d.setHours(0);
    d.setMinutes(0);
    d.setSeconds(0);
    return d;
}

function getGMTTime(mydate) {
    var d = new Date(mydate);
    d.setMinutes( d.getMinutes() - d.getTimezoneOffset() );
    return d;
}

function submitExpenseData(formid, submitbuttonid) {
    if(formid ==='') {return "Form id is emtpy.";}
    var vdate =jQuery.trim(jQuery("input#expensedate").val());
    var vtype = jQuery.trim(jQuery("select#expensetypeid").val());
    var vtypeid = parseInt(vtype) || 0;
    var vcurrency = jQuery.trim(jQuery("select#expensecurrencyid").val());
    var vcurrencyid = parseInt(vcurrency) || 0;    
    var vamount_string = jQuery.trim(jQuery("input#expenseamount").val());
    var vamount = parseFloat(vamount_string) || 0;    
    var vtaxrate = jQuery.trim(jQuery("select#expensetaxrateid").val());
    var vtaxrateid = parseInt(vtaxrate) || 0;
    var vamountincludetax = false;
    if(jQuery("input#expenseamountincludetax").is(':checked')) {
        vamountincludetax = true;
    }
    if(jQuery("input#expenseamountincludetax2").is(':checked')) {
        vamountincludetax = false;
    }
    var vreferencenumber = jQuery.trim(jQuery("input#expensereferencenumber").val());
    var vnotes = jQuery.trim(jQuery("textarea#expensenotes").val());    
    var vcustomer = jQuery.trim(jQuery("select#expensecustomerid").val());
    var vcustomerid = parseInt(vcustomer) || 0;    
    var visrecurring = false;
    if(jQuery("input#expenseisrecurring").is(':checked')) {
        visrecurring = false;
    }
    if(jQuery("input#expenseisrecurring2").is(':checked')) {
        visrecurring = true;
    }
    var vrecurringpaymentstartdate = jQuery.trim(jQuery("input#expenserecurringpaymentstartdate").val());
    var vrecurringpaymentenddate = jQuery.trim(jQuery("input#expenserecurringpaymentenddate").val());
    var vrecurringpaymentfrequency = jQuery.trim(jQuery("select#expenserecurringpaymentfrequencyid").val());
    var vrecurringpaymentfrequencyid = parseInt(vrecurringpaymentfrequency) || 0;    
    var vrecurringpaymentday = jQuery.trim(jQuery("select#expenserecurringpaymentdayid").val());
    var vrecurringpaymentdayid = parseInt(vrecurringpaymentday) || 0;    
    if(vtype === '-1' || vtypeid <= 0 || vcurrencyid === '-1' || vamount === '' || vdate === '' || (visrecurring && (vrecurringpaymentstartdate === '' || vrecurringpaymentenddate === '' || vrecurringpaymentfrequencyid === -1 || vrecurringpaymentdayid === -1))) {
        return alert("Please enter all the required information. If it's recurring, please enter all the required recurring information.");
    }
    //validate date
    if(!isValidDate(vdate)) {
        return alert("Expense date is not valid.");
    }        
    if(visrecurring && (!isValidDate(vrecurringpaymentstartdate))) {
        return alert("Expense recurring payment start date is not valid.");
    }
    if(visrecurring && (!isValidDate(vrecurringpaymentenddate))) {
        return alert("Expense recurring payment end date is not valid.");
    }
    if(visrecurring && (vrecurringpaymentenddate < vrecurringpaymentstartdate)) {
        return alert("End date should be later than start date.");
    }
    myform.removeEventListener('submit',formSubmit);
    jQuery('#' + submitbuttonid).click();
}

function resetExpenseData() {
    jQuery("input#expensedate").val('');
    jQuery("select#expensetypeid").val('-1');
    jQuery("select#expensecurrencyid").val('-1');
    jQuery("input#expenseamount").val('');
    jQuery("select#expensetaxrateid").val('-1');
    jQuery("input#expensereferencenumber").val('');
    jQuery("textarea#expensenotes").val('');
    jQuery("select#expensecustomerid").val('-1');
    jQuery("input#expenseisrecurring").prop("checked", true).trigger("click");
    jQuery("input#expenserecurringpaymentstartdate").val('');
    jQuery("input#expenserecurringpaymentenddate").val('');
    jQuery("select#expenserecurringpaymentfrequencyid").val('-1');
    jQuery("select#expenserecurringpaymentdayid").val('-1');
    jQuery("div.expenseamountistaxinclusive > div").hide();
    jQuery("input#expenseamountincludetax").prop("checked", true);
}