<?php declare(strict_types=1);

namespace Expedico;

if (!defined('ABSPATH')) {
    exit;
}

final class PickupPointsShippingMethod extends \WC_Shipping_Method
{

    public const EXPEDICO_METHOD_ID = 'expedico_pickup_points_shipping_method';

    /**
     * @param int $instance_id Shipping method instance id.
     */
    public function __construct(int $instance_id = 0)
    {
        parent::__construct();
        $this->id           = self::EXPEDICO_METHOD_ID;
        $this->instance_id  = absint($instance_id);
        $this->method_title = __('Expedico pickup points', 'expedico');
        $this->init();

        $title                    = $this->get_option('title');
        $this->title              = !empty($title) ? $title : __('Expedico pickup points', 'expedico');
        $this->enabled            = 'yes';
        $this->supports           = ['shipping-zones', 'instance-settings', 'instance-settings-modal'];
        $this->method_description = __(
            'Allows users to select a specific pickup point on the Expedico map.',
            'expedico'
        );
    }

    /**
     * @return void
     */
    public function init(): void
    {
        $this->init_form_fields();
        $this->init_settings();

        \add_action(
            'woocommerce_update_options_shipping_' . $this->id,
            [
                $this,
                'process_admin_options',
            ]
        );
    }

    function init_form_fields()
    {
        $this->instance_form_fields = [
            'title'      => [
                'title'       => __('Title', 'expedico'),
                'type'        => 'text',
                'description' => __('Title to be displayed on site', 'expedico'),
                'default'     => __('Expedico pickup points', 'expedico'),
            ],
            'tax_status' => [
                'title'       => __('Tax status', 'expedico'),
                'type'        => 'select',
                'description' => __('Tax status', 'expedico'),
                'default'     => 'taxable',
                'options'     => [
                    'taxable' => __('Taxable', 'expedico'),
                    'none'    => _x('None', 'Tax status', 'expedico'),
                ],
            ],
            'cost'       => [
                'title'       => __('Cost', 'expedico'),
                'type'        => 'text',
                'description' => __('Cost', 'expedico'),
                'default'     => '0',
            ],
        ];

    }

    public function calculate_shipping($package = [])
    {
        $this->add_rate(
            [
                'id'    => $this->id . $this->instance_id,
                'label' => $this->title,
                'cost'  => $this->get_option('cost'),
            ]
        );
    }
}
