<?php

declare( strict_types=1 );

namespace Expedico;


use WC_Order_Query;

class ExpedicoOrderStatus {
	public const STATUS_DELIVERED = 410;

	private ExpedicoAPI $api;

	public function __construct(ExpedicoAPI $api) {
		$this->api = $api;
	}

	public function syncOrderStatuses() {
		$notCompletedOrders = $this->get_parcelIds_not_completed();

		if (empty($notCompletedOrders)) {
			return;
		}

		$deliveredOrders = $this->api->getDeliveredParcelIds($notCompletedOrders);

		foreach ($deliveredOrders as $orderId => $delivered_parcelId) {
			$order = wc_get_order($orderId);

			if ($order && 'completed' !== $order->get_status()) {
				$order->update_status('completed', __('Order automatically marked as completed by Expedico plugin.', 'expedico'));

				$order->add_order_note(__('Order has been delivered and the order is marked as completed.'));
			}
		}
	}

	public function get_parcelIds_not_completed() {
		$order_statuses = array_keys(wc_get_order_statuses());

		foreach (['wc-completed', 'wc-on-hold', 'wc-refunded', 'wc-failed', 'wc-cancelled'] as $status_to_remove) {
			if (($key = array_search($status_to_remove, $order_statuses)) !== false) {
				unset($order_statuses[$key]);
			}
		}

		$args = array(
			'limit'        => -1,
			'orderby'      => 'date',
			'order'        => 'DESC',
			'meta_key'     => Expedico::EXPEDICO_PARCEL_ID,
			'meta_value'   => '',
			'meta_compare' => '!=',
			'status'       => $order_statuses,
		);

		$query = new WC_Order_Query($args);
		$orders = $query->get_orders();
		$parcelIds = [];

		/** @var \WC_Order $order */
		foreach ($orders as $order) {
			$parcelIds[$order->get_id()] = $order->get_meta(Expedico::EXPEDICO_PARCEL_ID);
		}

		return $parcelIds;
	}
}