<?php
/**
 * @package exifwidget
 * @version 1.3
 */
/*
Plugin Name: exifwidget
Plugin URI: https://gerhardhoogterp.nl/plugins/
Description: A simple widget with basic EXIF information on the featured image. Part of the phototools plugins
Author: Gerhard Hoogterp
Version: 1.3
Author URI: https://gerhardhoogterp.nl/
*/

if (!defined('WPINC')) {
	die;
}

class exif_class {

	const FS_TEXTDOMAIN       = 'exifwidget';
	const FS_PLUGINID         = 'exifwidget';

	public function __construct() {
		$exifwidget_options = get_option('exifwidget_options');

		register_activation_hook(__FILE__, array(
			$this,
			'activate'
		));
		register_deactivation_hook(__FILE__, array(
			$this,
			'deactivate'
		));

		add_action('init', array(
			$this,
			'myTextDomain'
		));
		add_action('admin_menu', array(
			$this,
			'add_phototools_menuitem'
		));
		add_shortcode('EXIF', array(
			$this,
			'EXIF_data_shortcode'
		));
		
                add_action('widgets_init', function() { return register_widget("exifwidget_class");} );
	}

	// defaults
	

	public function myTextDomain() {
		load_plugin_textdomain(self::FS_TEXTDOMAIN, false, dirname(plugin_basename(__FILE__)) . '/languages/');
	}

	function PluginLinks($links, $file) {
		if (strpos($file, self::FS_PLUGINID . '.php') !== false) {
			$links[] = '<a href="' . admin_url() . 'admin.php?page=phototools">' . __('General info', self::FS_TEXTDOMAIN) . '</a>';
			$links[] = '<a href="' . admin_url() . 'admin.php?page=' . self::FS_PLUGINID . '">' . __('Settings', self::FS_TEXTDOMAIN) . '</a>';

		}
		return $links;
	}

	public function activate() {
		$phototools = get_option('phototools_list');
		$phototools[self::FS_PLUGINID]            = plugin_basename(__FILE__);;
		update_option('phototools_list', $phototools);
	}

	public function deactivate() {
		$phototools = get_option('phototools_list');
		$self       = self::FS_PLUGINID;
		unset($phototools[$self]);
		if (!empty($phototools)):
			update_option('phototools_list', $phototools);
		else:
			delete_option('phototools_list');
		endif;
	}

	function add_phototools_menuitem() {
		if (empty($GLOBALS['admin_page_hooks']['phototools'])):
			add_menu_page(__('Phototools', self::FS_TEXTDOMAIN) , __('Phototools', self::FS_TEXTDOMAIN) , 'manage_options', 'phototools', array(
				$this,
				'phototools_info'
			) , 'dashicons-camera', 25);
		endif;
		//                $this->create_submenu_item();
		
	}
	public function phototools_info() {
?>
			<div class="wrap">
				<div class="icon32" id="icon-options-general"></div>
				<h1><?php _e('Phototools', self::FS_TEXTDOMAIN); ?></h1>
                                
				<p>
				<?php _e('Phototools is a collection of plugins which add functionality for those
				who use WordPress to run a photoblog or gallery site or something alike.', self::FS_TEXTDOMAIN);
?>
				</p>
                                <p><?php _e('The following plugins in this series are installed:', self::FS_TEXTDOMAIN); ?></p>
                                <?php
		$phototools = get_option('phototools_list');
		foreach ($phototools as $id         => $shortPath):
			$plugin     = get_plugin_data(WP_PLUGIN_DIR . '/' . $shortPath, true);
?>
                                        <div class="card">
                                        <h3><a href="<?php echo $plugin['PluginURI']; ?>" target="_blank"><?php echo $plugin['Name'] . ' ' . $plugin['Version']; ?></a></h3>
                                        <p><?php echo $plugin['Description']; ?></p>
                                        </div>
                                        <?php
		endforeach;
?>
                                

			</div>
		<?php
	}

	function EXIF_data_shortcode($atts) {
		$res = '';

		// Attributes
		extract(shortcode_atts(array(
			'data'      => 'all'
		) , $atts));
		$EXIF = EXIF_Widget_Class::getEXIFinfo(get_post_thumbnail_id($GLOBALS['post']->ID));
		$data = strtolower($data);
		switch ($data) {
			case 'camera':
				$res  = $EXIF[$data];
			break;
			case 'aperture':
				$res = $EXIF[$data];
			break;
			case 'exposure':
				$res = $EXIF[$data];
			break;
			case 'iso':
				$res = $EXIF[$data];
			break;
			case 'focallength35mm':
				$res = $EXIF[$data];
			break;
			case 'focallength':
				$res = $EXIF[$data];
			break;
			case 'timestamp':
				$res = date(get_option('time_format') . ', ' . get_option('date_format') , $EXIF['timestamp']);
			break;
			case 'date':
				$res = date(get_option('date_format') , $EXIF['timestamp']);
			break;
			case 'time':
				$res = date(get_option('time_format') , $EXIF['timestamp']);
			break;
			case 'all':
				$res = EXIF_Widget_Class::showAllExif($EXIF);
		}

		return $res;
	}

}
// --------------- Widget --------------------------------------
class exifwidget_Class extends WP_Widget {
	const FS_TEXTDOMAIN = 'exifwidget';

	public function __construct() {
		parent::__construct(false, $name         = __('exifwidget', self::FS_TEXTDOMAIN) , array(
			'description'              => __('exifwidget', self::FS_TEXTDOMAIN)
		));
	}

	function getEXIFinfo($id) {
		$EXIF         = get_metadata('post', $id, 'EXIFinfo_cache', true);
		if (!$EXIF):
			unset($EXIF);
			$thumbnail    = get_attached_file($id, true);
			$EI           = exif_read_data($thumbnail);
			$EXIF['camera']              = trim($EI['Make'] . ' ' . $EI['Model']);
			$EXIF['aperture']              = $EI['COMPUTED']['ApertureFNumber'];
			$EXIF['exposure']              = $EI['ExposureTime'];
			$EXIF['iso']              = $EI['ISOSpeedRatings'];
			$EXIF['focallength35mm']              = $EI['FocalLengthIn35mmFilm'];
			$EXIF['focallength']              = $EI['FocalLength'];
			$EXIF['timestamp']              = strtotime($EI['DateTimeOriginal'], time());

			list($f, $s)               = explode('/', $EXIF['focallength']);
			$EXIF['focallength']              = $s ? (string)$f / $s : '';
			update_post_meta($id, 'EXIFinfo_cache', $EXIF, true);
		endif;
		return $EXIF;
	}

	// widget form creation
	function form($instance) {
		$exifwidget_options = get_option('exifwidget_options');

		// Check values
		if ($instance) {
			$title              = esc_attr($instance['title']);

		}
		else {
			$title              = __('EXIF', self::FS_TEXTDOMAIN);

		}
?>

	    <p>
	    	<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', self::FS_TEXTDOMAIN); ?></label>
	    	<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	    </p>
	    
	    <?php
	}

	// widget update
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title']          = strip_tags($new_instance['title']);

		return $instance;
	}

	// widget display
	function widget($args, $instance) {
		extract($args);

		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		$EXIF  = $this->getEXIFinfo(get_post_thumbnail_id($GLOBALS['post']->ID));
		if (!empty(trim($EXIF['camera']))):
			echo $before_widget;

			// Display the widget
			echo '<div class="widget-text wp_widget_plugin_box exifwidget_widget_class">';

			// Check if title is set
			if ($title) {
				echo $before_title . $title . $after_title;
			}

			echo $this->showAllExif($EXIF);

			echo '</div>';
			echo $after_widget;
		endif;

	}
	function showAllExif($EXIF) {
		$timeStr = get_option('time_format') . ', ' . get_option('date_format');
		ob_start();
?>
            <style>
                .header { font-weight: bold; width: 40%; }
                td { border-bottom: 1px dotted #ccc; }
            </style>
            <table style="width: 100%">
                <tr><td class="header"><?php echo __('Camera', self::FS_TEXTDOMAIN) ?></td>      <td><?php echo $EXIF['camera']; ?></td></tr>
                <tr><td class="header"><?php echo __('Aperture', self::FS_TEXTDOMAIN) ?></td>    <td><?php echo $EXIF['aperture']; ?></td></tr>
                <tr><td class="header"><?php echo __('Exposure', self::FS_TEXTDOMAIN) ?></td>    <td><?php echo $EXIF['exposure']; ?> sec.</td></tr>
                <tr><td class="header"><?php echo __('ISO', self::FS_TEXTDOMAIN) ?></td>         <td><?php echo $EXIF['iso']; ?></td></tr>
                <tr><td class="header"><?php echo __('Focal length', self::FS_TEXTDOMAIN) ?></td><td><?php echo (int)$EXIF['focallength']; ?> mm</td></tr>
                <?php if ($EXIF['focallength35mm']): ?>
                    <tr><td class="header"><?php echo __('Focal length (35mm)', self::FS_TEXTDOMAIN) ?></td><td><?php echo $EXIF['focallength35mm']; ?> mm</td></tr>
                <?php
		endif; ?>
                <tr><td class="header"><?php echo __('Time taken', self::FS_TEXTDOMAIN) ?></td>  <td><?php echo date($timeStr, $EXIF['timestamp']); ?></td></tr>
            </table>
        <?php
		$out = ob_get_clean();
		return $out;
	}
}

$exifwidget = new exif_class();
?>
