<?php

/*

*

* Photo Display Features for Exhibit

* ----------------------------------

* Version 1.1d

* Owen Winkler

* http://www.asymptomatic.net/wp-hacks

*/



/*

Exhibit - A photo gallery plugin for WordPress

Copyright (c) 2004 Owen Winkler



Permission is hereby granted, free of charge, to any person

obtaining a copy of this software and associated

documentation files (the "Software"), to deal in the

Software without restriction, including without limitation

the rights to use, copy, modify, merge, publish,

distribute, sublicense, and/or sell copies of the Software,

and to permit persons to whom the Software is furnished to

do so, subject to the following conditions:



The above copyright notice and this permission notice shall

be included in all copies or substantial portions of the

Software.



THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY

KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE

WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR

PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS

OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR

OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR

OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE

SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



add_filter('wp_head', 'exhibit_head');

add_filter('the_content', 'exhibit_content');



// exhibit_content: A content filter that inserts the thumbnail images for the post

function exhibit_content($content)

{

	global $single, $wpdb, $exc, $id, $post, $page;

	

	$exc = new ex_config();

	

	if('' == $id)

	{

		$id = $_REQUEST['post'];

	}



	// Check to see if special settings were set in the post

	if(preg_match('|<!--nothumbs-->|', $content))

	{

		$dothumbs = false;

	}

	else

	{

		$dothumbs = true;

	}

	preg_replace_callback('|<!--exhibit:([^-=]*)=(.*)-->|iU', 'exhibit_set_exc', $post->post_content);

	$content = preg_replace_callback('|<!--exhibit:([^-=]*)=(.*)-->|iU', 'exhibit_set_exc', $content);

	if(preg_match('|<!--exhibitdump-->|iU', $post->post_content)) print_r($exc);

	

	$dosingle = ($exc->preview_like_single || $single);

	

	if($dosingle)

	{

		// The post content is for a single page

		$pic = -1;

		if($exc->no_pic_use_preview) 

		{

			$pic = $wpdb->get_var("SELECT ID FROM {$exc->tableexhibit} WHERE post_ID = {$id} and preview = 1 ORDER BY picorder;");

		}

		if(isset($_REQUEST['pic']))

		{

			$pic = $_REQUEST['pic'];

		}

				

		if(-1 != $pic)

		{

			// This should display just the specified picture

			$wpdb->hide_errors();

			$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE ID = $pic;");

			$wpdb->show_errors();

			

			$imageurl = get_settings('siteurl').'/'.$image->photo;

			

			$imagetag = preg_replace('|IMGSRC|', $imageurl, $exc->full_image_display);

			$imagetag = preg_replace('|IMGCAPTION|', $image->caption, $imagetag);

			

			if($exc->suppress_content)

			{

				if($exc->use_permalinks)

				{

					$ret = '<a href="'.exhibit_permaquery(get_permalink()).'page='.$page.'">'.$imagetag.'</a>';

				}

				else

				{

					$ret = '<a href="index.php?p='.$id.'&page='.$page.'">'.$imagetag.'</a>';

				}

				return $ret;

			}

			else

			{

				if('' != $exc->tableexhibit)

				{

					if($exc->use_permalinks)

					{

						$imagetag = '<a href="'.get_permalink().'">'.$imagetag.'</a>';

					}

					else

					{

						$imagetag = '<a href="index.php?p='.$id.'&page='.$page.'">'.$imagetag.'</a>';

					}

				}

				$fulltag = preg_replace('|<!--exhibit-->|', $imagetag, $content);

				$fulltag = preg_replace_callback('|<!--exhibit-thumbs:([0-9]+)-([0-9]+)-->|', 'exhibit_some_thumbnails', $fulltag);

				if($exc->thumbs_at_top)

				{

					$ret = exhibit_all_thumbnails($dothumbs) . $fulltag;

				}

				else

				{

					$ret = $fulltag . exhibit_all_thumbnails($dothumbs);

				}

				return $ret;

			}

		}

		else

		{

			// This is the post with the original post text

			$content = preg_replace_callback('|<!--exhibit-thumbs:([0-9]+)-([0-9]+)-->|', 'exhibit_some_thumbnails', $content);

			if($exc->thumbs_at_top)

			{

				$ret = exhibit_all_thumbnails($dothumbs) . $content;

			}

			else

			{

				$ret = $content . exhibit_all_thumbnails($dothumbs);

			}

						

			return $ret;

		}

	}

	else

	{

		// The post content is one of many posts on the page

		// See if there is a preview picture for this post

		$wpdb->hide_errors();

		$previews = $wpdb->get_results("SELECT * FROM {$exc->tableexhibit} WHERE post_ID = $id AND preview = 1 ORDER BY picorder;");

		$wpdb->show_errors();

		

		//exhibit_paginate($previews);

		exhibit_recalc_pages();

		

		if(count($previews) > 0)

		{

			// Since there is a preview picture, display it and the content

			

			$ret = '';

			

			if(!$exc->preview_at_top)

			{

				$ret .= $content;

			}

			

			$ret .= "<div class=\"{$exc->preview_class}\">";

			

			foreach($previews as $preview)

			{

				if (preg_match('|post.php|', $_SERVER['SCRIPT_NAME']))

				{

					$startlink = '<div>';

					$endlink = '</div>';

				}

				else

				{

					if($exc->previews_link)

					{

						$startlink = exhibit_thumbnail_link($preview, true);

					}

					else

					{

						if($exc->use_permalinks)

						{

							$startlink = '<a href="'.get_permalink().'">';

						}

						else

						{

							$startlink = '<a href="'.$_SERVER['SCRIPT_NAME'].'?p='.$id.'">';

						}

					}

					$endlink = '</a>';

				}



				$ret .= $startlink.'<img src="'.get_settings('siteurl').'/'.$preview->thumb.'" alt="'.$preview->caption.'" ';

				if($exc->preview_titles) $ret .= ' title="'.$preview->caption.'"';

				$ret .= '/>'.$endlink;

				if($exc->break_every_preview > 0)

				{

					$tcount ++;

					if($tcount >= $exc->break_every_preview)

					{

						$ret .= "\t".'<br/>'."\n";

						$tcount = 0;

					}

				}

			}

			if('' != $exc->preview_prompt)

			{

				if ((!preg_match('|post.php|', $_SERVER['SCRIPT_NAME']) && (count($previews) != 1)) ||

				 ($exc->thumbnail_popup))

				{

					if($exc->use_permalinks)

					{

						$startlink = '<a href="'.get_permalink().'">';

					}

					else

					{

						$startlink = '<a href="'.$_SERVER['SCRIPT_NAME'].'?p='.$id.'">';

					}

					$endlink = '</a>';

				}

				$ret .= "<span class=\"ex_preview_prompt\">{$startlink}{$exc->preview_prompt}{$endlink}</span>";

			}

			$ret .= '</div>';

			if($exc->preview_at_top)

			{

				$ret .= $content;

			}

			if($exc->clear_post)

			{

				$ret = '<div style="clear:both;">&nbsp;</div>'.$ret.'<div style="clear:both;">&nbsp;</div>';

			}

			return $ret;

		}

		else

		{

			// No preview post, just display the normal post content

			return "$content";

		}

	}

}



// exhibit_head: Adds the necessary styles to the blog output for thumbnail support

function exhibit_head($content)

{

	global $exc, $posts;



	//$exc = new ex_config();

	

	if(count($posts) == 1)

	{

		preg_replace_callback('|<!--exhibit:([^-=]*)=(.*)-->|iU', 'exhibit_set_exc', $posts[0]->post_content);

	}



	$exhibit_style = '

	<style type="text/css" media="screen">

		@import url( '.get_settings('siteurl').'/'.$exc->stylesheet_file.' );

	</style>';

	

	if((($exc->popup_page == '') && ($exc->thumbnail_popup)) || $exc->pop_script_always)

	{

		$popfunc = <<< EOPOPFUNC

<script type="text/javascript">

<!--

function exh_popImage(oContent,oTitle) {

	var x = window.open('','windowName','width=800,height=800,resizable=1');

	if( !x ) { return true; }

	x.document.open();

	x.document.write('<html><head><title>'+oTitle+'<\/title>');

	x.document.write('<sc'+'ript>');

	x.document.writeln('var isNN,isIE;');

	x.document.writeln('function reSizeToImage(){');

	if (navigator.appName.indexOf("Microsoft")==-1)

	{

		x.document.writeln('window.innerWidth=document.images["ex_popimage"].width;');

		x.document.writeln('window.innerHeight=document.images["ex_popimage"].height;');

		x.document.writeln('document.title="'+oTitle+'";');

	}else if(window.opera){

		x.document.writeln('window.resizeTo(100,100);');

		x.document.writeln('width=130-(document.body.clientWidth-document.images[0].width);');

		x.document.writeln('height=100-(document.body.clientHeight-document.images[0].height);');

		x.document.writeln('window.resizeTo(width,height);');

	}else{

		x.document.writeln('window.resizeTo(100,100);');

		x.document.writeln('width=100-(document.body.clientWidth-document.images[0].width);');

		x.document.writeln('height=100-(document.body.clientHeight-document.images[0].height);');

		x.document.writeln('window.resizeTo(width,height);');

	}

	x.document.writeln('}</sc'+'ript>');

	x.document.write('<\/head><body style="margin:0px;" id="ex_popbody" scroll="no" onload="reSizeToImage();self.focus();">');

	x.document.write('<img id="ex_popimage" name="ex_popimage" src="'+oContent+'" alt="'+oTitle+'" onclick="window.close();" \/><\/body><\/html>');

	x.document.close();

	/*x.innerWidth=x.document.images["ex_popimage"].width;

	x.innerHeight=x.document.images["ex_popimage"].height;*/



	if( x.focus ) { x.focus(); }

}

// -->

</script>

EOPOPFUNC;

		echo $popfunc;

	}

	

	echo $exhibit_style;

}



// exhibit_set_exc: Sets the config object based on comment tags found in the post

function exhibit_set_exc($matches)

{

	global $exc;

	$objvars = (array)$exc;

		

	if(array_key_exists($matches[1], $objvars))

	{

		$exc->$matches[1] = $matches[2];

		return "<!-- Exhibit: Set \${$matches[1]} to {$exc->$matches[1]} -->";

	}

	else if ($matches[1]=='config')

	{

		$cfgfile = ABSPATH . '/wp-content/plugins/exhibitimg/' . $matches[2];

		if(is_file($cfgfile))

		{

			$exc->load_config_file($cfgfile);

			return "<!-- Exhibit: Loaded config file {$matches[2]} -->";

		}

		else

		{

			return "<!-- Exhibit: Could not load config file {$cfgfile} -->";

		}

	}

	else

	{

		return "\n<!-- Exhibit Error: No config setting \${$matches[1]}.\n     Couldn't set to '{$matches[2]}'. -->\n";

	}

}







// exhibit_thumbnail_link: Returns HTML of a linked thumbnail for a specified image

function exhibit_thumbnail_link($image, $justlink = false)

{

	global $exc, $page;



	$ret = '';

	if($exc->thumbnail_popup)

	{

		$imgurl = get_settings('siteurl').'/'.$image->photo;

		$imgfile = ABSPATH.$image->photo;

		list($width, $height, $type, $attr) = getimagesize($imgfile);

		$width += 10;

		$height += 10;



			

		if('' == $exc->popup_page)

		{

			if($exc->uber_popup)

			{

				$ret .= "<a href=\"{$imgurl}\" onclick=\"window.open('"

					.get_settings('siteurl').'/wp-content/plugins/exhibitimg/exhibit10f.php?navid=' . $image->ID

					."', '_blank', "

					."'width=$width,height=$height,resizeable=1,scrollbars=no,status=no');return false;"

					."\">";			

			}

			else

			{

				$ret .= "<a href=\"{$imgurl}\" onclick=\"exh_popImage('{$imgurl}', '".addslashes($image->caption)."'); return false;\">";

			}

		}

		else

		{

			/*$ret .= "<a href=\"$imgurl\" "

				."onclick=\"javascript:window.open('{$exc->popup_page}{$imgurl}', '_blank', "

				."'width=$width,height=$height,resizeable=1,scrollbars=no,status=no'); "

				." return false\">";*/

			

			$ret .= "<a href=\"javascript:var k=window.open('{$exc->popup_page}{$imgurl}', '_blank', "

				."'width=$width,height=$height,resizeable=1,scrollbars=no,status=no');"

				."\">";			

		}

			

	}

	else

	{

		if('' == $exc->embedded_image)

		{

			if($exc->use_permalinks)

			{

				$imglink = exhibit_permaquery(get_permalink()).'pic='.$image->ID;

			}

			else

			{

				$imglink = $_SERVER['SCRIPT_NAME'].'?p='.$image->post_ID.'&amp;pic='.$image->ID;

			}

		}

		else

		{

			$imglink = $exc->embedded_image.'?p='.$image->post_ID.'&amp;pic='.$image->ID;

		}

		if($page > 1) 

		{

			$imglink .= "&page={$page}";

		}

		$ret .= '<a href="'.$imglink.'">';

	}

	// Link to image only:

	//$ret = '<a href="'.get_settings('siteurl').'/'.$image->photo.'">';



	if(!$justlink)

	{

		$ret = "\t".'<div class="ex_thumb">&nbsp;' . $ret;



		$ret .= '<img src="'.get_settings('siteurl').'/'.$image->thumb.'" alt="'.$image->caption.'" ';

		if($exc->thumb_titles) $ret .= 'title="'.$image->caption.'" ';

		$ret .= '/></a>&nbsp;';

		if($exc->display_captions)

		{

			$ret .= '<div class="ex_caption">'.$image->caption.'</div>';

		}

		$ret .= '</div>'."\n";

	}

	

	return $ret;

}



//exhibit_recalc_pages: Returns the number of pages for a post with paginated images

function exhibit_recalc_pages()

{

	global $wpdb, $exc, $numpages, $multipage, $page, $id;

	

	if($exc->paginate_thumbs > 0)

	{

		$origpages = $numpages;

		$wpdb->hide_errors();

		$ttlimages = $wpdb->get_var("SELECT count(ID) AS ttl FROM {$exc->tableexhibit} WHERE post_ID = {$id};");

		$wpdb->show_errors();

		if($exc->on_first_page)

		{

			$imagepages = ceil($ttlimages / $exc->paginate_thumbs);

			$numpages = max($numpages, $imagepages);

		}

		else

		{

			$imagepages = ceil($ttlimages / $exc->paginate_thumbs) - ($exc->on_last_page?1:0);

			$numpages = $numpages + $imagepages;

		}

		$multipage = ($numpages > 1);

	}

}



//exhibit_paginate: Erases or truncates the image array if pagination is in effect

function exhibit_paginate($images)

{

	global $exc, $numpages, $multipage, $page;



	if($exc->paginate_thumbs > 0)

	{

		$origpages = $numpages;

		if($exc->on_first_page)

		{

			$imagepages = ceil(count($images) / $exc->paginate_thumbs);

			$numpages = max($numpages, $imagepages);

			$imagepage = $page;

		}

		else

		{

			$imagepages = ceil(count($images) / $exc->paginate_thumbs) - ($exc->on_last_page?1:0);

			$numpages = $numpages + $imagepages;

			$imagepage = ($page - $origpages + ($exc->on_last_page?1:0));

		}

		$multipage = ($numpages > 1);

		if(($imagepage > 0) && ($imagepage <= $numpages ))

		{

			$imagechunks = array_chunk($images, $exc->paginate_thumbs);

			if($imagepage <= count($imagechunks))

			{

				$res = $imagechunks[$imagepage - 1];

			}

			else

			{

				$res = array();

			}

		}

		else

		{

			$res = array();

		}

		return $res;

	}

	else

	{

		return $images;

	}

}



//exhibit_some_thumbnails: Callback for thumbnail post config placement

function exhibit_some_thumbnails($matches)

{

	$start = floor($matches[1]) - 1;

	$limit = floor($matches[2]) - $start;

	return exhibit_all_thumbnails(true, $start, $limit);

}



//exhibit_all_thumbnails: Displays linked images of thumbnails in specified array

function exhibit_all_thumbnails($dothumbs, $start = -1, $limit = -1)

{

	global $wpdb, $exc, $id;

	

	if($dothumbs)

	{	



		if('' == $id)

		{

			$id = $_REQUEST['post'];

		}



		$wpdb->hide_errors();

		if(-1 == $start)

		{

			$images = $wpdb->get_results("SELECT * FROM {$exc->tableexhibit} WHERE post_ID = $id ORDER BY picorder;");

			$images = exhibit_paginate($images);

		}

		else

		{

			$images = $wpdb->get_results("SELECT * FROM {$exc->tableexhibit} WHERE post_ID = $id ORDER BY picorder LIMIT {$start}, {$limit};");

		}

		$wpdb->show_errors();

		



		if(count($images) > 0)

		{

			if($exc->preview_like_single)

			{

				$ret = '<div class="exhibit_thumbs">'."\n";

			}

			else

			{

				$ret = '<div class="exhibit_thumbs" id="exhibit_thumbs">'."\n";

			}

			$ret .= "\t".'<div class="ex_clear">&nbsp;</div>'."\n";

			$tcount = 0;

			foreach($images as $image)

			{

				$ret .= exhibit_thumbnail_link($image);

				if($exc->break_every_thumb > 0)

				{

					$tcount ++;

					if($tcount >= $exc->break_every_thumb)

					{

						$ret .= "\t".'<br/>'."\n";

						$tcount = 0;

					}

				}

			}

			$ret .= "\t".'<div class="ex_clear">&nbsp;</div>'."\n";

			$ret .= '</div>'."\n";

		}

		else

		{

			$ret = '';

		}



		return $ret;

	}

	else

	{

		return '';

	}

}



//exhibit_thumbnail: Displays a linked thumbnail for the specified picture id

function exhibit_thumbnail($picid)

{

	global $exc;

	

	$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE ID = $picid;");

	

	return exhibit_thumbnail_link($image);

}



//exhibit_caption: Displays the caption for the pic specified on the querystring

function exhibit_caption()

{

	global $exc, $wpdb;

	

	$picid = $_REQUEST['pic'];

	

	$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE ID = $picid;");

	

	print $image->caption;

}



//exhibit_numeric_index: Returns the numeric index of an array element

function exhibit_numeric_index($needle, $haystack)

{

	$i= 0;

	while($i<count($haystack))

	{

		if($haystack[$i] == $needle)

		{

			return $i;

			break;

		}

		$i++;

	}

	return -1;

}



//exhibit_next_link: Displays a link to the next image

function exhibit_next_link($prompt = 'Next Image &gt;')

{

	global $exc, $wpdb, $id;



	$imagelist = $wpdb->get_col("SELECT ID FROM {$exc->tableexhibit} WHERE post_ID = $id ORDER BY picorder;");

	$index = numeric_index($_REQUEST['pic'], $imagelist);

	

	if($index+1 < count($imagelist))

	{

		$index ++;

		if('' == $exc->embedded_image)

		{

			if($exc->use_permalink)

			{

				$imglink = exhibit_permaquery(get_permalink()).'pic='.$imagelist[$index];

			}

			else

			{

				$imglink = $_SERVER['SCRIPT_NAME'].'?p='.$id.'&amp;pic='.$imagelist[$index];

			}

		}

		else

		{

			$imglink = $exc->embedded_image.'?p='.$id.'&amp;pic='.$imagelist[$index];

		}

		if($page > 1) 

		{

			$imglink .= "&page={$page}";

		}	

		print "<a href=\"$imglink\">$prompt</a>";

	}

}



//exhibit_previous_link: Displays a link to the previous image

function exhibit_previous_link($prompt = '&lt; Previous image')

{

	global $exc, $wpdb, $id;



	$imagelist = $wpdb->get_col("SELECT ID FROM {$exc->tableexhibit} WHERE post_ID = $id ORDER BY picorder;");

	$index = numeric_index($_REQUEST['pic'], $imagelist);

		

	if($index > 0)

	{

		$index --;

		if('' == $exc->embedded_image)

		{

			if($exc->use_permalinks)

			{

				$imglink = exhibit_permaquery(get_permalink()).'pic='.$imagelist[$index];

			}

			else

			{

				$imglink = $_SERVER['SCRIPT_NAME'].'?p='.$id.'&amp;pic='.$imagelist[$index];

			}

		}

		else

		{

			$imglink = $exc->embedded_image.'?p='.$id.'&amp;pic='.$imagelist[$index];

		}

		if($page > 1) 

		{

			$imglink .= "&page={$page}";

		}

		print "<a href=\"$imglink\">$prompt</a>";

	}

}



//exhibit_exif_info: Returns all or one of the EXIF data elements for the pic image on the querystring

function exhibit_exif_info($unit = '')

{

	global $exc, $wpdb, $id;



	echo $picid;

	

	$picid = $_REQUEST['pic'];

	$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE ID = $picid;");

	

	$fname = ABSPATH . $image->photo;

	

	$exif = exif_read_data($fname, 'IFD0');

	if($exif===false)

	{

		print "No info";

	}

	else

	{

	

		$exif = exif_read_data($fname, 0, true);

		foreach ($exif as $key => $section) 

		{

			foreach ($section as $name => $val) 

			{

				$exifinfo["$key.$name"] = $val;

			}

		}



		if('' == $unit)

		{

			echo "<pre>";

			print_r($exifinfo);

			echo "</pre>";

		}

		else

		{

			print $exifinfo[$unit];

		}

	}

}



// exhibit_random_thumb: Displays a random thumbnail from any post or a specific post

function exhibit_random_thumb($postid = -1)

{

	global $wpdb, $exc;

	

	if(-1 == $postid)

	{

		$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} ORDER BY rand() LIMIT 1;");

	}

	else

	{

		$image = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE post_ID = {$postid} ORDER BY rand() LIMIT 1;");

	}

	

	print exhibit_thumbnail_link($image);

}





// exhibit_permaquery: Adds a character to the end of a permalink to append a query parameter

function exhibit_permaquery($permalink)

{

	if(preg_match('|\?|', $permalink))

	{

		return "$permalink&amp;";

	}

	else

	{

		return "$permalink?";

	}

}





?>