<?php

/*

*

* Inline Post Editing for Exhibit

* -------------------------------

* Version 1.1d

* Owen Winkler

* http://www.asymptomatic.net/wp-hacks

*/



/*

Exhibit - A photo gallery plugin for WordPress

Copyright (c) 2004 Owen Winkler



Permission is hereby granted, free of charge, to any person

obtaining a copy of this software and associated

documentation files (the "Software"), to deal in the

Software without restriction, including without limitation

the rights to use, copy, modify, merge, publish,

distribute, sublicense, and/or sell copies of the Software,

and to permit persons to whom the Software is furnished to

do so, subject to the following conditions:



The above copyright notice and this permission notice shall

be included in all copies or substantial portions of the

Software.



THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY

KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE

WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR

PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS

OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR

OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR

OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE

SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



add_action('admin_footer', 'exhibit_show_form');

add_filter('admin_head', 'exhibit_admin_head');

add_filter('edit_post', 'exhibit_process_form');





function exhibit_admin_head($content)

{

	global $exc;

	

	exhibit_head($content);

	

	// $thispage is a URL to this plugin file, which does special stuff when run on its own

	$thispage = $exc->thispage();

	$id = @$_REQUEST['post'];



	$exhibit_style = "

	<script type=\"text/javascript\">

	<!--

	/* Support for inserting Exhibit thumbnails */

	function edInsertFullsized(myFull, myCaption) {

				myValue = '<img src=\"' 

				+ myFull 

				+ '\" alt=\"' + myCaption 

				+ '\" border=\"0\" />';

		edInsertContent(edCanvas, myValue);

	}

	function edInsertThumbnailLink(myThumb, myFull, myCaption) {";

	if($exc->full_image_insert)

	{

		$exhibit_style .= "

				myValue = '<img src=\"' 

				+ myFull 

				+ '\" alt=\"' + myCaption 

				+ '\" border=\"0\" />';";

	}

	else

	{

		if($exc->thumbnail_popup)

		{

			$exhibit_style .= "

			myValue = '<a href=\"' + myFull + '\" onclick=\"exh_popImage(\'' + myFull + '\', \'' + myCaption + '\');return false;\">'

			";

		}

		else

		{

			$exhibit_style .= "

			myValue = '<a href=\"' + myFull + '\">'

			";

		}



		$exhibit_style .= "

				+ '<img src=\"' 

				+ myThumb 

				+ '\" alt=\"' + myCaption 

				+ '\" border=\"0\" /></a>';";

	}

	$exhibit_style .= "

		edInsertContent(edCanvas, myValue);

	}

	/* Support for inserting post-level config options */

	function edExhibitConfig(i, thisSelect) {

		if(i != '')

		{

			var tempStr = '<!\\055-exhibit:' + i + '-\\055>';

			edCanvas.value = tempStr + edCanvas.value;

		}

		else

		{

			var tempStr = '<!\\055-exhibit-\\055>';

			edInsertContent(edCanvas, tempStr);

		}

		thisSelect.selectedIndex = 0;

	}

	/* Support for clicking Remove in the image list */

	function ex_ffframe(url)

	{

		var exframe = window.document.getElementById('exhibitframe');

		if(exframe.contentDocument)

		{

			exframe.contentDocument.location.href = url;

		}

		else

		{

			exframe.contentWindow.document.location.href = url;

		}

	}

	function ex_removeimage(pid)

	{

		if(confirm('Remove this image from the post?'))

		{

			var path = window.document.getElementById('ex_path').value;

			var newhref = '{$thispage}?postid={$id}&remove=' + pid + '&path=' + path;

			ex_ffframe(newhref);

		}

		return false;

	}

	function ex_previewimage(pid, doit)

	{

		var path = window.document.getElementById('ex_path').value;

		var newhref = '{$thispage}?postid={$id}&preview=' + pid + '&state=' + doit + '&path=' + path;

		ex_ffframe(newhref);

		return true;

	}

	function ex_moveimage(pid, direction)

	{

		var path = window.document.getElementById('ex_path').value;

		var newhref = '{$thispage}?postid={$id}&move=' + pid + '&direction=' + direction + '&path=' + path;

		ex_ffframe(newhref);

		return false;

	}

	function ex_previewcheck()

	{

		var el = window.event.srcElement;

		eval(el.exclick);

	}

	//-->

	</script>";

	echo $exhibit_style;

}





// exhibit_is_installed: Returns true if Exhibit table is installed

function exhibit_is_installed()

{

	global $wpdb, $exc;

	

	$tables = $wpdb->get_col('show tables;');

	if (in_array($exc->tableexhibit, $tables)) exhibit_upgrade();

	return in_array($exc->tableexhibit, $tables);

}



/*

exhibit_maybe_add_column: Optionally executes DDL statement if field doesn't exist in table

Copied from upgrade-functions.php, changed name to make room in namespace.

*/

function exhibit_maybe_add_column($table_name, $column_name, $create_ddl) {

    global $wpdb, $debug;

    foreach ($wpdb->get_col("DESC $table_name", 0) as $column ) {

        if ($debug) echo("checking $column == $column_name<br />");

        if ($column == $column_name) {

            return false; // Changed this return value for Exhibit

        }

    }

    //didn't find it try to create it.

    $q = $wpdb->query($create_ddl);

    // we cannot directly tell that whether this succeeded!

    foreach ($wpdb->get_col("DESC $table_name", 0) as $column ) {

        if ($column == $column_name) {

            return true;

        }

    }

    return false;

}



function exhibit_upgrade()

{

	global $exc, $wpdb;



	if(exhibit_maybe_add_column($exc->tableexhibit, 'picorder', "ALTER TABLE $exc->tableexhibit ADD COLUMN picorder INTEGER default 0"))

	{

		$wpdb->query("UPDATE {$exc->tableexhibit} SET picorder = ID;");

	}

}





// exhibit_install: Installs the Exhibit table

function exhibit_install($return_errors=false)

{

	global $wpdb, $exc;

	

	$err = '';

	

	if(('install' != $_REQUEST['exhibit']) && (!$return_errors))

	{

		$urltoexhibit = get_settings('siteurl') . '/wp-content/plugins/' . basename( __FILE__ );

		if(!$exc->config_loaded)

		{

			$err .= "The Exhibit config file was not found.<br/>";

		}

		$err .= 'The table required to use Exhibit ('.$exc->tableexhibit.') is not installed.';

		$err .= '<br/>Please click <a href="' . exhibit_permaquery($_SERVER['REQUEST_URI']) . 'exhibit=install">here</a>&nbsp;to install it.';

		$err .= '<br/>(You will lose changes you have made to this post unless you save them first!)';

		print $err;

		return false;

	}

	else

	{

		$err .= 'Installing Exhibit tables...<br/>';



		$qry = "CREATE TABLE {$exc->tableexhibit} ( "

			."ID int(11) NOT NULL auto_increment, "

			."post_ID int(11) NOT NULL default '0', "

			."photo varchar(100) NOT NULL default '', "

			."thumb varchar(100) default NULL, "

			."caption text, "

			."preview smallint(6) NOT NULL default '0', "

			."PRIMARY KEY (ID) "

			.")";



		$wpdb->query($qry);

		

		exhibit_upgrade();

		

		if(!exhibit_is_installed())

		{

			$err .= 'The Exhibit table could not be created.';

			if($return_errors)

			{

				return $err;

			}

			else

			{

				$err .= '</fieldset>';  // End the fieldset and exit

				return false;

			}

		}

		else

		{

			return true;

		}

	}

}



// exhibit_show_form: Displays the exhibit form in the WP interface

function exhibit_show_form()

{

	global $wpdb, $exc;



	// Are we on the right page?

	if(preg_match('|post.php|i', $_SERVER['SCRIPT_NAME']))

	{

		print '<fieldset id="postexhibit" style="border: 1px solid #aaa;padding: .5em;width: 97%;margin-top:15px;">';

		print '<legend>Exhibit</legend>';



		$goexhibit = false;



		if(!exhibit_is_installed())

		{

			$goexhibit = exhibit_install();

		}	

		else

		{

			$goexhibit = true;

		}



		if($goexhibit)

		{

			exhibit_actual_form();

		}

		print '</fieldset>';



		 echo '<script language="JavaScript" type="text/javascript">';



		if ($_GET['action'] == 'edit' || get_settings('advanced_edit')) {

			echo 'var submitButtonPara = document.getElementById("save").parentNode;';

		} else {

			echo 'var submitButtonPara = document.getElementById("saveasdraft").parentNode;';

		}



		echo 'var PostExhibit = document.getElementById("postexhibit");

		submitButtonPara.parentNode.insertBefore(PostExhibit, submitButtonPara);

			</script>

			';

	}

}



// process_exhibit_form: Accepts input from the form and makes changes

function exhibit_process_form($id)

{

	global $wpdb, $exc;

		

	//Change captions

	foreach($_POST['ex_caption'] as $index => $item)

	{

		$wpdb->query("UPDATE {$exc->tableexhibit} SET caption = '$item' WHERE ID = $index LIMIT 1;");		

	}

	

}



// exhibit_actual_form: Displays the Exhibit editing form on the post editing page

function exhibit_actual_form()

{

	global $wpdb, $exc, $user_level;



	$exc_static = new ex_config();



	$id = @$_REQUEST['post'];

	

	if(''==$id)

	{

		print "<p>You must save this post before you add images to it with Exhibit.</p>";

		return;

	}



	// $thispage is a URL to this plugin file, which does special stuff when run on its own

	$thispage = $exc->thispage();



	// Display a list of all current tumbnails

	if($exc->multi_preview)

	{

		$previnputtype='checkbox';

		$prevprompt='Checkbox';

	}

	else

	{

		$previnputtype='radio';

		$prevprompt='Radio button';

	}

	

	print '<div style="width:350px;height:216px;border:1px solid #cccccc;padding:3px;float:left;">';

	

	// Create Alterations Box

	print 'Post Config: <select onchange="edExhibitConfig(this.options[this.selectedIndex].value, this);">';

	print '<option value="" selected="selected">--insert--</option>';

	print '<option value="">Selected Thumbnail To Appear Here</option>';

	

	foreach($exc_static->editoptions as $text => $value)

	{

		print "<option value=\"$value\">$text</option>";

	}

	

	print '</select>';

	

	print '<div style="width:350px;height:180px;overflow:auto;" id="ex_image_scroll">'."\n";

	$textwidth = 300-$exc->edit_thumbnail_width;

	if(''==$id)

	{

		$images = '';

	}

	else

	{

		$images = $wpdb->get_results("SELECT * FROM {$exc->tableexhibit} WHERE post_ID = $id ORDER BY picorder;");

	}

	$foundpreview = false;

	if('' == $images)

	{

		print "<em>No images...</em>";

	}

	else

	{

		foreach($images as $image)

		{

			print "<div style=\"margin:5px;border-bottom:1px dotted #cccccc;padding-bottom:5px;\"><img src=\"".get_settings('siteurl')."/{$image->thumb}\" style=\"width:{$exc->edit_thumbnail_width}px;margin:0px;float:left;\" alt=\"Click to insert into post\" onclick=\"edInsertThumbnailLink('".get_settings('siteurl')."/{$image->thumb}','".get_settings('siteurl')."/{$image->photo}','".addslashes($image->caption)."')\" />\n";

			print "<div style=\"margin-left:{$exc->edit_thumbnail_width}px;padding-left:3px;\"><input type=\"text\" name=\"ex_caption[{$image->ID}]\" value=\"{$image->caption}\" style=\"width:{$textwidth}px;\" title=\"Image Caption\" /><br />\n";

			print " <a href=\"#postexhibit\" style=\"float:right;\" title=\"Click to remove this image from the post\" onclick=\"return ex_removeimage({$image->ID});\">Remove</a> ";

			print "<label>Preview:&nbsp;<input type=\"{$previnputtype}\" title=\"Use as preview\" name=\"ex_preview[]\" id=\"ex_preview{$image->ID}\" value=\"{$image->ID}\"\n";

			if($image->preview == 1) {

				print " checked=\"checked\"";

				$foundpreview = true;

			}

			print " onclick=\"return ex_previewimage({$image->ID}, this.checked);\"";

			print " /></label>\n";

			print "<a href=\"#postexhibit\" title=\"Click to move this image toward the back\" onclick=\"return ex_moveimage({$image->ID}, -1);\" style=\"border-bottom:none;margin-left:15px;\"><img src=\"" . get_settings('siteurl') . "/wp-content/plugins/exhibitimg/exhibit_down.gif\" border=\"0\" /></a>";

			print "<a href=\"#postexhibit\" title=\"Click to move this image toward the front\" onclick=\"return ex_moveimage({$image->ID}, 1);\" style=\"border-bottom:none;\"><img src=\"" . get_settings('siteurl') . "/wp-content/plugins/exhibitimg/exhibit_up.gif\" border=\"0\" /></a> ";

			print "</div><div style=\"clear:both;\"> </div></div>\n";

		}

	}

	print "</div>\n";

	if(!$exc->multi_preview)

	{

		print "<div id=\"spacer\" style=\"clear:both;border-top:1px dotted #cccccc;padding:3px;\"><label title=\"Use no preview\">Use No Preview:<input type=\"radio\" name=\"ex_preview[]\" id=\"ex_nopreview\" value=\"-1\"";

		if(!$foundpreview) print " checked=\"checked\"";

		print " /></label>";

		print "</div>";

	}

	print '</div>';

		

	print '<input type="hidden" name="ex_path" id="ex_path" value="" />';

	

	print '<div style="width:300px;height:216px;border:1px solid #cccccc;padding:3px;float:left;margin-left:5px;">';

	print "<a target=\"exhibitframe\" href=\"{$thispage}?postid={$id}\">Reset to image / path</a>";

	print "<iframe frameborder=\"0\" id=\"exhibitframe\" name=\"exhibitframe\" src=\"{$thispage}?postid={$id}\" style=\"border-width:1px 0px;border-style:dotted;height:197px;border-color:#cccccc;\"></iframe>";

	print '</div>';

}









?>