<?php

/*

*

* File Management Features for Exhibit

* ------------------------------------

* Version 1.1d

* Owen Winkler

* http://www.asymptomatic.net/wp-hacks

*/



/*

Exhibit - A photo gallery plugin for WordPress

Copyright (c) 2004 Owen Winkler



Permission is hereby granted, free of charge, to any person

obtaining a copy of this software and associated

documentation files (the "Software"), to deal in the

Software without restriction, including without limitation

the rights to use, copy, modify, merge, publish,

distribute, sublicense, and/or sell copies of the Software,

and to permit persons to whom the Software is furnished to

do so, subject to the following conditions:



The above copyright notice and this permission notice shall

be included in all copies or substantial portions of the

Software.



THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY

KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE

WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR

PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS

OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR

OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR

OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE

SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



// File was executed solo

$incfile = 'wp-config.php';

$c=0;

while(!is_file($incfile))

{

	$incfile = '../' . $incfile;

	$c++;

	if($c==30) {

		echo "Could not find wp-config.php.";

		exit;

	}

}

require_once($incfile);





get_currentuserinfo();



if(isset($_REQUEST['navid']))

{

	exhibit_nav_pic($_REQUEST['navid']);

	exit;

}



// First authorize the user to operate this page solo

if($user_level == 0)

{

	die("Unauthorized.");

}



?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

<head>

	<title>Exhibit file manager</title>

	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo get_settings('blog_charset'); ?>" />

	<link rel="stylesheet" href="<?php echo get_settings('siteurl'); ?>/wp-admin/wp-admin.css" type="text/css" />

	<style type="text/css">

		a {

			border-bottom: none;

			text-decoration: underline;

		}

		a:hover {

			border-bottom: none;

			text-decoration: underline;

		}

	</style>

	<script type="text/javascript"><!--

		function delExhibitImage(imgid)

		{

			var pardoc = window.parent.document;

			var scroll = pardoc.getElementById('ex_image_scroll');

			var imgs = pardoc.getElementsByTagName('input');

			for(z=0;z<imgs.length;z++)

			{

				if(imgs[z].getAttribute('name') == 'ex_caption[' + imgid + ']')

				{

					var imgdiv = imgs[z].parentNode.parentNode;

					imgdiv.parentNode.removeChild(imgdiv);

					break;

				}

			}

		}

		function exclicks()

		{

			alert(window.event);

		}	

		function addExhibitImage(img, fimg, id, preview)

		{

			var pardoc = window.parent.document;

			var theDiv = pardoc.createElement('div');

			theDiv.style.margin = '5px';

			theDiv.style.borderBottom = '1px dotted #cccccc';

			theDiv.style.paddingBottom = '5px';

			pardoc.getElementById('ex_image_scroll').appendChild(theDiv);

			

			var theImg = pardoc.createElement('img');

			theImg.setAttribute('src', '<?php echo get_settings('siteurl'); ?>/' + img);

			theImg.style.width = '<?php echo $exc->edit_thumbnail_width; ?>px';

			theImg.setAttribute('align', 'left');

			theImg.setAttribute("onclick", "edInsertThumbnailLink('<?php echo get_settings('siteurl'); ?>/" + img + "','<?php echo get_settings('siteurl'); ?>/" + fimg + "',window.document.getElementById('ex_caption" + id + "').value)");

			theDiv.appendChild(theImg);

			

			var theDiv2 = pardoc.createElement('div');

			theDiv2.style.marginLeft = '<?php echo $exc->edit_thumbnail_width; ?>px';

			theDiv2.style.paddingLeft = '3px';

			theDiv.appendChild(theDiv2);

			

			var theInput = pardoc.createElement('input');

			theInput.setAttribute('type', 'text');

			theInput.style.width = '240px';

			theInput.setAttribute('name', 'ex_caption[' + id + ']');

			theInput.id = 'ex_caption' + id;

			theInput.setAttribute('value', '<?php echo addslashes($exc->default_comment); ?>');

			theDiv2.appendChild(theInput);

			

			var theBR = pardoc.createElement('br');

			theDiv2.appendChild(theBR);

			

			var removeLink = pardoc.createElement('a');

			removeLink.setAttribute('href', 'javascript:var z=ex_removeimage(' + id + ');');

			removeLink.setAttribute('style', 'display:block;float:right;');

			removeLink.style.styleFloat = 'right';

			removeLink.setAttribute('title', 'Click to remove this image from the post');

			theDiv2.appendChild(removeLink);

			var removeText = pardoc.createTextNode('Remove');

			removeLink.appendChild(removeText);

						

			theDiv2.appendChild(pardoc.createTextNode(' '));



			var previewLabel = pardoc.createElement('label');

			theDiv2.appendChild(previewLabel);			

			var previewText = pardoc.createTextNode('Preview:');

			previewLabel.appendChild(previewText);

			previewLabel.appendChild(pardoc.createTextNode(' '));

			var previewInput = pardoc.createElement('input');

			previewInput.setAttribute('type', 'checkbox');

			previewInput.setAttribute('name', 'ex_preview[]');

			previewInput.setAttribute('value', id);

			if(preview)

			{

				previewInput.setAttribute('checked', 'checked');

			}

			previewInput.setAttribute('onclick', 'return ex_previewimage(' + id + ', this.checked);');

			if(document.all) {

				previewInput.exclick = 'ex_previewimage(' + id + ', el.checked);';

				previewInput['onclick'] = window.parent.ex_previewcheck;

			}

			previewLabel.appendChild(previewInput);

						

			var moveBackA = pardoc.createElement('a');

			moveBackA.setAttribute('href', 'javascript:var z=ex_moveimage(' + id + ', -1);');

			moveBackA.setAttribute('style', 'border-bottom: none;margin-left:15px;');

			moveBackA.style.borderBottom = 'none';

			moveBackA.style.marginLeft = '15px';

			moveBackA.setAttribute('title', 'Click to move this image toward the back');

			theDiv2.appendChild(moveBackA);

			var moveBack = pardoc.createElement('img');

			moveBack.setAttribute('src', '<?php echo get_settings('siteurl'); ?>/wp-content/plugins/exhibitimg/exhibit_down.gif');

			moveBack.setAttribute('border', '0');

			moveBackA.appendChild(moveBack);

			

			var moveForeA = pardoc.createElement('a');

			moveForeA.setAttribute('href', 'javascript:var z=ex_moveimage(' + id + ', 1);');

			moveForeA.setAttribute('style', 'border-bottom: none;');

			moveForeA.style.borderBottom = 'none';

			moveForeA.setAttribute('title', 'Click to move this image toward the front');

			theDiv2.appendChild(moveForeA);

			var moveFore = pardoc.createElement('img');

			moveFore.setAttribute('src', '<?php echo get_settings('siteurl'); ?>/wp-content/plugins/exhibitimg/exhibit_up.gif');

			moveFore.setAttribute('border', '0');

			moveForeA.appendChild(moveFore);

			

			var theBreaker = pardoc.createElement('div');

			theBreaker.style.clear = 'both';

			theDiv.appendChild(theBreaker);

		}

		function hangnail_off()

		{

			var pardoc = window.document;

			var hangimg = pardoc.getElementById('hangimg');

			if(hangimg != null)

			{

				pardoc.getElementById('toast').removeChild(hangimg);

			}		

		}

		function hangnail(img)

		{

			var pardoc = window.document;

			hangnail_off();



			var iebody=(document.compatMode=="CSS1Compat")? document.documentElement : document.body

			var scroll_top = (document.all && !window.opera)? iebody.scrollTop : window.pageYOffset;

			var theImg = pardoc.createElement('img');

			theImg.setAttribute('src', '<?php echo get_settings('siteurl'); ?>/' + img + '?time=<?php echo microtime(); ?>');

			theImg.style.border = '1px solid #cccccc';

			theImg.style.padding = '3px';

			theImg.style.backgroundColor = '#ffffff';

			theImg.style.position = 'absolute';

			if(!(document.all && !window.opera))

				theImg.style.left = '200px';

			else

				theImg.style.left = (270 - <?php echo ($exc->thumb_width + 8); ?>) + 'px';

			theImg.style.top = (scroll_top + 3) + 'px';

			theImg.setAttribute('id', 'hangimg');

			if(!(document.all && !window.opera)) theImg.style.width = '<?php echo ($exc->edit_thumbnail_width + 8); ?>px';

			pardoc.getElementById('toast').appendChild(theImg);

		}

		function reposExhibitImage(imgid)

		{

			var pardoc = window.parent.document;

			var scroll = pardoc.getElementById('ex_image_scroll');

			var imgs = pardoc.getElementsByTagName('input');

			for(z=0;z<imgs.length;z++)

			{

				if(imgs[z].getAttribute('name') == 'ex_caption[' + imgid + ']')

				{

					var imgdiv = imgs[z].parentNode.parentNode;

					var parnode = imgdiv.parentNode;

					imgdiv.parentNode.removeChild(imgdiv);

					parnode.appendChild(imgdiv);

					break;

				}

			}

		}

		//--></script>

</head>

<body id="toast">



<?





// Create thumbnails?

if(isset($_REQUEST['thumbs']) && exhibit_has_gd())

{

	switch($_REQUEST['thumbs'])

	{

	case 'new':

		exhibit_make_thumbnails($_REQUEST['path'], false);

		break;

	case 'fresh':

		exhibit_make_thumbnails($_REQUEST['path'], true);

		break;

	default:

		exhibit_make_thumbnails($_REQUEST['path'], true, $_REQUEST['thumbs']);

		break;

	}		

}



// Create directory?

if(isset($_REQUEST['mkdir']))

{

	exhibit_make_dir();

}

// Add path?

if(isset($_REQUEST['addpath']))

{

	exhibit_add_image_path($_REQUEST['addpath'], $_REQUEST['postid']);

}

// Add file?

if(isset($_REQUEST['addfile']))

{

	exhibit_add_files($_REQUEST['addfile'], $_REQUEST['postid']);

}

// Delete File?

if(isset($_REQUEST['delfile']))

{

	exhibit_del_files($_REQUEST['delfile']);

}

// Delete File?

if(isset($_REQUEST['delpath']))

{

	exhibit_del_path($_REQUEST['delpath']);

}

if(isset($_REQUEST['rotate']))

{

	exhibit_do_rotate($_REQUEST['path'], $_REQUEST['file'], $_REQUEST['rotate']);

}

// Remove image from post?

if(isset($_REQUEST['remove']))

{

	exhibit_remove_image($_REQUEST['remove']);

}

// Preview image for post?

if(isset($_REQUEST['preview']))

{

	exhibit_preview_image($_REQUEST['preview'], $_REQUEST['state']);

}

// Move image in order?

if(isset($_REQUEST['move']))

{

	exhibit_move_image($_REQUEST['move'], $_REQUEST['direction']);

}



// What to do now?

if(isset($_REQUEST['upload']))

{

	exhibit_file_uploader();

}

else

{

	exhibit_file_picker();

}

?>



</body>

</html>



<?php



//exhibit_file_picker: Displays a list of files and directories to add

function exhibit_file_picker()

{

	global $exc, $user_level;

	

	$tpath = @$_REQUEST['path'];



	print "<strong>Current directory: </strong>";

	if('' == @$_REQUEST['path'])

	{

		print "/";

	}

	else

	{

		print "{$_REQUEST['path']}";

	}

	print "<br />";

	

	//Use script to set parent level document directory field

?>

<script type="text/javascript"><!--

var pardoc = window.parent.document;

pardoc.getElementById('ex_path').value = '<?php echo $tpath; ?>';

//--></script>

<?php



	$path = ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path'];

	$files = exhibit_get_files($path);

	$thumbcount = 0;

	$nothumbcount = 0;

	$outtemp = "<table>\n";

	

	$outtemp .= exhibit_dir_features($tpath);

		

	foreach($files as $f)

	{

		$outtemp .= "<tr>\n";

		if($f['file'])

		{

			if($exc->permissions(array('delete')))

			{

				$outtemp .= "<td><a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}")."&amp;delfile=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\" title=\"Click to delete this image\" onclick=\"return confirm('Are you sure you want to delete ".htmlentities(addslashes("{$f['name']}"))."?');\"><img src=\"exhibitimg/exhibit_delete.gif\" border=\"0\" alt=\"[delete file]\" /></a></td>\n";

			}

			else

			{

				$outtemp .= "<td>&nbsp;</td>";

			}

			if($f['thumb'])

			{

				$shangnail = " onmouseover=\"hangnail('{$exc->imagedir}".$exc->userroot().addslashes("{$tpath}/{$f['tfile']}")."');\" onmouseout=\"hangnail_off();\"";

				$outtemp .= "<td id=\"t{$thumbcount}\"><a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}")."&amp;addfile=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\" title=\"Click to add this image\" {$shangnail}>";

				$outtemp .= "<img src=\"exhibitimg/exhibit_img.gif\" border=\"0\" alt=\"[Image]\" /></a></td>\n";

				$outtemp .= "<td width=\"100%\" style=\"white-space: nowrap\">";

				if(exhibit_has_imagerotate())

				{

					//exhibit_rotate ( $FileIn, 90, $FileOut );

					$outtemp .= "<a href=\"{$_SERVER['SCRIPT_NAME']}?rotate=90&file=".urlencode("{$f['name']}")."&path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\" title=\"Rotate Left\" {$shangnail}><img src=\"exhibitimg/exhibit_rot_l.gif\" border=\"0\" alt=\"[left]\"></a>";

					$outtemp .= "<a href=\"{$_SERVER['SCRIPT_NAME']}?rotate=270&file=".urlencode("{$f['name']}")."&path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\" title=\"Rotate Right\" {$shangnail}><img src=\"exhibitimg/exhibit_rot_r.gif\" border=\"0\" alt=\"[right]\"></a>";

				}

				$outtemp .= "<a href=\"#\" onclick=\"window.parent.edInsertFullsized('".get_settings('siteurl').'/'.$exc->imagedir.$exc->userroot().addslashes("{$tpath}/{$f['name']}")."','')\" title=\"Insert full-sized HTML\"><img src=\"exhibitimg/exhibit_tags.gif\" border=\"0\" alt=\"[HTML]\"></a>";



				$outtemp .= "&nbsp;".htmlentities("{$f['name']}")."</td>\n";

				$thumbcount ++;

			}

			else

			{

				if(exhibit_has_gd())

				{

					$outtemp .= "<td id=\"n{$nothumbcount}\"><a href=\"{$_SERVER['SCRIPT_NAME']}?thumbs={$f['name']}&path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\"><img src=\"exhibitimg/exhibit_thumb.gif\" border=\"0\" alt=\"[make thumb]\" title=\"Click to create a single thumbnail\" /></a></td>\n";

				}

				else

				{

					$outtemp .= "<td><img src=\"exhibitimg/exhibit_thumb.gif\" border=\"0\" alt=\"[no thumb]\" title=\"This file has no thumbnail\" /></td>\n";

				}

				$outtemp .= "<td width=\"100%\" style=\"white-space: nowrap\">";

				if(exhibit_has_imagerotate())

				{

					//exhibit_rotate ( $FileIn, 90, $FileOut );

					$outtemp .= "<a href=\"{$_SERVER['SCRIPT_NAME']}?rotate=90&file=".urlencode("{$f['name']}")."&path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\" title=\"Rotate Left\"><img src=\"exhibitimg/exhibit_rot_l.gif\" border=\"0\" alt=\"[left]\"></a>";

					$outtemp .= "<a href=\"{$_SERVER['SCRIPT_NAME']}?rotate=270&file=".urlencode("{$f['name']}")."&path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\" title=\"Rotate Right\"><img src=\"exhibitimg/exhibit_rot_r.gif\" border=\"0\" alt=\"[right]\"></a>";

				}

				$outtemp .= "<a href=\"#\" onclick=\"window.parent.edInsertFullsized('".get_settings('siteurl').'/'.$exc->imagedir.$exc->userroot().addslashes("{$tpath}/{$f['name']}")."','')\" title=\"Insert full-sized HTML\"><img src=\"exhibitimg/exhibit_tags.gif\" border=\"0\" alt=\"[HTML]\"></a>";

				$outtemp .= "&nbsp;".htmlentities("{$f['name']}")."</td>\n";

				$nothumbcount ++;

			}

		}

		else

		{

			if($exc->permissions(array('delete')))

			{

				$outtemp .= "<td><a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}")."&amp;delpath=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\" title=\"Click to delete this ENTIRE directory\" onclick=\"return confirm('Are you sure you want to delete ".htmlentities(addslashes("{$f['name']}"))." and EVERYTHING CONTAINED THEREIN?');\" ><img src=\"exhibitimg/exhibit_delete.gif\" border=\"0\" alt=\"[delete directory]\" /></a></td>\n";

			}

			else

			{

				$outtemp .= "<td>&nbsp;</td>";

			}

			$linktag = "<a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\">";

			if($f['thumb'])

			{

				$outtemp .= "<td><a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}")."&amp;addpath=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\" onclick=\"return confirm('Add all images in ".htmlentities(addslashes($f['name']))." to this post?');\" title=\"Click to add all images in this directory\"><img src=\"exhibitimg/exhibit_img_folder.gif\" border=\"0\" alt=\"[Thumbnail Folder]\" /></a></td>\n";

				$outtemp .= "<td width=\"100%\" style=\"white-space: nowrap\">&nbsp;<a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\">".htmlentities("{$f['name']}")."</a></td>\n";

			}

			else

			{

				if(exhibit_has_gd())

				{

					$outtemp .= "<td><a href=\"{$_SERVER['SCRIPT_NAME']}?thumbs=new&path=".urlencode("{$tpath}/{$f['name']}")."&amp;postid={$_REQUEST['postid']}\" onclick=\"return confirm('Create all thumbnails for this directory?');\" title=\"Click to create all thumbnails for this directory\"><img src=\"exhibitimg/exhibit_folder.gif\" border=\"0\" alt=\"[folder]\"></a></td>\n";

				}

				else

				{

					$outtemp .= "<td><img src=\"exhibitimg/exhibit_folder.gif\" border=\"0\" title=\"Folder with no thumbnail directory\"/></td>\n";

				}

				$outtemp .= "<td width=\"100%\" style=\"white-space: nowrap\">&nbsp;{$linktag}".htmlentities("{$f['name']}")."</a></td>\n";

			}

		}

		$outtemp .= "</tr>\n";

	}

	$outtemp .= "</table>";

	

	print $outtemp;

	

}



// exhibit_sortfiles: Sorts files first by file/folder then by filename

function exhibit_sortfiles($a, $b)

{

	if($a['file'] && !$b['file']) return 1;

	if($b['file'] && !$a['file']) return -1;

  if ($a['name'] == $b['name']) {

   return 0;

  }

  return ($a['name'] < $b['name']) ? -1 : 1;

}



// exhibit_get_files: Returns an array of file and directory data for a path

function exhibit_get_files($path) {

	global $exc;



	$res = array();



	//Make user directory	

	$nupath = ABSPATH . $exc->imagedir . $exc->userroot();

	if(!is_dir($nupath))

	{

		umask(0000);

		if($exc->use_chmod_dir != 0) 

		{

			mkdir($nupath, $exc->use_chmod_dir);

		}

		else

		{

			mkdir($nupath);

		}

	}



	if(!is_dir($path))

	{



		print "<p>'".htmlentities($path). "' is not a valid directory on this server.  Check your image directory settings in Exhibit.</p>";

		print "<p>You may need to create a user directory before you can use the file picker.</p>";

		return array();

	}



	if ($handle = opendir($path)) 

	{

		while (false !== ($file = readdir($handle))) 

		{

			if ($file != "." && $file != ".." && $file != "t")

			{

				if(is_dir($path.'/'.$file)) 

				{

					if(is_dir($path.'/'.$file.'/t'))

					{

						$res[] = array('name' => $file, 'thumb' => true, 'file' => false);

					}

					else

					{

						$res[] = array('name' => $file, 'thumb' => false, 'file' => false);

					}

				}

				else

				{

					if(strtolower(substr($file, 0, 6)) != 'thumb-') {

						$ftype = strtolower(substr($path.'/'.$file, -4, 4));

						if(in_array($ftype, $exc->valid_filetypes))

						{

							if(is_file($path.'/t/'.$file) || in_array($ftype, $exc->nothumb_filetypes))

							{

								$res[] = array('name' => $file, 'thumb' => true, 'file' => true, 'tfile' => "t/{$file}");

							}

							else if(is_file($path.'/thumb-'.$file))

							{

								$res[] = array('name' => $file, 'thumb' => true, 'file' => true, 'tfile' => "thumb-{$file}");

							}

							else

							{

								$res[] = array('name' => $file, 'thumb' => false, 'file' => true);

							}

						}

					}

				}

			}

		}

		closedir($handle);

	}

	usort($res, 'exhibit_sortfiles');

	return $res;

}



//exhibit_has_gd: Returns true if the PHP installation has GD functions available

function exhibit_has_gd()

{

	return function_exists('ImageCreateFromJPEG');

}



function exhibit_has_imagerotate()

{

	return function_exists('ImageRotate');

}





//exhibit_make_dir: Creates a directory based on the specified querystring path

function exhibit_make_dir()

{

	global $exc, $user_level;



	if(!$exc->permissions(array('makedir')))

	{

		die("No new directories for you.");

	}



	if($_REQUEST['mkdir'] != 'null')

	{

		if($exc->user_dirs)

		{

			$mk = ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path'].'/'.$_REQUEST['mkdir'];

		}

		else

		{

			$mk = ABSPATH.$exc->imagedir.@$_REQUEST['path'].'/'.$_REQUEST['mkdir'];

		}

		if(!is_dir($mk) && !is_file($mk))

		{	

			umask(0000);

			if($exc->use_chmod_dir != 0) 

			{

				mkdir($mk, $exc->use_chmod_dir);

			}

			else

			{

				mkdir($mk);

			}

		}

	}

}



//exhibit_make_thumbnails: Creates thumbnails for an entire directory

function exhibit_make_thumbnails($path, $remake, $fname='')

{

	global $exc;



	$path = ABSPATH.$exc->imagedir.$exc->userroot().$path;

	umask(0000);

	if($exc->use_chmod_dir != 0) 

	{

		@mkdir("{$path}/t", $exc->use_chmod_dir);

	}

	else

	{

		@mkdir("{$path}/t");

	}

	if($fname == '')

	{

		$files = exhibit_get_files($path);

		foreach($files as $f)

		{

			if($f['file'] && ($remake || !$f['thumb']) && in_array(strtolower(substr($f['name'], -4, 4)), $exc->make_thumb_filetypes))

			{

				exhibit_output_thumb($path.'/'.$f['name'], $exc->thumb_width, $exc->thumb_height, $path.'/t/'.$f['name']);

			}

		}

	}

	else

	{

		if(in_array(strtolower(substr($fname, -4, 4)), $exc->make_thumb_filetypes))

		{

			exhibit_output_thumb($path.'/'.$fname, $exc->thumb_width, $exc->thumb_height, $path.'/t/'.$fname);

		}

	}

}



//exhibit_output_thumb: Creates a thumbnail for the specified file at the specified size

function exhibit_output_thumb($file, $max_width, $max_height, $fileout)

{

	global $exc;



	$src = ImageCreateFromJPEG("$file");



	$filesize = filesize("$file");

	$org_h = imagesy($src);

	$org_w = imagesx($src);



	if(($org_w>$max_width) || ($org_h>$max_height))

	{

		if (($org_w / $org_h) < ($max_width / $max_height)) { //see if image is horizontal or vertical

			$cfg->height = $max_height;  //max thumb size

			$cfg->width  = floor ($cfg->height * $org_w / $org_h);

		} else {

			$cfg->width = $max_width;

			$cfg->height = floor ($cfg->width * $org_h / $org_w);

		}



		//$img = ImageCreate($cfg->width,$cfg->height);

		$img = imagecreatetruecolor ($cfg->width,$cfg->height);



		//ImageCopyResized ($img, $src, 0, 0, 0, 0, $cfg->width, $cfg->height, $org_w, $org_h );

		ImageCopyResampled ($img, $src, 0, 0, 0, 0, $cfg->width, $cfg->height, $org_w, $org_h );

		



		@ImageJPEG($img, "$fileout", 80); //save file with 80 quality

		ImageDestroy ($img); //free resources from the image

	}

	else

	{

		if($file != $fileout)

		{

			if(!copy($file, $fileout))

			{

				@ImageJPEG($src, "$fileout", 80); //save file with 80 quality

			}

		}

	}

	if($exc->use_chmod != 0) {

		chmod($fileout, $exc->use_chmod);

	}



	ImageDestroy ($src);



}



//exhibit_file_uploader: Takes care of all file uploading functions

function exhibit_file_uploader()

{

	global $exc, $user_level;

	

	$tpath = @$_REQUEST['path'];

	

	if(!$exc->permissions(array('upload')))

	{

		die("No uploads for you.");

	}

	

	$ulfeature = $_REQUEST['upload'];

	

	if(!is_writable(ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path']))

	{

		$ulfeature = 'nowrite';

	}



	switch($ulfeature)

	{

	case 'nowrite':

		print "<p>The directory you have specified in your configuration is not writable!</p>";

		print "<p>Please change your directory permissions so that PHP can write to this directory:</p>";

		print "<blockquote>".ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path']."</blockquote>";

		break;

	case 'form':

	

		print "<strong>Current directory: </strong>";

		if('' == @$_REQUEST['path'])

		{

			print "/";

		}

		else

		{

			print "{$_REQUEST['path']}";

		}

		print "<br />";



		print '<form class="submit" style="text-align:left;" action="';



		print "{$_SERVER['SCRIPT_NAME']}?upload=incoming&amp;path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}";



		print '" method="post" enctype="multipart/form-data" id="uploadform" name="uploadform"><div id="newelements">';

		print '<input type="file" name="ulfile[]" size="10" />';

		print '<span id="emptybreak"></span><input type="submit" name="submit" id="submit" value="Upload File(s)" />';

		print '</div>';

		print '<input type="button" onclick="addfilebox();" value="Add another file input box" />';

		print '</form>';

?>

		<script type="text/javascript"><!--

		function addfilebox()

		{

			var pardoc = window.document;

			var theInput = pardoc.createElement('input');

			theInput.setAttribute('type', 'file');

			theInput.setAttribute('name', 'ulfile[]');

			theInput.setAttribute('size', 10);

			pardoc.getElementById('newelements').insertBefore(theInput, pardoc.getElementById('emptybreak'));

		}

		//--></script>

<?php

		break;

	case 'incoming':

		for($z=0;$z<count($_FILES['ulfile']['name']);$z++)

		{

			if($_FILES['ulfile']['error'][$z] != 0)

			{

				print "<p>Sorry, there was an error uploading '{$_FILES['ulfile']['name'][$z]}'.</p>\n";

				continue;

			}

		

			$pathtofile = ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path'].'/'.$_FILES['ulfile']['name'][$z];

			$ext = strtolower(substr($_FILES['ulfile']['name'][$z], strrpos($_FILES['ulfile']['name'][$z], '.')));

			if(in_array($ext, $exc->valid_filetypes) || in_array($ext, $exc->nothumb_filetypes))

			{



				@$moved = move_uploaded_file($_FILES['ulfile']['tmp_name'][$z], $pathtofile);

				if(!$moved)

				{

					$moved = copy($_FILES['ulfile']['tmp_name'][$z], $pathtofile);

				}

				if(!$moved)

				{

					print "<p>Sorry.  Couldn't upload your file, \"{$pathtofile}\".</p>";

				}

				else

				{

					if($exc->use_chmod != 0)

					{

						chmod($pathtofile, $exc->use_chmod);

					}



					exhibit_make_thumbnails(@$_REQUEST['path'], false, $_FILES['ulfile']['name'][$z]);

					print "<p style=\"font-size:xx-small;\">{$_FILES['ulfile']['name'][$z]} <strong>uploaded successfully</strong>, " . round(($_FILES['ulfile']['size'][$z])/1024) ."k bytes"; 



					if($exc->full_max_width != 0)

					{

						exhibit_output_thumb($pathtofile, $exc->full_max_width, $exc->full_max_height, $pathtofile);

						clearstatcache();

						print "and <strong>downsampled</strong> to {$exc->full_max_width}x{$exc->full_max_height}, " . round((filesize($pathtofile))/1024) ."k bytes";

					}

					print ".</p>";

				}

			}

			else if($ext == '.zip')

			{

				if(function_exists('zip_open'))

				{

					$zip = zip_open($_FILES['ulfile']['tmp_name'][$z]);

					if ($zip) 

					{

						while ($zip_entry = zip_read($zip)) 

						{

							echo "<p style=\"font-size:xx-small;\">Unzipping '" . zip_entry_name($zip_entry) . "', \n";

							if (zip_entry_open($zip, $zip_entry, "r")) 

							{

								$complete_name = ABSPATH.$exc->imagedir.$exc->userroot().@$_REQUEST['path'].'/'.basename(zip_entry_name($zip_entry));



								$fd = fopen($complete_name, 'w');

								fwrite($fd, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));

								fclose($fd);

								

								if(is_file($complete_name))

								{

									if($exc->use_chmod != 0)

									{

										chmod($complete_name, $exc->use_chmod);

									}

									exhibit_make_thumbnails(@$_REQUEST['path'], false, basename($complete_name));

									print " <strong>successfully</strong>, " . round((zip_entry_filesize($zip_entry))/1024) ."k bytes"; 



									if($exc->full_max_width != 0)

									{

										exhibit_output_thumb($complete_name, $exc->full_max_width, $exc->full_max_height, $complete_name);

										clearstatcache();

										print "and <strong>downsampled</strong> to {$exc->full_max_width}x{$exc->full_max_height}, " . round((filesize($complete_name))/1024) ."k bytes";

									}

								}

								else

								{

									echo "failure!";

								}

								zip_entry_close($zip_entry);

							}

							echo "</p>\n";

						}



						zip_close($zip);



					}

					else

					{

						print "<p>Sorry, couldn't open the zip file you uploaded.</p>\n";

					}

				}

				else

				{

					print "<p>Sorry, your server is not configured for zip file uploads.</p>\n";

				}

			}

			else

			{

				print "<table>".exhibit_dir_features($tpath)."</table>";

				print "<p>Sorry, the extension of the uploaded file ({$ext}) is not one accepted by Exhibit.</p>";

				print "<p>Try one of these:</p><ul>\n";

				foreach($exc->valid_filetypes as $ext)

				{

					print "<li>{$ext}</li>\n";

				}

				foreach($exc->nothumb_filetypes as $ext)

				{

					print "<li>{$ext}</li>\n";

				}

				print "</ul>";

			}

		}

		exhibit_file_picker();

		//print_r($_FILES['ulfile']);

		break;

	}

}



// exhibit_add_image_path: Adds images from the selected path to the Exhibit table for the selected post

function exhibit_add_image_path($path, $id) {

	global $wpdb, $exc;

	

	$default_comment = addslashes($exc->default_comment);



	if('/' == $path)

	{

		$path = '';

	}	

	$urlpath = $exc->imagedir . $exc->userroot() . $path;

	$nupath = ABSPATH . $exc->imagedir . $exc->userroot() . $path;

	if ($handle = opendir($nupath)) 

	{

		print "<script type=\"text/javascript\"><!--\n";

		$maxorder = $wpdb->get_var("SELECT MAX(picorder) FROM {$exc->tableexhibit} WHERE post_ID = {$id}");

		while (false !== ($file = readdir($handle)))

		{

			$ftype = strtolower(substr($nupath.'/'.$file, -4, 4));

			if (

				in_array($ftype, $exc->valid_filetypes) &&

				is_file($nupath.'/'.$file) && 

				(

					is_file($nupath.'/t/'.$file) ||

					in_array($ftype, $exc->nothumb_filetypes) ||

					is_file($nupath.'/thumb-'.$file)

				)

			) 

			{

				if(is_file($nupath.'/t/'.$file))

				{

					$thumbfile = "{$urlpath}/t/{$file}";

				}

				else if(is_file($nupath.'/thumb-'.$file))

				{

					$thumbfile = "{$urlpath}/thumb-{$file}";

				}

				else

				{

					$thumbfile = $exc->nothumb_file;

				}

				if($exc->no_duplicates)

				{

					$imgct = $wpdb->get_var("SELECT count(ID) as imgct FROM {$exc->tableexhibit} WHERE photo = '".addslashes("{$urlpath}/{$file}")."' and post_ID = {$id};");

					$usefile = (0 == $imgct);

				}

				else

				{

					$usefile = true;

				}

				if($usefile)

				{

					if(('' != $exc->watermark_png) && (0 == $wpdb->get_var("SELECT count(ID) AS ttl FROM {$exc->tableexhibit} WHERE photo = '".addslashes("{$urlpath}/{$file}")."';")))

					{

						exhibit_watermark($nupath.'/'.$file);

					}

					$maxorder ++;

					$wpdb->query("INSERT INTO {$exc->tableexhibit} (post_ID, photo, thumb, caption, picorder) values("

						."'{$id}', "

						."'".addslashes("{$urlpath}/{$file}")."', "

						."'".addslashes("{$thumbfile}")."', "

						."'{$default_comment}', "

						."{$maxorder});");

					$lastid = $wpdb->get_var("SELECT LAST_INSERT_ID();");

					print "addExhibitImage('".addslashes("{$thumbfile}")."','".addslashes("{$urlpath}/{$file}")."',{$lastid},";

					if($exc->preview_by_default)

					{

						print 'true';

					}

					else

					{

						print 'false';

					}

					print ");\n";

				}

			}

		}

		print "//--></script>\n";

		closedir($handle);

	}

}



// exhibit_add_files: Adds individual semicolon-separated images 

function exhibit_add_files($files, $id) 

{

	global $wpdb, $exc;

	

	$default_comment = addslashes($exc->default_comment);



	if('/' == $path)

	{

		$path = '';

	}

	

	$files = explode(';', $files.';');

	

	print "<script type=\"text/javascript\"><!--\n";

	$maxorder = $wpdb->get_var("SELECT MAX(picorder) FROM {$exc->tableexhibit} WHERE post_ID = {$id}");

	foreach($files as $path)

	{

		if($path != '')

		{			

			$urlpath = $exc->imagedir . $exc->userroot() . dirname($path);

			$nupath = dirname(ABSPATH . $exc->imagedir . $exc->userroot() . $path);

			$file = basename(ABSPATH . $exc->imagedir . $exc->userroot() . $path);



			$ftype = strtolower(substr($nupath.'/'.$file, -4, 4));

			if (

				in_array($ftype, $exc->valid_filetypes) &&

				is_file($nupath.'/'.$file) && 

				(

					is_file($nupath.'/t/'.$file) ||

					in_array($ftype, $exc->nothumb_filetypes) ||

					is_file($nupath.'/thumb-'.$file)

				)

			) 

			{

				if(is_file($nupath.'/t/'.$file))

				{

					$thumbfile = "{$urlpath}/t/{$file}";

				}

				else if(is_file($nupath.'/thumb-'.$file))

				{

					$thumbfile = "{$urlpath}/thumb-{$file}";

				}

				else

				{

					$thumbfile = $exc->nothumb_file;

				}

				if($exc->no_duplicates)

				{

					$imgct = $wpdb->get_var("SELECT count(ID) as imgct FROM {$exc->tableexhibit} WHERE photo = '".addslashes("{$urlpath}/{$file}")."' and post_ID = {$id};");

					$usefile = (0 == $imgct);

				}

				else

				{

					$usefile = true;

				}

				if($usefile)

				{

					$photo = str_replace('\/', '/', addslashes("{$urlpath}/{$file}"));

					$thumbfile = str_replace('\/', '/', addslashes($thumbfile));

					if(('' != $exc->watermark_png) && (0 == $wpdb->get_var("SELECT count(ID) AS ttl FROM {$exc->tableexhibit} WHERE photo = '{$photo}';")))

					{

						exhibit_watermark($nupath.'/'.$file);

					}

					$maxorder ++;

					$wpdb->query("INSERT INTO {$exc->tableexhibit} (post_ID, photo, thumb, caption, picorder) values("

						."'{$id}', "

						."'{$photo}', "

						."'{$thumbfile}', "

						."'{$default_comment}', "

						."{$maxorder});");

					$lastid = $wpdb->get_var("SELECT LAST_INSERT_ID();");

					print "addExhibitImage('{$thumbfile}','{$photo}',{$lastid},";

					if($exc->preview_by_default)

					{

						print 'true';

					}

					else

					{

						print 'false';

					}

					print ");\n";

				}

				else

				{

					print "alert('".basename($file)." is already in this post.');\n";

				}

			}

		}

	}

	print "//--></script>\n";

}



function exhibit_dir_features($tpath)

{

	global $exc, $user_level;

	

	$outtemp = '';

	

	if(($tpath != '') || ($exc->permissions(array('makedir', 'upload')))) $outtemp .= "<tr>\n<td colspan=\"4\" style=\"font-size:xx-small;white-space:nowrap;\">\n";

	$oneup = preg_replace('|\\\\|', '/', dirname($tpath));

	if($oneup == '/') $oneup = '';

	if($tpath != '')

	{

		$outtemp .= "<a href=\"{$_SERVER['SCRIPT_NAME']}?path=".urlencode("{$oneup}")."&amp;postid={$_REQUEST['postid']}\"><em>.. (parent path)</em>\n";

		$outtemp .= "&nbsp;<img src=\"exhibitimg/exhibit_up_one.gif\" border=\"0\" alt=\"[up directory]\" title=\"Click to go up one directory\" /></a>\n";

	}

	

	if($exc->permissions(array('makedir')))

	{

		$outtemp .= "&nbsp;<a href=\"javascript:location.href='{$_SERVER['SCRIPT_NAME']}?mkdir='+escape(prompt('Directory Name?'))+'&amp;path=". urlencode($tpath). "&amp;postid={$_REQUEST['postid']}';\"><em>New directory</em> &nbsp;";

		$outtemp .= "<img src=\"exhibitimg/exhibit_new_folder.gif\" border=\"0\" alt=\"[new directory]\" title=\"Click to create a new directory\" /></a>\n";

	}

	if($exc->permissions(array('upload')))

	{	

		$outtemp .= "<a style=\"margin-left:5px;\" href=\"{$_SERVER['SCRIPT_NAME']}?upload=form&amp;path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\"><em>Upload New File</em> &nbsp;";

		$outtemp .= "<img src=\"exhibitimg/exhibit_new_img.gif\" border=\"0\" alt=\"[upload file]\" title=\"Click to upload a file\" /></a>\n";

	}

	if(($tpath != '') || ($exc->permissions(array('makedir', 'upload')))) $outtemp .= "</td></tr>\n";





	if(($tpath != '') || ($exc->permissions(array('upload')))) $outtemp .= "<tr>\n<td colspan=\"4\" style=\"font-size:xx-small;white-space:nowrap;\">\n";

	if($exc->permissions(array('upload')))

	{	

		$outtemp .= "<a style=\"\" href=\"{$_SERVER['SCRIPT_NAME']}?thumbs=fresh&amp;path=".urlencode("{$tpath}")."&amp;postid={$_REQUEST['postid']}\"><em>Rebuild Thumbnails</em> &nbsp;";

		$outtemp .= "<img src=\"exhibitimg/exhibit_ref_thumb.gif\" border=\"0\" alt=\"[refresh thumbnails]\" title=\"Click to rebuild all thumbnails of images in this directory\" /></a>\n";

	}

	if(($tpath != '') || ($exc->permissions(array('makedir', 'upload')))) $outtemp .= "</td></tr>\n";

	

	return $outtemp;

}



function exhibit_del_files($files)

{

	global $wpdb, $exc;

	

	$files = explode(';', $files.';');

	

	print "<script type=\"text/javascript\"><!--\n";

	foreach($files as $path)

	{

		if($path != '')

		{			

			$urlpath = $exc->imagedir . $exc->userroot() . dirname($path);

			$nupath = dirname(ABSPATH . $exc->imagedir . $exc->userroot() . $path);

			$file = basename(ABSPATH . $exc->imagedir . $exc->userroot() . $path);



			$ftype = strtolower(substr($file, -4, 4));

			if (

				in_array($ftype, $exc->valid_filetypes) &&

				is_file($nupath.'/'.$file)

			) 

			{

				if(is_file($nupath.'/t/'.$file))

				{

					$thumbfile = "{$nupath}/t/{$file}";

					$thumburl = "{$urlpath}/t/{$file}";

				}

				else if(is_file($nupath.'/thumb-'.$file))

				{

					$thumbfile = "{$nupath}/thumb-{$file}";

					$thumburl = "{$urlpath}/thumb-{$file}";

				}

				else

				{

					$thumbfile = '';

					$thumburl = '';

				}



				$photo = str_replace('\/', '/', $nupath.'/'.$file);

				$thumbfile = str_replace('\/', '/', $thumbfile);

				if(unlink($photo))

				{

					if($thumbfile != '') 

					{

						unlink($thumbfile);

					}

					$qry = "SELECT ID FROM {$exc->tableexhibit} WHERE photo = '".$urlpath.'/'.$file."';";

					$photoids = $wpdb->get_col($qry);

					

					$qry = "DELETE FROM {$exc->tableexhibit} WHERE photo = '".$urlpath.'/'.$file."';";

					//echo "//$qry";

					$wpdb->query($qry);

					

					foreach($photoids as $pid)

					{

						print "delExhibitImage('{$pid}');\n";

					}

				}

				else

				{

					echo "alert(\"Could not delete '".addslashes($photo)."'.\");";

				}

			}

		}

	}

	print "//--></script>\n";

}



function exhibit_deldir($dir)

{

  $handle = opendir($dir);

  while (false!==($FolderOrFile = readdir($handle)))

  {

     if($FolderOrFile != "." && $FolderOrFile != "..")

     { 

       if(is_dir("$dir/$FolderOrFile"))

       { exhibit_deldir("$dir/$FolderOrFile"); }  // recursive

       else

       { unlink("$dir/$FolderOrFile"); }

     } 

  }

  closedir($handle);

  if(rmdir($dir))

  { $success = true; }

  return $success; 

}



function exhibit_del_path($path)

{

	global $wpdb, $exc, $user_level;

	

	if('/' == $path)

	{

		$path = '';

	}	

	$urlpath = $exc->imagedir . $exc->userroot() . $path;

	$nupath = ABSPATH . $exc->imagedir . $exc->userroot() . $path;



	if(is_dir($nupath) && ($exc->permissions(array('delete'))))

	{

		if(exhibit_deldir($nupath))

		{

			print "<p>Directory deleted successfully.</p>\n<script type=\"text/javascript\"><!--";

			$qry = "SELECT ID FROM {$exc->tableexhibit} WHERE photo REGEXP '^{$urlpath}';";

			$photoids = $wpdb->get_col($qry);



			$qry = "DELETE FROM {$exc->tableexhibit} WHERE photo REGEXP '^{$urlpath}';";

			//echo "//$qry\n";

			$wpdb->query($qry);



			if(count($photoids) > 0)

			{

				foreach($photoids as $pid)

				{

					print "delExhibitImage('{$pid}');\n";				

				}

			}

			print "//--></script>";

		}

		else

		{

			print "<p>Directory deletion failed!</p>";

		}

	}

}



//exhibit_rotate: Loads an image, rotates by the specified angle, and saves it

function exhibit_rotate ( $pFile, $pAngle, $pDestFile ) {

   // remove all useless 360 degrees

   $pAngle = $pAngle % 360;



   // create an image ressource from $pFile

   $ImgIn = imagecreatefromjpeg ( $pFile );



   // case of flip

   if ( $pAngle == 180 ) {

       $ImgOut = ImageRotate ( $ImgIn, $pAngle, 180 );

   }

   else {

       // other cases (90 or 270)

       $x = imagesx ( $ImgIn );

       $y = imagesy ( $ImgIn );

       $MaxXY = max ($x, $y);



       // prepare intermediate picture, full size in order to loose nothing

       $SquareImg = imagecreatetruecolor($MaxXY, $MaxXY);

       imagecopy($SquareImg, $ImgIn, 0, 0, 0, 0, $x, $y);

       $SquareImg = ImageRotate ( $SquareImg, $pAngle, 0 );



       if ( $pAngle == 90 ) {

           // we are in 90 rotation

           $ImgOut = imagecreatetruecolor($y, $x);

           imagecopy ( $ImgOut, $SquareImg, 0, 0, 0, $MaxXY - $x, $y, $x );

       }

       elseif ( $pAngle == 270 ) {

           // we are in 270 rotation

           $ImgOut = imagecreatetruecolor($y, $x);

           imagecopy ( $ImgOut, $SquareImg, 0, 0, $MaxXY-$y, 0, $y, $x );

       }

   }

   if(is_file($pDestFile))

   {

   	unlink($pDestFile);

   }

   ImageJPEG ( $ImgOut, $pDestFile );

}





function exhibit_do_rotate($path, $file, $direction)

{

	global $exc;



	$nupath = ABSPATH . $exc->imagedir . $exc->userroot() . $path;



	if(is_file($nupath.'/t/'.$file))

	{

		$thumbfile = "{$nupath}/t/{$file}";

	}

	else if(is_file($nupath.'/thumb-'.$file))

	{

		$thumbfile = "{$nupath}/thumb-{$file}";

	}

	else

	{

		$thumbfile = '';

	}

	

	$fullfile = "{$nupath}/{$file}";

	exhibit_rotate($fullfile, $direction, $fullfile);

	if($thumbfile != '')

	{

		exhibit_rotate($thumbfile, $direction, $thumbfile);

	}

}



function exhibit_watermark($fname) 

{

	global $exc;

	

	if(exhibit_has_gd())

	{

		$size = getimagesize($fname);

		$sizew = $size[0];

		$sizeh = $size[1];



		$oimage = imageCreateFromJPEG($fname);

		$watermark_file = dirname(__FILE__) . '/' . $exc->watermark_png;

		$mark = imageCreateFromPNG($watermark_file);

		$mark_width=imageSX($mark);

		$mark_height=imageSY($mark);

		$xoff = array(0 => ($sizew - $mark_width - 5), 1 => 5);

		$yoff = array(0 => ($sizeh - $mark_height - 5), 2 => 5);

		$x = $xoff[$exc->watermark_position & 1];

		$y = $yoff[$exc->watermark_position & 2];

		imageCopyMerge($oimage,$mark,$x,$y,0,0,$mark_width,$mark_height,60);



		imagejpeg($oimage, $fname);

		imagedestroy($oimage);

	}

}



function exhibit_remove_image($remove)

{

	global $exc, $wpdb;

	$wpdb->query("DELETE FROM {$exc->tableexhibit} WHERE ID = {$remove} LIMIT 1;");

	print "<script type=\"text/javascript\"><!--\n";

	print "delExhibitImage('{$remove}');\n";

	print "//--></script>\n";

}



function exhibit_preview_image($preview, $state)

{

	global $exc, $wpdb;

	$value = intval((($state != 'false')? 1 : 0) || ($exc->multi_preview ? 0 : 1));

	if(!$exc->multi_preview)

	{

		$wpdb->query("UPDATE {$exc->tableexhibit} SET preview = 0 WHERE post_ID = {$_REQUEST['postid']};");

	}

	$wpdb->query("UPDATE {$exc->tableexhibit} SET preview = {$value} WHERE ID = {$preview};");

	print "<!-- preview set for id $preview = $value  State: ".(($state != 'false') ? 1 : 0)."  Multipreview: ".($exc->multi_preview ? 0 : 1)." -->";

}



function exhibit_move_image($move, $direction)

{

	global $exc, $wpdb;

	

	$oldorder = $wpdb->get_var("SELECT picorder FROM {$exc->tableexhibit} WHERE ID = {$move}");

	if($direction > 0)

	{

		$swap = $wpdb->get_row("SELECT ID, picorder FROM {$exc->tableexhibit} WHERE picorder < {$oldorder} AND Post_ID = {$_REQUEST['postid']} ORDER BY picorder DESC LIMIT 1");

	}

	else

	{

		$swap = $wpdb->get_row("SELECT ID, picorder FROM {$exc->tableexhibit} WHERE picorder > {$oldorder} AND Post_ID = {$_REQUEST['postid']} ORDER BY picorder ASC LIMIT 1");

	}

	if($swap == false)

	{

		print "<script type=\"text/javascript\"><!--\n";

		print "alert('That image cannot be moved any farther in that direction.');";

		print "//--></script>\n";

	}

	else

	{

		$wpdb->query("UPDATE {$exc->tableexhibit} SET picorder = {$oldorder} WHERE ID = {$swap->ID}");

		$wpdb->query("UPDATE {$exc->tableexhibit} SET picorder = {$swap->picorder} WHERE ID = {$move}");

	

		print "<script type=\"text/javascript\"><!--\n";

		foreach($wpdb->get_col("SELECT ID FROM {$exc->tableexhibit} WHERE Post_ID = {$_REQUEST['postid']} ORDER BY picorder;") as $image)

		{

			print "reposExhibitImage({$image});\n";

		}

		print "//--></script>\n";

	}

}



function exhibit_nav_pic($navid)

{

	global $exc, $wpdb;

	$navpic = $wpdb->get_row("SELECT * FROM {$exc->tableexhibit} WHERE ID={$navid}");

	$outpic = "<img onclick=\"reSizeToImage();\" src=\"".get_settings('siteurl').'/'.$navpic->photo."\" id=\"raw\" alt=\"{$navpic->caption}\" title=\"{$navpic->caption}\" />\n";

	

	$pictures = $wpdb->get_results("SELECT * FROM {$exc->tableexhibit} WHERE Post_ID={$navpic->post_ID} ORDER BY picorder");

	

	$outstrip = '';

	$outct = 0;

	foreach($pictures as $picture)

	{

		$outct++;

		$outstrip .= "<a style=\"margin-left:3px;\" href=\"#\" onclick=\"setpic('".addslashes($picture->photo)."', '".addslashes($picture->caption)."');\">{$outct}</a>\n";

	}

	$outstrip = "<div style=\"text-align:center;font-size:xx-small;\">{$outstrip}</div>";

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 FINAL//EN">

<html>

<head>

<title><?php echo $navpic->caption; ?></title>

<script type="text/javascript"><!--

function setpic(src, caption)

{

	var img = document.getElementById('raw');

	img.setAttribute('src', '<?php echo get_settings('siteurl'); ?>/' + src);

	img.setAttribute('alt', caption);

	img.setAttribute('title', caption);

	setTimeout("reSizeToImage()", 1000);

	document.title=caption;

}

function reSizeToImage(){

	if (navigator.appName.indexOf("Microsoft")==-1)

	{

		window.innerWidth=document.images["raw"].width;

		window.innerHeight=document.images["raw"].height + 30;

	}else if(window.opera){

		window.resizeTo(100,100);

		width=130-(document.body.clientWidth-document.images[0].width);

		height=100-(document.body.clientHeight-document.images[0].height-30);

		window.resizeTo(width,height);

	}else{

		window.resizeTo(100,100);

		width=100-(document.body.clientWidth-document.images[0].width);

		height=100-(document.body.clientHeight-document.images[0].height-30);

		window.resizeTo(width,height);

	}

}



//--></script>

</head>



<body bgcolor="#000000" text="#ffffff" link="#ff0000" vlink="#800000" alink="#ff00ff" onload="reSizeToImage();" style="margin:0px;">

<?php echo $outpic; ?>

<?php echo $outstrip; ?>

</body>

</html>



<?php

}



?>