<?php
/*
Plugin Name: Exhibit
Plugin URI: http://www.asymptomatic.net/wp-hacks
Description: A photo gallery plugin for WordPress posts.  This code is licensed under the <a href="http://www.opensource.org/licenses/mit-license.php">MIT License</a> and is Copyright 2004 Owen Winkler.
Version: 1.1b
Author: Owen Winkler
Author URI: http://www.asymptomatic.net
*/ 

/*
Exhibit - A photo gallery plugin for WordPress
Copyright (c) 2004 Owen Winkler

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the
Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to
do so, subject to the following conditions:

The above copyright notice and this permission notice shall
be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


/*****  DON'T MODIFY BELOW HERE *****/
/*  

    All of the settings here should be set using the external
    configuration file, exhibit10.cfg.

*/


if(!class_exists('ex_config')){ 
class ex_config {  

var $exhibit_db_table = 'photos';	
var $imagedir = 'images';
var $thumbnail_popup = true;
var $embedded_image = '';
var $suppress_content = false;
var $preview_prompt = 'View more...';
var $edit_thumbnail_width=60;
var $thumb_width = 160;
var $thumb_height = 160;
var $default_comment = '&copy;2004';
var $popup_page = '';
var $full_image_display = '<img class="ex_fullsize" src="IMGSRC" alt="IMGCAPTION"/>';
var $valid_filetypes = array('.jpg', '.jpeg', '.wmv', '.asf');
var $make_thumb_filetypes = array('.jpg', '.jpeg');
var $nothumb_filetypes = array('.wmv', '.asf');
var $nothumb_file = '';
var $multi_preview = true;
var $thumbs_at_top = false;
var $preview_at_top = true;
var $pop_script_always = true;
var $previews_link = true;
var $no_duplicates = true;
var $no_pic_use_preview = true;
var $use_chmod = 0;
var $paginate_thumbs = 0;
var $on_last_page = false;
var $full_max_width = 0;
var $full_max_height = 0;
var $preview_like_single = false;
var $use_permalinks = true;
var $preview_class = 'ex_thumb_preview';
var $clear_post = false;
var $user_dirs = false;
var $display_captions = true;
var $break_every_preview = 0;
var $break_every_thumb = 0;
var $thumb_titles = false;
var $preview_titles = false;
var $preview_by_default = false;
var $on_first_page=false;
var $watermark_png='';
var $watermark_position=0;
var $insert_css=true;

/*
If for some reason you need to dynamically set one of the above
settings, you should do it in the constructor function, ex_config(),
just below.  You could use this, for example, to change the 
copyright date dynamically based on the current year.  
*/

var $editoptions = array();
var $config_loaded = false;

	function ex_config()
	{
		global $table_prefix;
		
		//Add new stuff here, if required


/*****  REALLY DON'T MODIFY ANYTHING BELOW HERE - NO, REALLY... *****/

		
		/* This section looks for and loads a default config file */
		$cfgfile = dirname(__FILE__).'/exhibitimg/exhibit10.cfg';
		if(is_file($cfgfile))
		{
			$this->load_config_file($cfgfile);
		}

		$this->tableexhibit = $table_prefix . $this->exhibit_db_table;
	}
	
	function load_config_file($cfgfile)
	{
		$fp = fopen($cfgfile, "r");
		$temp = fread ($fp, filesize ($cfgfile));
		fclose ($fp);
		$cfglines = explode ("\n", $temp);
		$objvars = (array)$this;
		foreach($cfglines as $line)
		{
			if((trim($line) != '') && ($line[0] != '#'))
			{
				if(preg_match('|([^:].*):(.*)|', $line, $matches))
				{
					$this->editoptions[$matches[1]] = $matches[2];
				}
				else
				{
					$ex = '$this->'.$line.';';
					eval($ex);
				}
			}
		}
		$this->config_loaded = true;
	}
	
	function thispage()
	{
		return get_settings('siteurl') . '/wp-content/plugins/' . basename(__FILE__);
	}
	
	function userroot()
	{
		global $user_nickname;
		//global $userdata->user_level;
		
		if(($this->user_dirs) && ($userdata->user_level < $this->root_image_access))
		{
			return '/'.sanitize_title($user_nickname);
		}
		else
		{
			return '';
		}
	}
	
	function permissions($permarray)
	{
		//global $userdata->user_level;
		
		return ($userdata->user_level >= get_settings('fileupload_minlevel'));
	}
			
}}  // Yes these braces belongs here...


if(preg_match('|'.basename(__FILE__).'|', $_SERVER['SCRIPT_NAME']))
{
	// File was executed solo
	$incfile = 'wp-config.php';
	$c=0;
	while(!is_file($incfile))
	{
		$incfile = '../' . $incfile;
		$c++;
		if($c==30) {
			echo "Could not find wp-config.php.";
			exit;
		}
	}
	require_once($incfile);
	
	$exc = new ex_config();		

	require_once('exhibitimg/exhibit10f.php');
}
else
{
	// File was executed in admin or plugin	
	$exc = new ex_config();		

	global $userdata;
$incfile = 'wp-includes/pluggable.php'; //start of kinkistyle's fix
$c=0;
while(!is_file($incfile))
{
$incfile = '../' . $incfile;
$c++;
if($c==30) {
echo "Could not find pluggable.php";
exit;
}
}
require_once($incfile); // End of Kinkistyle's fix	
get_currentuserinfo();
	if($userdata->user_level > 4) require_once('exhibitimg/exhibit10i.php');
	require_once('exhibitimg/exhibit10p.php');
}


?>
