
<?php

/**
 * @package EwoApps
 */
/*
Plugin Name: EwoApps
Plugin URI:  https://it2020.org/ewoapps-wordpress-plugin.html
Description: The EwoApps platform helps develop Line of Business (LOB) modules. Such modules can be used individually or in CRM/ERP applications.
Version: 1.0
Author: it2020.org
Author URI: https://it2020.org
License: GPLv2 or later
Text Domain: CRM/ERP, WebBuilder, ApplicationBuilder */

// Include mfp-functions.php, use require_once to stop the script if mfp-functions.php is not found
require_once plugin_dir_path(__FILE__) . 'ewo-functions.php';

/**
 * Activate the plugin.
 */
function ewoapps_activate() { 
  global $wpdb;

  $query = "  CREATE TABLE IF NOT EXISTS `ewoapps` (
    `id` varchar(50) NOT NULL,
    `modulename` varchar(255) NOT NULL,
    `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `tablename` varchar(50) NOT NULL,
    `content` text NOT NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
  $wpdb->get_results($query);

  $query = "CREATE TABLE IF NOT EXISTS `ewotables` (
    `id` varchar(50) NOT NULL,
    `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `tablename` varchar(255) NOT NULL,
    PRIMARY KEY (`tablename`)
  ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
  $wpdb->get_results($query);
  
  // Clear the permalinks after the post type has been registered.
  flush_rewrite_rules(); 
}
register_activation_hook( __FILE__, 'ewoapps_activate' );


/**
* Deactivation hook.
*/
function ewoapps_deactivate() {
  global $wpdb;

  $query = "DROP TABLE IF EXISTS `ewoapps`;";
  $wpdb->get_results($query);

  $query = "DROP TABLE IF EXISTS `ewotables`;";
  $wpdb->get_results($query);

  // Clear the permalinks to remove our post type's rules from the database.
  flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'ewoapps_deactivate' );

function ewoapps_http_get( WP_REST_Request $request ) {
    global $wpdb;

    $user = wp_get_current_user();
    
    $base = array(
      'layouts', 'layoutsmodule', 'ewomodules', 'layoutsform'
    );

    $entity = $request['entity'];

    if (in_array($entity, $base))
    $query = "SELECT * FROM `ewoapps` WHERE tablename = '$entity'";
    else if ($entity == 'ewotables')
    $query = "SELECT * FROM `ewotables`";
    else
    $query = "SELECT * FROM `ewoapps_$entity`";

    $list = $wpdb->get_results($query);

    return $list;
}
add_action( 'rest_api_init', function () {
  register_rest_route( 'ewoapps', '/(?P<entity>[A-Za-z0-9]+)', array(
    'methods' => 'GET',
    'callback' => 'ewoapps_http_get'
  ));
});

function ewoapps_http_post( WP_REST_Request $request ) {
    global $wpdb;

    $base = array(
      'layouts', 'layoutsmodule', 'ewomodules', 'layoutsform'
    );

    $entity = $request['entity'];

    $content = '';
    if ($request['content'])
    $content = $request['content'];

    $modulename = '';
    if ($request['modulename'])
    $modulename = $request['modulename'];

    $id = uniqid("",true);
    if ($request['id'])
    $id = $request['id'];

   
    //delete
    if ($request['delete']){

      if (in_array($entity, $base))
        $query = "DELETE FROM `ewoapps` WHERE id='$id'";
      else  
        $query = "DELETE FROM `ewoapps_$entity` WHERE id='$id'";

        $list = $wpdb->get_results($query);
        return $list;
    }

    if ($entity == 'ewotables'){

      $query = "INSERT INTO ewotables (id, tablename) VALUES ('$id', '$modulename')";
      $list = $wpdb->get_results($query);
      
      return $list;
    }

    //insert,update
    if (in_array($entity, $base)){
      if ($request['state'])
      $query = "UPDATE ewoapps SET content='$content' WHERE id='$id'";
      else
      $query = "INSERT INTO ewoapps (id, modulename, tablename, content) VALUES ('$id', '$modulename', '$entity', '$content')";
    }
    // else{
    //   if ($request['id'])
    //   $query = "UPDATE ewoappsdata SET content='$content' WHERE id='$id'";
    //   else
    //   $query = "INSERT INTO ewoappsdata (id, tablename, content) VALUES ('$id', '$entity', '$content')";
    // }
    else{

      $entity = 'ewoapps_'.$entity;

      if ($request['content']){
        $content = base64_decode($request['content']);
        $content = json_decode($content);

        $fields='';
        foreach($content as $key => $value){
          if ($fields === '')
            $fields = $key;
          else
            $fields = $fields.','.$key;
          }

        //verify fields
        $arr_fields = explode(",", $fields);  
        foreach ($arr_fields as &$value) {
          $row = $wpdb->get_results(  "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS
          WHERE table_name = '$entity' AND column_name = '$value'"  );
          
          if(empty($row)){
             $wpdb->query("ALTER TABLE $entity ADD $value VARCHAR(255)");
          }
        }
  
        if ($request['state']){
         
          $str_sql ='';
          foreach($content as $key => $value){

            if ($key == 'id')
            continue;

            if ($str_sql === '')
              $str_sql = "$key='$value'";
            else
              $str_sql = $str_sql.','."$key='$value'";
          }

          $query = "UPDATE $entity SET $str_sql WHERE id='$id'";
        }
        else{

          $str_sql1 =''; $str_sql2 ='';
          foreach($content as $key => $value){

            if ($str_sql1 === '')
              $str_sql1 = "$key";
            else
              $str_sql1 = $str_sql1.','."$key";

            if ($str_sql2 === '')
              $str_sql2 = "'$value'";
            else
              $str_sql2 = $str_sql2.','."'$value'";
          }

          $query = "INSERT INTO $entity ($str_sql1) VALUES ($str_sql2)";
        }
      }
    }

    //return $query;
    $list = $wpdb->get_results($query);

    return $list;
}
add_action( 'rest_api_init', function () {
  register_rest_route( 'ewoapps', '/(?P<entity>[A-Za-z0-9]+)', array(
    'methods' => 'POST',
    'callback' => 'ewoapps_http_post'
  ) );
} );

function ewoapps_http_post_fields( WP_REST_Request $request ) {
  global $wpdb;

  if ($request['table']){
    $table = 'ewoapps_'.$request['table'];
    $create_table = " CREATE TABLE IF NOT EXISTS `$table` ( 
      `id` varchar(50) NOT NULL,
      PRIMARY KEY (`id`)
      ) ENGINE=InnoDB DEFAULT CHARSET=latin1;"; 

    $wpdb->get_results($create_table);

    if ($request['fields']){
      $fields = $request['fields'];
      $arr_fields = explode(",", $fields);
  
      foreach ($arr_fields as &$value) {
        $row = $wpdb->get_results(  "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = '$table' AND column_name = '$value'"  );
        
        if(empty($row)){
           $wpdb->query("ALTER TABLE $table ADD $value VARCHAR(255)");
        }
      }
  
    }

  }

  return 'ok';
}
add_action( 'rest_api_init', function () {
  register_rest_route( 'ewoappsfields', '/fields', array(
    'methods' => 'POST',
    'callback' => 'ewoapps_http_post_fields'
  ) );
} );


function ewoapps_http_post_test( WP_REST_Request $request ) {
  global $wpdb;

  return $request['id'];
}
add_action( 'rest_api_init', function () {
  register_rest_route( 'ewoapps', '/(?P<id>[A-Za-z0-9]+)', array(
    'methods' => 'POST',
    'callback' => 'ewoapps_http_post_test'
  ) );
} );

