<?php
/*
 * Add my new menu to the Admin Control Panel
 */
 
// Hook the 'admin_menu' action hook, run the function named 'mfp_Add_My_Admin_Link()'
add_action( 'admin_menu', 'ewoapps_admin_link' );
 
// Add a new top level menu link to the ACP
function ewoapps_admin_link()
{
      add_menu_page(
        'Ewo Applications', // Title of the page
        'EwoApps', // Text to show on the menu link
        'manage_options', // Capability requirement to see the link
        plugin_dir_path(__FILE__).'ewo-admin.php' // The 'slug' - file to display when clicking the link
    );
}

add_shortcode('ewoapps', 'ewoapps_shortcode');
function ewoapps_shortcode($atts = []) {
    // do something to $content
    // always return

    $moduleid = $atts['id'];

    if ($moduleid === '')
    return '<span style="color: lightcoral;">Ewoapps error:not found parameter!</span>';

    $path = plugin_dir_url( __FILE__) ;

    wp_enqueue_style( 'ewoapps_all', 'https://use.fontawesome.com/releases/v5.0.10/css/all.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_primeicons', plugin_dir_url( __FILE__) . 'includes/primeui/primeicons/primeicons.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_primetheme', plugin_dir_url( __FILE__) . 'includes/primeui/themes/omega/theme.css"',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_primeng', plugin_dir_url( __FILE__) . 'includes/primeui/primeng.min.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_bootstrap', plugin_dir_url( __FILE__) . 'assets/css/bootstrap.min.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_dragdrop', plugin_dir_url( __FILE__) . 'assets/css/dragdrop.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_custom', plugin_dir_url( __FILE__) . 'assets/css/custom.css',false,'1.1','all'); 
    wp_enqueue_style( 'ewoapps_custommodule', plugin_dir_url( __FILE__) . 'assets/css/custommodule.css',false,'1.1','all'); 
    
    wp_enqueue_style( 'ewoapps_style', plugin_dir_url( __FILE__) . 'includes/frontend/styles.13719fbfc2cebe3aacce.css',false,'1.1','all');    
    wp_enqueue_script( 'ewoapps_runtime', plugin_dir_url( __FILE__) . 'includes/frontend/runtime.06daa30a2963fa413676.js', false, null);
    wp_enqueue_script( 'ewoapps_frame', plugin_dir_url( __FILE__) . 'includes/frontend/polyfills.e376cc4a770bfa13f600.js', false, null);
    wp_enqueue_script( 'ewoapps_main', plugin_dir_url( __FILE__) . 'includes/frontend/main.fc6d64197dc8e49172c7.js', false, null);

    return
    '
    <div id="ewoloadingroot" style="cursor: pointer;display: block;padding: 20px;text-align: center;font-size: 17px;color:lightcoral;">Loading ...</div>
    <appmodule ewoid="'.$moduleid.'"></appmodule>
    ';


}