<?php
/**
 * Uninstall script for Everyone Accessibility Suite
 *
 * This file is executed when the plugin is uninstalled via WordPress admin.
 *
 * @package Everyone_Accessibility_Suite
 * @since 1.0.0
 */

// If uninstall is not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete plugin options
 */
delete_option( 'evas_settings' );

/**
 * For multisite installations
 */
if ( is_multisite() ) {
	// Get all sites.
	$evas_sites = get_sites(
		array(
			'fields' => 'ids',
			'number' => 0,
		)
	);

	foreach ( $evas_sites as $evas_site_id ) {
		switch_to_blog( $evas_site_id );
		delete_option( 'evas_settings' );
		restore_current_blog();
	}
}

/**
 * Clear any cached data
 */
wp_cache_flush();

