<?php
/**
 * EVAS Voice Navigation Module
 *
 * Voice navigation module using Web Speech API.
 * Allows users to control the website using voice commands.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Voice_Navigation
 * @version     1.0.0
 * @author      Developer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define module constants
define( 'EVAS_VN_VERSION', '1.0.0' );
define( 'EVAS_VN_FILE', __FILE__ );
define( 'EVAS_VN_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_VN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Check if running standalone or as part of EVAS
 */
if ( ! defined( 'EVAS_VERSION' ) ) {
    // Standalone mode
    require_once EVAS_VN_DIR . 'core/class-module-standalone.php';
    EVAS_VN_Standalone::init();
} else {
    // Integrated mode
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['voice_navigation'] = [
            'file'  => EVAS_VN_FILE,
            'class' => 'EVAS_Voice_Navigation_Module',
        ];
        return $modules;
    });
}

// Load module classes
require_once EVAS_VN_DIR . 'class-voice-commands.php';
require_once EVAS_VN_DIR . 'class-rest-controller.php';
require_once EVAS_VN_DIR . 'class-voice-navigation-module.php';

// Register module metadata
add_action( 'init', function() {
    add_filter( 'evas_module_voice_navigation_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Voice Navigation', 'everyone-accessibility-suite' ),
            'description' => __( 'Control the website using voice commands with Web Speech API support.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-microphone',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/voice-navigation',
            'component'   => 'VoiceNavigationPage',
            'title'       => __( 'Voice Navigation', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Voice Navigation', 'everyone-accessibility-suite' ),
            'description' => __( 'Voice commands and Web Speech API settings', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-microphone',
            'module'      => 'voice_navigation',
        ];
        return $routes;
    });
}, 10 );

