<?php
/**
 * EVAS Virtual Keyboard Module
 *
 * On-screen virtual keyboard for text input.
 * Supports multiple layouts and languages.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Virtual_Keyboard
 * @version     1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define module constants
define( 'EVAS_VK_VERSION', '1.0.0' );
define( 'EVAS_VK_FILE', __FILE__ );
define( 'EVAS_VK_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_VK_URL', plugin_dir_url( __FILE__ ) );
define( 'EVAS_VK_PLUGIN_ACTIVE', true );

// Register with EVAS
if ( defined( 'EVAS_VERSION' ) ) {
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['virtual_keyboard'] = [
            'file'  => EVAS_VK_FILE,
            'class' => 'EVAS_Virtual_Keyboard_Module',
        ];
        return $modules;
    });
}

// Load module classes
require_once EVAS_VK_DIR . 'class-keyboard-layouts.php';
require_once EVAS_VK_DIR . 'class-rest-controller.php';
require_once EVAS_VK_DIR . 'class-virtual-keyboard-module.php';

// Register module metadata
add_action( 'init', function() {
    add_filter( 'evas_module_virtual_keyboard_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Virtual Keyboard', 'everyone-accessibility-suite' ),
            'description' => __( 'On-screen keyboard with multiple layouts and language support.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-editor-textcolor',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/virtual-keyboard',
            'component'   => 'VirtualKeyboardPage',
            'title'       => __( 'Virtual Keyboard', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Virtual Keyboard', 'everyone-accessibility-suite' ),
            'description' => __( 'On-screen keyboard layouts and language settings', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-keyboard',
            'module'      => 'virtual_keyboard',
        ];
        return $routes;
    });
}, 10 );

