<?php
/**
 * Usage Analytics Module
 *
 * Entry point for the Usage Analytics module.
 * Tracks accessibility panel usage with detailed statistics.
 *
 * @package Everyone_Accessibility_Suite
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define module constants.
if ( ! defined( 'EVAS_UA_VERSION' ) ) {
	define( 'EVAS_UA_VERSION', '1.0.1' );
}

if ( ! defined( 'EVAS_UA_PATH' ) ) {
	define( 'EVAS_UA_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'EVAS_UA_URL' ) ) {
	define( 'EVAS_UA_URL', plugin_dir_url( __FILE__ ) );
}

// Include module classes.
require_once EVAS_UA_PATH . 'class-sql-helper.php';
require_once EVAS_UA_PATH . 'class-usage-analytics-storage.php';
require_once EVAS_UA_PATH . 'class-rest-controller.php';
require_once EVAS_UA_PATH . 'class-usage-analytics-module.php';

/**
 * Initialize the module
 *
 * @return EVAS_Usage_Analytics_Module
 */
function evas_usage_analytics_init() {
	return EVAS_Usage_Analytics_Module::get_instance();
}

// Initialize module when WordPress is ready.
add_action( 'init', 'evas_usage_analytics_init' );

