<?php
/**
 * EVAS Text-to-Speech Module
 *
 * Text-to-Speech module with Google Cloud TTS API integration.
 * Supports 60+ languages, various voice types, audio caching, and shortcodes.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Text_To_Speech
 * @version     1.0.0
 * @author      Developer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define module constants
define( 'EVAS_TTS_VERSION', '1.0.0' );
define( 'EVAS_TTS_FILE', __FILE__ );
define( 'EVAS_TTS_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_TTS_URL', plugin_dir_url( __FILE__ ) );

/**
 * Check if running standalone or as part of EVAS
 */
if ( ! defined( 'EVAS_VERSION' ) ) {
    // Standalone mode
    require_once EVAS_TTS_DIR . 'core/class-module-standalone.php';
    EVAS_TTS_Standalone::init();
} else {
    // Integrated mode - register with EVAS
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['text_to_speech'] = [
            'file'  => EVAS_TTS_FILE,
            'class' => 'EVAS_Text_To_Speech_Module',
        ];
        return $modules;
    });
}

// Load module classes
require_once EVAS_TTS_DIR . 'class-tts-languages.php';
require_once EVAS_TTS_DIR . 'class-tts-cache.php';
require_once EVAS_TTS_DIR . 'class-tts-shortcodes.php';
require_once EVAS_TTS_DIR . 'class-speech-generator.php';
require_once EVAS_TTS_DIR . 'class-rest-controller.php';
require_once EVAS_TTS_DIR . 'class-text-to-speech-module.php';

// Register module metadata
add_action( 'init', function() {
    add_filter( 'evas_module_text_to_speech_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Text-to-Speech', 'everyone-accessibility-suite' ),
            'description' => __( 'Read text aloud using Google Cloud Text-to-Speech API with 60+ languages support.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-controls-volumeon',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    // Register admin routes
    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/text-to-speech',
            'component'   => 'TextToSpeechPage',
            'title'       => __( 'Text-to-Speech', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Text-to-Speech', 'everyone-accessibility-suite' ),
            'description' => __( 'Configure Google Cloud TTS API and voice settings', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-controls-volumeon',
            'module'      => 'text_to_speech',
        ];
        return $routes;
    });
}, 10 );

