<?php
/**
 * EVAS Customizer Module
 *
 * Customize the appearance and behavior of the accessibility panel and button.
 * Provides extensive customization options for Open Button and Modal Popup.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Customizer
 * @version     1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define module constants
define( 'EVAS_CUSTOMIZER_VERSION', '1.0.0' );
define( 'EVAS_CUSTOMIZER_FILE', __FILE__ );
define( 'EVAS_CUSTOMIZER_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_CUSTOMIZER_URL', plugin_dir_url( __FILE__ ) );
define( 'EVAS_CUSTOMIZER_PLUGIN_ACTIVE', true );

// Register with EVAS
if ( defined( 'EVAS_VERSION' ) ) {
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['customizer'] = [
            'file'  => EVAS_CUSTOMIZER_FILE,
            'class' => 'EVAS_Customizer_Module',
        ];
        return $modules;
    });
}

// Load module classes
require_once EVAS_CUSTOMIZER_DIR . 'class-icon-library.php';
require_once EVAS_CUSTOMIZER_DIR . 'class-rest-controller.php';
require_once EVAS_CUSTOMIZER_DIR . 'class-customizer-module.php';

// Register module metadata
add_action( 'init', function() {
    add_filter( 'evas_module_customizer_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Customizer', 'everyone-accessibility-suite' ),
            'description' => __( 'Customize the appearance and behavior of the accessibility panel and button.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-admin-customizer',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/customizer',
            'component'   => 'CustomizerPage',
            'title'       => __( 'Customizer', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Customizer', 'everyone-accessibility-suite' ),
            'description' => __( 'Customize panel appearance and button design', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-admin-customizer',
            'module'      => 'customizer',
        ];
        return $routes;
    });
}, 10 );

