<?php
/**
 * EVAS Accessibility Extras Module
 *
 * Usage analytics and accessibility statement generator.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Accessibility_Extras
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'EVAS_AE_VERSION', '1.0.0' );
define( 'EVAS_AE_FILE', __FILE__ );
define( 'EVAS_AE_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_AE_URL', plugin_dir_url( __FILE__ ) );

if ( defined( 'EVAS_VERSION' ) ) {
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['accessibility_extras'] = [
            'file'  => EVAS_AE_FILE,
            'class' => 'EVAS_Accessibility_Extras_Module',
        ];
        return $modules;
    });
}

require_once EVAS_AE_DIR . 'class-usage-analytics.php';
require_once EVAS_AE_DIR . 'class-statement-generator.php';
require_once EVAS_AE_DIR . 'class-rest-controller.php';
require_once EVAS_AE_DIR . 'class-accessibility-extras-module.php';

add_action( 'init', function() {
    add_filter( 'evas_module_accessibility_extras_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Analytics & Statement', 'everyone-accessibility-suite' ),
            'description' => __( 'Usage analytics and accessibility statement generator.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-chart-bar',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/analytics',
            'component'   => 'AnalyticsPage',
            'title'       => __( 'Usage Analytics', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Usage Analytics', 'everyone-accessibility-suite' ),
            'description' => __( 'Track feature usage and user statistics', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-chart-bar',
            'module'      => 'accessibility_extras',
        ];
        $routes[] = [
            'path'        => '/statement',
            'component'   => 'StatementPage',
            'title'       => __( 'Accessibility Statement', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Accessibility Statement', 'everyone-accessibility-suite' ),
            'description' => __( 'Generate and manage accessibility statement', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-media-document',
            'module'      => 'accessibility_extras',
        ];
        return $routes;
    });
}, 10 );

