<?php
/**
 * Accessibility Extras Module Main Class
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Accessibility_Extras
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class EVAS_Accessibility_Extras_Module
 */
class EVAS_Accessibility_Extras_Module extends EVAS_Module_Base {

    public function __construct( $settings_manager = null, $settings = array() ) {
        $this->module_id      = 'accessibility_extras';
        $this->module_name    = __( 'Analytics & Statement', 'everyone-accessibility-suite' );
        $this->module_version = defined( 'EVAS_AE_VERSION' ) ? EVAS_AE_VERSION : '1.0.0';
        
        parent::__construct( $settings_manager, $settings );
    }

    public function get_module_settings() {
        return [
            'statement_settings' => EVAS_Statement_Generator::get_settings(),
            'analytics_summary'  => EVAS_Usage_Analytics::get_summary(),
        ];
    }

    public function register_settings() {}

    public function init() {
        add_action( 'rest_api_init', [ $this, 'register_rest_routes' ] );
        
        // Track feature usage from frontend
        add_action( 'wp_footer', [ $this, 'add_tracking_script' ] );
    }

    public function register_rest_routes(): void {
        $controller = new EVAS_AE_REST_Controller();
        $controller->register_routes();
    }

    public function register_admin_pages(): array {
        return [
            [
                'path'  => '/analytics',
                'title' => __( 'Usage Analytics', 'everyone-accessibility-suite' ),
                'icon'  => 'bar-chart-2',
            ],
            [
                'path'  => '/statement',
                'title' => __( 'Accessibility Statement', 'everyone-accessibility-suite' ),
                'icon'  => 'file-text',
            ],
        ];
    }

    /**
     * Add tracking script to footer
     */
    public function add_tracking_script(): void {
        if ( ! $this->is_enabled() ) {
            return;
        }
        ?>
        <script>
        (function() {
            // Track accessibility feature usage
            document.addEventListener('evas:feature', function(e) {
                var detail = e.detail || {};
                if (detail.feature && detail.action) {
                    fetch('<?php echo esc_url( rest_url( 'evas-extras/v1/analytics/track' ) ); ?>', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({
                            feature: detail.feature,
                            action: detail.action === 'activated' ? 'activate' : 'deactivate'
                        })
                    }).catch(function() {});
                }
            });
        })();
        </script>
        <?php
    }
}

