<?php
/**
 * EVAS Accessibility Analyzer Module
 *
 * Analyzes pages for WCAG 2.1 compliance issues.
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Accessibility_Analyzer
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'EVAS_AA_VERSION', '1.0.0' );
define( 'EVAS_AA_FILE', __FILE__ );
define( 'EVAS_AA_DIR', plugin_dir_path( __FILE__ ) );
define( 'EVAS_AA_URL', plugin_dir_url( __FILE__ ) );

if ( defined( 'EVAS_VERSION' ) ) {
    add_filter( 'evas_register_modules', function( $modules ) {
        $modules['accessibility_analyzer'] = [
            'file'  => EVAS_AA_FILE,
            'class' => 'EVAS_Accessibility_Analyzer_Module',
        ];
        return $modules;
    });
}

require_once EVAS_AA_DIR . 'class-wcag-checker.php';
require_once EVAS_AA_DIR . 'class-analyzer-reports.php';
require_once EVAS_AA_DIR . 'class-rest-controller.php';
require_once EVAS_AA_DIR . 'class-accessibility-analyzer-module.php';

add_action( 'init', function() {
    add_filter( 'evas_module_accessibility_analyzer_metadata', function( $metadata ) {
        return [
            'name'        => __( 'Accessibility Analyzer', 'everyone-accessibility-suite' ),
            'description' => __( 'Scan pages for WCAG 2.1 compliance and get recommendations.', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-search',
            'type'        => 'internal',
            'build'       => 'pro',
        ];
    });

    add_filter( 'evas_admin_routes', function( $routes ) {
        $routes[] = [
            'path'        => '/analyzer',
            'component'   => 'AnalyzerPage',
            'title'       => __( 'Accessibility Analyzer', 'everyone-accessibility-suite' ),
            'menu_title'  => __( 'Accessibility Analyzer', 'everyone-accessibility-suite' ),
            'description' => __( 'WCAG 2.1 compliance scanner and reports', 'everyone-accessibility-suite' ),
            'icon'        => 'dashicons-search',
            'module'      => 'accessibility_analyzer',
        ];
        return $routes;
    });
}, 10 );

