<?php
/**
 * Accessibility Analyzer Module Main Class
 *
 * @package     Everyone_Accessibility_Suite
 * @subpackage  Modules/Accessibility_Analyzer
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class EVAS_Accessibility_Analyzer_Module
 */
class EVAS_Accessibility_Analyzer_Module extends EVAS_Module_Base {

    public function __construct( $settings_manager = null, $settings = array() ) {
        $this->module_id      = 'accessibility_analyzer';
        $this->module_name    = __( 'Accessibility Analyzer', 'everyone-accessibility-suite' );
        $this->module_version = defined( 'EVAS_AA_VERSION' ) ? EVAS_AA_VERSION : '1.0.0';
        
        parent::__construct( $settings_manager, $settings );
    }

    public function get_module_settings() {
        return EVAS_Analyzer_Reports::get_summary();
    }

    public function register_settings() {}

    public function init() {
        add_action( 'rest_api_init', [ $this, 'register_rest_routes' ] );
    }

    public function register_rest_routes(): void {
        $controller = new EVAS_AA_REST_Controller();
        $controller->register_routes();
    }

    public function register_admin_pages(): array {
        return [
            [
                'path'  => '/analyzer',
                'title' => __( 'Accessibility Analyzer', 'everyone-accessibility-suite' ),
                'icon'  => 'search',
            ],
        ];
    }
}

