import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';
import { resolve } from 'path';

export default defineConfig({
	plugins: [react()],
	build: {
		outDir: 'dist',
		emptyOutDir: true,
		cssCodeSplit: false,
		rollupOptions: {
			input: {
				'admin-app': resolve(__dirname, 'src/index.jsx'),
			},
			external: (id) => {
				// Externalize WordPress packages and React (provided by WordPress)
				if (
					id === 'react' ||
					id === 'react-dom' ||
					id === 'react-dom/client' ||
					id.startsWith('@wordpress/')
				) {
					return true;
				}
				// react-router-dom is bundled with the app
				return false;
			},
			output: {
				format: 'iife',
				name: 'EVASAdmin',
				entryFileNames: '[name].js',
				chunkFileNames: 'chunks/[name]-[hash].js',
				assetFileNames: '[name].[ext]',
				globals: {
					'react': 'React',
					'react-dom': 'ReactDOM',
					'react-dom/client': 'ReactDOM',
					'@wordpress/element': 'wp.element',
					'@wordpress/i18n': 'wp.i18n',
					'@wordpress/api-fetch': 'wp.apiFetch',
					'@wordpress/components': 'wp.components',
					'@wordpress/icons': 'wp.icons',
				},
			},
		},
		manifest: true,
	},
	css: {
		preprocessorOptions: {
			scss: {
				additionalData: `@import "src/styles/variables.scss";`,
			},
		},
	},
	resolve: {
		alias: {
			'@': resolve(__dirname, 'src'),
		},
	},
});
