/**
 * EVAS State Management Module
 *
 * Handles saving/loading state to localStorage
 *
 * @package Everyone_Accessibility_Suite
 * @version 1.0.0
 */

export const StateManager = {
    storageKey: 'evas_af_state',
    state: {},

    /**
     * Load saved state from localStorage
     */
    load() {
        try {
            const saved = localStorage.getItem(this.storageKey);
            if (saved) {
                this.state = JSON.parse(saved);
            }
        } catch (e) {
            console.warn('EVAS: Could not load state from localStorage', e);
            this.state = {};
        }
        return this.state;
    },

    /**
     * Save current state to localStorage
     */
    save() {
        try {
            localStorage.setItem(this.storageKey, JSON.stringify(this.state));
        } catch (e) {
            console.warn('EVAS: Could not save state to localStorage', e);
        }
    },

    /**
     * Get state value
     */
    get(key) {
        return this.state[key];
    },

    /**
     * Set state value
     */
    set(key, value) {
        this.state[key] = value;
        this.save();
    },

    /**
     * Delete state value
     */
    delete(key) {
        delete this.state[key];
        this.save();
    },

    /**
     * Clear all state
     */
    clear() {
        this.state = {};
        this.save();
    }
};

