jQuery( function( $ ) {
	'use strict';

    let evergreen_error = {},
        card_allowed;

	/**
	 * Object to handle Evergreen Payments Northwest forms.
	 */
	let wceg_form = {

        /**
		 * Creates all Evergreen Payments Northwest elements that will be used to enter cards or IBANs.
		 */
		createElements: function() {

			if( this.three_ds_interface !== undefined ) {
				this.three_ds_interface.unmount();
			}

			this.form.find('[type="submit"]').removeAttr('disabled').unblock();
			this.form.find('.evergreen-source-errors').html('');

            //wceg_form.onCCFormChange();
			const customCss = ! ( $('#cfw-payment-method').length || $('.woolentor-step--payment').length || $('.avada-checkout').length || $('.ro-checkout-process').length || $('button.wfacp_next_page_button').length ) ? { "pointer-events": "auto"} : {
                "height": "30px"
            }
			//console.log("customCss");
			const req = {
				"country" : $( '#billing_country' ).length ? $( '#billing_country' ).val() : wceg_params.billing_country,
				"currency" : wceg_params.currency,
				"price" : wceg_form.getSelectedPaymentElement().closest( 'li' ).find( '#evergreen-payment-data' ).attr( 'data-amount' )
			};

			if (window.CollectJS !== undefined) {
				CollectJS.configure({
					//"paymentSelector" : "#place_order",
					"variant" : "inline",
					"country" : $( '#billing_country' ).length ? $( '#billing_country' ).val() : wceg_params.billing_country,
					"currency" : wceg_params.currency,
					"price" : wceg_form.getSelectedPaymentElement().closest( 'li' ).find( '#evergreen-payment-data' ).attr( 'data-amount' ),
					"styleSniffer" : "true",
					"customCss" : customCss,
					//"googleFont": "Montserrat:400",
					"fields": {
						"ccnumber": {
							"selector": "#evergreen-card-number-element",
							"placeholder": "•••• •••• •••• ••••"
						},
						"ccexp": {
							"selector": "#evergreen-card-expiry-element",
							"placeholder": wceg_params.placeholder_expiry
						},
						"cvv": {
							"display": "show",
							"selector": "#evergreen-card-cvc-element",
							"placeholder": wceg_params.placeholder_cvc
						},
					},
					'validationCallback' : function(field, status, message) {
						if (status) {
							message = field + " is OK: " + message;
							evergreen_error[field] = '';
						} else {
							evergreen_error[field] = message;
						}
						console.log(message);
					},
					"timeoutDuration" : 20000,
					"timeoutCallback" : function () {
						$( document ).trigger( 'evergreenError', wceg_params.timeout_error );
					},
					"fieldsAvailableCallback" : function () {
						wceg_form.unblock();
						wceg_form.unblockPayment();
						console.log("Collect.js loaded the fields onto the form");
					},
					'callback' : function(response) {
						wceg_form.onEvergreenResponse(response);
					}
				});
			} else {
				$(document).trigger('evergreenError', wceg_params.collect_js_error);
				$('#wceg-cc-form label, #wceg-cc-form .wceg-elements-field').hide();
			}
        },

		/**
		 * Initialize event handlers and UI state.
		 */
		init: function() {

			if( this.three_ds_interface !== undefined ) {
				this.three_ds_interface.unmount();
			}

			// checkout page
			if ( $( 'form.woocommerce-checkout' ).length ) {
				this.form = $( 'form.woocommerce-checkout' );
			}

			$( 'form.woocommerce-checkout' )
				.on(
					'checkout_place_order_evergreen',
					this.onSubmit
				);

			// pay order page
			if ( $( 'form#order_review' ).length ) {
				this.form = $( 'form#order_review' );
			}

			$( 'form#order_review' )
				.on(
					'submit',
					this.onSubmit
				);

			// add payment method page
			if ( $( 'form#add_payment_method' ).length ) {
				this.form = $( 'form#add_payment_method' );
                // Payment methods
                this.form.on( 'click', 'input[name="payment_method"]', function() {
                    $( document.body ).trigger( 'payment_method_selected' );
                } );
			}

			$( 'form#add_payment_method' )
				.on(
					'submit',
					this.onSubmit
				);

			$( document )
				.on(
					'change',
					'#wceg-cc-form :input',
					this.onCCFormChange
				)
				.on(
					'evergreenError',
					this.onError
				)
				.on(
					'checkout_error',
					this.clearToken
				);

			// Theme high multi step checkout
			$(document.body)
				.on('step_jumped', function(step) {
					console.log($('.wc_payment_methods').height());
					if ( $('.wc_payment_methods').height() > 0 && wceg_form.isEvergreenChosen() ) {
						wceg_form.blockPayment();
						wceg_form.createElements();
					}
				});

            if ( wceg_form.isEvergreenChosen() ) {
                wceg_form.blockPayment();
                wceg_form.createElements();
            }

            // CheckoutWC and woolentor, La Forat theme, Avada multi step checkout
			$( 'body' ).on( 'click', '.custom_checkout_page a[href="#next"], a[href="#cfw-payment-method"], a[data-tab="#cfw-payment-method"], a[data-step="step--payment"], a.ro-tab-2, a.ro-btn-2, button.wfacp_next_page_button, .woocommerce-checkout-nav a,.continue-checkout', function() {
                // Don't re-mount if already mounted in DOM.
                if ( wceg_form.isEvergreenChosen() ) {
                    wceg_form.blockPayment();
                    wceg_form.createElements();
                }
            } );

            /**
			 * Only in checkout page we need to delay the mounting of the
			 * card as some AJAX process needs to happen before we do.
			 */
			if ( 'yes' === wceg_params.is_checkout ) {
				$( document.body ).on( 'updated_checkout', function() {
					// Re-mount on updated checkout
                    if ( wceg_form.isEvergreenChosen() ) {
                        wceg_form.blockPayment();
                        wceg_form.createElements();
                    }
				} );
			}

            $( document.body ).on( 'payment_method_selected', function() {
                //console.log( 'payment_method_selected' );
                // Don't re-mount if already mounted in DOM.
				if ( wceg_form.isEvergreenChosen() && ! $( '#evergreen-card-number-element' ).children().length ) {
				    wceg_form.block();
                    wceg_form.createElements();
                }

            } );

            if( this.form !== undefined ) {

                this.form.on( 'click change', 'input[name="wc-evergreen-payment-token"]', function() {
                    if ( wceg_form.isEvergreenChosen() && ! $( '#evergreen-card-number-element' ).children().length ) {
                        wceg_form.block();
                        wceg_form.createElements();
                    }
                } );

            }
		},

		isEvergreenChosen: function() {
			return ( 0 < $( '#evergreen-card-number-element' ).length ) && $( '#payment_method_evergreen' ).is( ':checked' ) && ( ! $( 'input[name="wc-evergreen-payment-token"]:checked' ).length || 'new' === $( 'input[name="wc-evergreen-payment-token"]:checked' ).val() );
		},

		hasToken: function() {
			return ( 0 < $( 'input.evergreen_js_token' ).length ) && ( 0 < $( 'input.evergreen_js_response' ).length );
		},

		is3DSEnabled: function() {
			return wceg_params.enable_3ds && wceg_params.checkout_key !== '';
		},

		block: function() {
			wceg_form.form.block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			} );
		},

		unblock: function() {
			wceg_form.form.unblock();
		},

		blockPayment: function() {
			wceg_form.form.find('#payment, .wfacp_payment').block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			} );
		},

		unblockPayment: function() {
			wceg_form.form.find('#payment, .wfacp_payment').unblock();
		},

        getSelectedPaymentElement: function() {
			return $( '.payment_methods input[name="payment_method"]:checked' );
		},

		onError: function( e, result ) {
			//console.log(responseObject.response);
			let message = result;
            let selectedMethodElement = wceg_form.getSelectedPaymentElement().closest( 'li' );
            let savedTokens = selectedMethodElement.find( '.woocommerce-SavedPaymentMethods-tokenInput' );
            let errorContainer;

			if ( savedTokens.length ) {
				// In case there are saved cards too, display the message next to the correct one.
                let selectedToken = savedTokens.filter( ':checked' );

				if ( selectedToken.closest( '.woocommerce-SavedPaymentMethods-new' ).length ) {
					// Display the error next to the CC fields if a new card is being entered.
					errorContainer = $( '#wceg-cc-form .evergreen-source-errors' );

				} else {
					// Display the error next to the chosen saved card.
					errorContainer = selectedToken.closest( 'li' ).find( '.evergreen-source-errors' );
				}
			} else {
				// When no saved cards are available, display the error next to CC fields.
				errorContainer = selectedMethodElement.find( '.evergreen-source-errors' );
			}

			wceg_form.onCCFormChange();
			$( '.woocommerce-NoticeGroup-checkout' ).remove();
			console.log( result ); // Leave for troubleshooting.
			$( errorContainer ).html( '<ul class="woocommerce_error woocommerce-error wceg-error"><li /></ul>' );
			$( errorContainer ).find( 'li' ).text( message ); // Prevent XSS

			if ( $( '.wceg-error' ).length ) {
				$( 'html, body' ).animate({
					scrollTop: ( $( '.wceg-error' ).offset().top - 200 )
				}, 200 );
			}
			wceg_form.unblock();
			wceg_form.unblockPayment();
		},

		onSubmit: function( e ) {

            let error_message;

			if ( wceg_form.isEvergreenChosen() && ! wceg_form.hasToken() ) {
				e.preventDefault();
				wceg_form.block();

                console.log(evergreen_error);

                let validCardNumber = document.querySelector("#evergreen-card-number-element .CollectJSValid") !== null;
                let validCardExpiry = document.querySelector("#evergreen-card-expiry-element .CollectJSValid") !== null;
                let validCardCvv = document.querySelector("#evergreen-card-cvc-element .CollectJSValid") !== null;

                if( !validCardNumber ) {
                    error_message = wceg_params.card_number_error + ( evergreen_error.ccnumber ? ' ' + wceg_params.error_ref.replace( '[ref]', evergreen_error.ccnumber ) : '' );
                    $( document.body ).trigger( 'evergreenError', error_message );
					return false;
                }

                if( !validCardExpiry ) {
                    error_message = wceg_params.card_expiry_error + ( evergreen_error.ccexp ? ' ' + wceg_params.error_ref.replace( '[ref]', evergreen_error.ccexp ) : '' );
                    $( document.body ).trigger( 'evergreenError', error_message );
					return false;
                }

                if( !validCardCvv ) {
                    error_message = wceg_params.card_cvc_error + ( evergreen_error.cvv ? ' ' + wceg_params.error_ref.replace( '[ref]', evergreen_error.cvv ) : '' );
                    $( document.body ).trigger( 'evergreenError', error_message );
					return false;
                }

                CollectJS.startPaymentRequest();

				// Prevent form submitting
				return false;
			}
		},

		onCCFormChange: function() {
			$( '.wceg-error, .evergreen_js_token, .evergreen_js_response' ).remove();
		},

		onEvergreenResponse: function( response ) {
            console.log(response);

            if( response.tokenType == "inline" && response.card.type != null ) {
                wceg_params.allowed_card_types.forEach(function (card_type) {
                    if( response.card.type == card_type.replace( 'diners-club', 'diners' ) ) {
                        card_allowed = true;
                    }
                });

                if( ! card_allowed ) {
                    $( document.body ).trigger( 'evergreenError', wceg_params.card_disallowed_error );
                    return false;
                }

				if( this.is3DSEnabled() && !$( 'form#add_payment_method' ).length ) {
					console.log('3ds is enabled');
					let first_name = $( '#billing_first_name' ).length ? $( '#billing_first_name' ).val() : wceg_params.billing_first_name,
						last_name  = $( '#billing_last_name' ).length ? $( '#billing_last_name' ).val() : wceg_params.billing_last_name,
						email  = $( '#billing_email' ).length ? $( '#billing_email' ).val() : wceg_params.billing_email,
						phone = $( '#billing_phone' ).length ? $( '#billing_phone' ).val() : wceg_params.billing_phone,
						city = $( '#billing_city' ).length ? $( '#billing_city' ).val() : wceg_params.billing_city,
						state = $( '#billing_state' ).length ? $( '#billing_state' ).val() : wceg_params.billing_state,
						address1 = $( '#billing_address_1' ).length ? $( '#billing_address_1' ).val() : wceg_params.billing_address_1,
						country = $( '#billing_country' ).length ? $( '#billing_country' ).val() : wceg_params.billing_country,
						postcode  = $( '#billing_postcode' ).length ? $( '#billing_postcode' ).val() : wceg_params.billing_postcode;

					if( first_name && last_name && email ) {
						let gatewayjs = Gateway.create(wceg_params.checkout_key);

						gatewayjs.on('error', function (e) {
							console.log(e);
							$( document ).trigger( 'evergreenError', e.message );
						});

						let three_ds = gatewayjs.get3DSecure();

						three_ds.on('error', function (e) {
							console.log(e);
							$( document ).trigger( 'evergreenError', e.message );
						});

						//console.log(wceg_form.getSelectedPaymentElement().closest( 'li' ).find( '#evergreen-payment-data' ));
						const three_ds_options = {
							paymentToken: response.token,
							challengeIndicator: '04',
							currency: wceg_params.currency,
							amount: wceg_form.getSelectedPaymentElement().closest( 'li' ).find( '#evergreen-payment-data' ).attr( 'data-amount' ),
							email: email,
							firstName: first_name,
							lastName: last_name
						};
						if( city && address1 && country && postcode ) {
							three_ds_options.phone = phone;
							three_ds_options.city = city;
							three_ds_options.state =  (country == 'US' || country == 'CA' ? state : '');
							three_ds_options.address1 = address1;
							three_ds_options.country = country;
						}
						console.log(three_ds_options);

						wceg_form.three_ds_interface = three_ds.createUI(three_ds_options);

						wceg_form.three_ds_interface.on('error', function(e) {
							wceg_form.three_ds_interface.unmount();
							console.log('interface error');
							console.log(e);
							wceg_form.form.find('[type="submit"]').removeAttr('disabled').unblock();
							$( document ).trigger( 'evergreenError', e.message );
						});

						wceg_form.three_ds_interface.on('failure', function(e) {
							wceg_form.three_ds_interface.unmount();
							console.log('interface failed');
							console.log(e);
							wceg_form.form.find('[type="submit"]').removeAttr('disabled').unblock();
							$( document ).trigger( 'evergreenError', e.message );
						});

						wceg_form.three_ds_interface.start('#evergreen-three-ds-mount-point');

						wceg_form.three_ds_interface.on('challenge', function(e) {
							console.log('Challenged');
							$( document ).trigger( 'evergreenError', wceg_params.card_3ds_challenge_message );
							wceg_form.form.find('[type="submit"]').attr('disabled', 'disabled').block( { message: null } );
						});

						wceg_form.three_ds_interface.on('complete', function(e) {
							const three_ds_response = {
								...response,
								cavv: e.cavv,
								xid: e.xid,
								eci: e.eci,
								cardholder_auth: e.cardHolderAuth,
								three_ds_version: e.threeDsVersion,
								directory_server_id: e.directoryServerId,
							};
							console.log(three_ds_response);
							$('#evergreen-three-ds-mount-point').slideUp(400, function () {
								$(this).html('').show();
							});
							wceg_form.three_ds_interface.unmount();
							wceg_form.form.find('[type="submit"]').removeAttr('disabled').unblock();
							wceg_form.form.append( "<input type='hidden' class='evergreen_js_token' name='evergreen_js_token' value='" + three_ds_response.token + "'/>" );
							wceg_form.form.append( "<input type='hidden' class='evergreen_js_response' name='evergreen_js_response' value='" + JSON.stringify(three_ds_response) + "'/>" );
							wceg_form.form.submit();
						});
						return false;
					}

				}

            }

			wceg_form.form.append( "<input type='hidden' class='evergreen_js_token' name='evergreen_js_token' value='" + response.token + "'/>" );
            wceg_form.form.append( "<input type='hidden' class='evergreen_js_response' name='evergreen_js_response' value='" + JSON.stringify(response) + "'/>" );
            wceg_form.form.submit();
		},

		clearToken: function() {
			$( '.evergreen_js_token, .evergreen_js_response' ).remove();
		}
	};

	wceg_form.init();
} );