<?php

/*
Plugin Name: Events Optimizer
Plugin URI: https://www.events-optimizer.com
Description: Use AI to create engaging descriptions for your events, venues and organizers. Add automatically events from Google Events. Easily update address information and eliminate the hassle of managing incorrect or outdated details by automating the optimization of data with just a few clicks. remove duplicate venues or organizers. Requires The Events Calendar Plugin.
Version: 2.1.1
Author: Oliver Heinrich
Text Domain: events-optimizer
Domain Path: /languages
Requires Plugins: the-events-calendar
Requires PHP: 8.0
Requires at least: 6.5
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
//----------------------------------------------------------------------------------------
// Composer Autoloader - check if not already loaded (Free vs. Pro)
//----------------------------------------------------------------------------------------
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) && !class_exists( \Composer\Autoload\ClassLoader::class, false ) ) {
    require_once __DIR__ . '/vendor/autoload.php';
}
//----------------------------------------------------------------------------------------
// Load Freemius SDK
// https://www.freemius.com
//----------------------------------------------------------------------------------------
if ( function_exists( 'teoai_fs' ) ) {
    // Free version of the plugin will be deactivated when the Pro version has been activated
    teoai_fs()->set_basename( false, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'teoai_fs' ) ) {
        // Create a helper function for easy SDK access.
        function teoai_fs() {
            global $teoai_fs;
            if ( !isset( $teoai_fs ) ) {
                require_once dirname( __FILE__ ) . '/vendor/freemius/wordpress-sdk/start.php';
                $teoai_fs = fs_dynamic_init( array(
                    'id'             => '8391',
                    'slug'           => 'events-optimizer',
                    'premium_slug'   => 'events-optimizer-pro',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_94f588954e6ff1b7a22a3734cae8a',
                    'is_premium'     => false,
                    'premium_suffix' => 'Pro',
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'trial'          => array(
                        'days'               => 7,
                        'is_require_payment' => true,
                    ),
                    'menu'           => array(
                        'slug'       => 'events_optimizer',
                        'first-path' => 'admin.php?page=events_optimizer_settings',
                        'support'    => false,
                    ),
                    'is_live'        => true,
                ) );
            }
            return $teoai_fs;
        }

        // Init Freemius.
        teoai_fs();
        // Signal that SDK was initiated.
        do_action( 'teoai_fs_loaded' );
        function teoai_fs_settings_url() {
            return admin_url( 'admin.php?page=events_optimizer' );
        }

        teoai_fs()->add_filter( 'connect_url', 'teoai_fs_settings_url' );
        teoai_fs()->add_filter( 'after_skip_url', 'teoai_fs_settings_url' );
        teoai_fs()->add_filter( 'after_connect_url', 'teoai_fs_settings_url' );
        teoai_fs()->add_filter( 'after_pending_connect_url', 'teoai_fs_settings_url' );
    }
    // Include the main plugin file
    require_once plugin_dir_path( __FILE__ ) . 'events-optimizer-free.php';
}
// Load Google Events Import scaffolding (CPT, menus, jobs) if available.
// Kept outside the premium guard so the CPT/admin screens are registered early,
// while the actual import logic remains guarded inside the class file where needed.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'pro/includes/class-teoai-google-events-import.php' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'pro/includes/class-teoai-google-events-import.php';
}