jQuery(document).ready(function ($) {

	function dismissNotice( action ) {
		if ( navigator.sendBeacon ) {
			const data = new FormData();
			data.append( 'action', action );
			navigator.sendBeacon( ajaxurl, data );
		} else {
			$.post( ajaxurl, { action: action } );
		}
	}

	// Plugin activated notice
	$( document ).on( 'click', '.notice.teoai-notice-plugin-activated .notice-dismiss', function () {
		dismissNotice( 'teoai_dismiss_notice_plugin_activated' );
	} );

	// Plugin updated notice
	$( document ).on( 'click', '.notice.teoai-notice-plugin-updated .notice-dismiss', function () {
		dismissNotice( 'teoai_dismiss_notice_plugin_updated' );
	} );

	// Menu moved notice
	$( document ).on( 'click', '.notice.teoai-notice-menu-moved .notice-dismiss', function () {
		dismissNotice( 'teoai_dismiss_notice_menu_moved' );
	} );

} );
