<?php
/*
 * Plugin Name:       Eventin Addon for SureCart
 * Requires Plugins:  wp-event-solution, surecart
 * Description:       Seamlessly integrate Eventin event management with SureCart payment system to sell event tickets through SureCart checkout.
 * Version:           1.0.0
 * Requires at least: 6.2
 * Requires PHP:      7.4
 * Author:            Arraytics
 * Author URI:        https://arraytics.com/
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       eventin-addon-for-surecart
 * Domain Path:       /languages
 */

 // Exit if accessed directly.

use Etn_Surecart_Addon\Init;
use Etn_Surecart_Addon\Container\Container;
use Etn_Surecart_Addon\Providers\Global_Service_Provider;

defined( 'ABSPATH' ) || exit;


require_once __DIR__ . '/vendor/autoload.php';


// Define constant for the Plugin file.
defined( 'EVENTIN_SURECART_ADDON_FILE' ) || define( 'EVENTIN_SURECART_ADDON_FILE', __FILE__ );
defined( 'EVENTIN_SURECART_ADDON_DIR' ) || define( 'EVENTIN_SURECART_ADDON_DIR', __DIR__ );

global $eventin_surecart_addon_container;

$eventin_surecart_addon_container = new Container();

$eventin_surecart_addon_container->add_service_provider( 'global', Global_Service_Provider::class );

/**
 * eventin_surecart_addon container
 *
 * @return  Container
 *
 * @since 1.0.0
 */
function eventin_surecart_addon_container() {
    global $eventin_surecart_addon_container;

    return $eventin_surecart_addon_container;
}

/**
 * Main plugin initialization
 *
 * @return Etn_Surecart_Addon
 *
 * @since 1.0.0
 */
function eventin_surecart_addon() {
    return Init::instance();
}

// Kick-off the plugin.
eventin_surecart_addon();
