<?php
namespace Etn_Surecart_Addon\Integrations\SureCart;

defined( 'ABSPATH' ) || exit;

/**
 * SureCartPaymentTimer class
 *
 * @package Etn_Surecart_Addon/Integrations/SureCart
 *
 * @since 1.0.0
 */
class SureCartPaymentTimer {
    /**
     * Constructor
     *
     * @return void
     *
     * @since 1.0.0
     */
    public function __construct() {
        // Check if surecart is active
        if ( ! class_exists( '\\SureCart' ) ) {
            return;
        }

        // add_action( 'wp_footer', [ $this, 'add_custom_js' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_timer_script' ] );
    }

    public function enqueue_timer_script()
    {
        $is_enable_payment_timer = etn_get_option('ticket_purchase_timer_enable', 'off');

        // Register dummy script to attach inline JS
        wp_register_script('etn-surecart-timer', '', [], '1.0.0', true);
        wp_enqueue_script('etn-surecart-timer');

        if ($is_enable_payment_timer !== 'on') {
            return;
        }

        $timer_seconds = (int) etn_get_option('ticket_purchase_timer', 10) * 60;
        $text_before   = __('Complete your payment within', 'eventin-addon-for-surecart');
        $text_after    = __('minutes.', 'eventin-addon-for-surecart');

        $inline_js = '
        (function () {
            document.addEventListener("DOMContentLoaded", function () {
                const checkoutContainer = document.querySelector(".wp-block-surecart-checkout-form");
                if (!checkoutContainer) return;

                let timeLeft = 0;

                try {
                    const stored = localStorage.getItem("timeLeft");
                    if (stored !== null) {
                        const parsed = parseInt(stored, 10);
                        if (!isNaN(parsed) && parsed >= 0) {
                            timeLeft = parsed;
                        }
                    }
                } catch (e) {}

                if (timeLeft <= 0) {
                    timeLeft = ' . (int) $timer_seconds . ';
                    try { localStorage.setItem("timeLeft", String(timeLeft)); } catch (e) {}
                }

                const timerBox = document.createElement("div");
                timerBox.id = "surecart-payment-timer";
                timerBox.style.cssText = "padding:15px;border:1px solid #ccc;border-radius:8px;background:#fff3cd;text-align:center;font-weight:bold;margin-bottom:15px;color:#856404;";
                timerBox.innerHTML = "' . esc_js($text_before) . ' <span id=\"timer-value\">--:--</span> ' . esc_js($text_after) . '";
                checkoutContainer.insertAdjacentElement("afterbegin", timerBox);

                const display = document.getElementById("timer-value");

                function updateDisplay() {
                    const minutes = Math.floor(timeLeft / 60);
                    const seconds = timeLeft % 60;
                    display.textContent = minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
                }

                updateDisplay();

                const interval = setInterval(function () {
                    timeLeft = Math.max(timeLeft - 1, 0);
                    updateDisplay();

                    try { localStorage.setItem("timeLeft", String(timeLeft)); } catch (e) {}

                    if (timeLeft <= 0) {
                        clearInterval(interval);
                        localStorage.removeItem("timeLeft");
                        window.location.href = "/";
                    }
                }, 1000);
            });

            document.addEventListener("DOMContentLoaded", function () {
                var blocks = document.querySelectorAll(".wp-block-surecart-totals");
                blocks.forEach(function (block) {
                    block.style.pointerEvents = "none";
                    block.style.opacity = "0.5";
                });
            });
        })();
        ';

        wp_add_inline_script('etn-surecart-timer', $inline_js);
    }
}