<?php
namespace Etn_Surecart_Addon\Integrations\SureCart;

defined( 'ABSPATH' ) || exit;

use Eventin\Order\OrderModel;
use Eventin\Order\PaymentInterface;
use WP_Error;

/**
 * SureCartPaymentMethod class
 *
 * @package Etn_Surecart_Addon/Integrations/SureCart
 *
 * @since 1.0.0
 */
class SureCartPaymentMethod implements PaymentInterface {
    /**
     * Create a payment in SureCart
     *
     * @param OrderModel $order The order object
     * @return array|false|WP_Error The response body on success, false on failure, or WP_Error on error
     *
     * @since 1.0.0
     */
    public function create_payment( OrderModel $order ) {
        $sureCart = new SureCart();
        return $sureCart->create_payment( $order );
    }

    /**
     * Handle order refund
     *
     * @param OrderModel $order The order to refund
     * @return void
     *
     * @since 1.0.0
     */
    public function refund($order){
        $payment_id = $order->payment_id??null;

        if ($payment_id !== null && $payment_id !== ''){
            $sureCart = new SureCart();
            return $sureCart->create_refund($order->payment_id);
        }

        return false;
    }
}
