<?php
namespace Etn_Surecart_Addon\Providers;

defined( 'ABSPATH' ) || exit;

use Etn_Surecart_Addon\Contracts\Provider_Contract;
use Etn_Surecart_Addon\Providers\Integrations_Service_Provider;

/**
 * Global service provider that will responsible for all service provider
 *
 * @package Etn_Surecart_Addon/Providers
 *
 * @since 1.0.0
 */
class Global_Service_Provider implements Provider_Contract {
    /**
     * Store container
     *
     * @var Container
     *
     * @since 1.0.0
     */
    protected $container;

    /**
     * Store service providers
     *
     * @var array
     *
     * @since 1.0.0
     */
    protected $providers = [
        'integrations' => Integrations_Service_Provider::class,
    ];

    /**
     * GlobalService Provider
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function __construct() {
        $this->container = eventin_surecart_addon_container();
        $this->register();
        $this->boot();
    }

    /**
     * Register all module providers
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function register() {
        $providers = apply_filters( 'eventin_surecart_addon_service_provers', $this->providers );

        if ( $providers ) {
            foreach( $providers as $key => $provider ) {
                $this->container->add_service_provider( $key, $provider );
            }
        }
    }

    /**
     * Boot all services from providers
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function boot() {
        $integrations = $this->container->get('integrations');
        if ( method_exists( $integrations, 'boot' ) ) {
            $integrations->boot();
        }
    }
}
