<?php
namespace Etn_Surecart_Addon\Providers;

defined( 'ABSPATH' ) || exit;

/**
 * BaseServiceProvider will responsible for all appointment services
 *
 * @package Etn_Surecart_Addon/Providers
 *
 * @since 1.0.0
 */
abstract class Base_Service_Provider {
    /**
     * Store container
     *
     * @var Container
     *
     * @since 1.0.0
     */
    protected $container;

    /**
     * Constructor for BaseServiceProvider class
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function __construct() {
        $this->register();
    }

    /**
     * Register services
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function register() {
        $services = $this->get_services();

        if ( $services ) {
            foreach( $services as $service ) {
                $object = new $service();
                $object->register();
            }
        }
    }

    /**
     * Get services
     *
     * @return  array service lists
     *
     * @since 1.0.0
     */
    abstract public function get_services();
}
