<?php
namespace Etn_Surecart_Addon\Providers;

defined( 'ABSPATH' ) || exit;

use Etn_Surecart_Addon\Contracts\Provider_Contract;
use Etn_Surecart_Addon\Integrations\SureCart\SureCartWebhook;

/**
 * Integrations Service Provider (PSR-4 filename compliant)
 *
 * @package Etn_Surecart_Addon/Providers
 *
 * @since 1.0.0
 */
class Integrations_Service_Provider implements Provider_Contract {
    /**
     * Register provider services
     *
     * @return void
     *
     * @since 1.0.0
     */
    public function register() {}

    /**
     * Boot integrations
     *
     * @return void
     *
     * @since 1.0.0
     */
    public function boot() {
        // Register webhook hooks
        if ( class_exists( SureCartWebhook::class ) ) {
            $webhook = new SureCartWebhook();
            if ( method_exists( $webhook, 'register_hooks' ) ) {
                $webhook->register_hooks();
            }
        }
    }
}
