<?php
namespace Webcloud\AsiagoEvents;

/*
Plugin Name: Eventi Asiago.it
Description: Gli eventi di Asiago.it direttamente nel tuo WordPress.
Version: 1.1.4
Author: Webcloud
Author URI: https://www.webcloud.it/
*/

function get_events($api_key, $args) {
    $queryString = [];

    if (get_option( 'webcloud_asiago_events_options' )['filter_by_customer']) {
        $queryString['filterByCustomer'] = 'true';
    }

    $url = 'https://api.asiago.it/v1/events' . (count($queryString) > 0 ? '?' . http_build_query($queryString) : '');
    $response = wp_remote_get(
        $url,
        array(
            'httpversion' => '1.1',
            'headers' => array(
                'Authorization' => isset($api_key) ? 'WC-V1 key=' . $api_key : '',
                'Accept-Language' => get_locale()
            )
        )
    );

    $events = json_decode( wp_remote_retrieve_body( $response ), true );

    if (isset($events)) { require_once( plugin_dir_path( __FILE__ ) . 'views/events.php' ); }
}

//[asiagoevents]
function asiagoevents( $atts ){
    ob_start();
    get_events(get_option( 'webcloud_asiago_events_options' )['api_key'], $atts);
    return ob_get_clean();
}
add_shortcode( 'asiagoevents', 'Webcloud\AsiagoEvents\asiagoevents' );

class Widget extends \WP_Widget {
    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct(
            'webcloud_asiago_events_widget', // Base ID
            esc_html__( 'Eventi Asiago.it', 'text_domain' ), // Name
            array( 'description' => esc_html__( 'Gli eventi di Asiago.it', 'text_domain' ), ) // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }
        get_events(get_option( 'webcloud_asiago_events_options' )['api_key'], []);
        echo $args['after_widget'];
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        ?>
        <p>
        <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Titolo:', 'text_domain' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

        return $instance;
    }
}

class Settings
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Add options page
     */
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_options_page(
            'Eventi Asiago.it',
            'Eventi Asiago.it',
            'manage_options',
            'webcloud-asiago-events',
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page()
    {
        // Set class property
        $this->options = get_option( 'webcloud_asiago_events_options' );
        ?>
        <div class="wrap">
            <h1>Impostazioni Eventi Asiago.it</h1>
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'webcloud_asiago_events_settings' );
                do_settings_sections( 'webcloud-asiago-events' );
                submit_button();
            ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init()
    {
        register_setting(
            'webcloud_asiago_events_settings', // Option group
            'webcloud_asiago_events_options', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'webcloud_asiago_events_settings_general', // ID
            null, // Title
            null, // Callback
            'webcloud-asiago-events' // Page
        );

        add_settings_field(
            'api_key', // ID
            'Chiave API', // Title
            array( $this, 'api_key_callback' ), // Callback
            'webcloud-asiago-events', // Page
            'webcloud_asiago_events_settings_general' // Section
        );

        add_settings_field(
            'filter_by_customer', // ID
            'Solo i propri', // Title
            array( $this, 'filter_by_customer_callback' ), // Callback
            'webcloud-asiago-events', // Page
            'webcloud_asiago_events_settings_general' // Section
        );
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize( $input )
    {
        $new_input = array();

        if( isset( $input['api_key'] ) )
            $new_input['api_key'] = sanitize_text_field( $input['api_key'] );

        if( isset( $input['filter_by_customer'] ) )
            $new_input['filter_by_customer'] = true;

        return $new_input;
    }

    /**
     * Get the settings option array and print one of its values
     */
    public function api_key_callback()
    {
        printf(
            '<input type="text" id="api-key" name="webcloud_asiago_events_options[api_key]" value="%s" />',
            isset( $this->options['api_key'] ) ? esc_attr( $this->options['api_key']) : ''
        );
    }

    public function filter_by_customer_callback()
    {
        printf(
            '<input type="checkbox" id="filter_by_customer" name="webcloud_asiago_events_options[filter_by_customer]" %s value="1" />',
            isset( $this->options['filter_by_customer'] ) ? 'checked' : ''
        );
    }
}

if( is_admin() )
    new Settings();

add_action( 'widgets_init', function(){
    register_widget( 'Webcloud\AsiagoEvents\Widget' );
});
