<?php

namespace Eventflow\Interlink\OAuth;


/**
 * access tokens and request tokens
 */
class Token {
	private $_sKey;
	private $_sSecret;

	function __construct( $sKey, $sSecret ) {
		$this->_sKey    = $sKey;
		$this->_sSecret = $sSecret;
	}

	public function getKey() {
		return $this->_sKey;
	}

	public function getSecret() {
		return $this->_sSecret;
	}

	/**
	 * generates the basic string serialization of a token that a server
	 * would respond to request_token and access_token calls with
	 */
	function __toString() {
		return sprintf( "oauth_token=%s&oauth_token_secret=%s",
			Util::urlencode_rfc3986( $this->_sKey ),
			Util::urlencode_rfc3986( $this->_sSecret ) );
	}

}
