<?php

namespace Eventflow\Interlink\OAuth;


/**
 * The HMAC-SHA1 signature method uses the HMAC-SHA1 signature algorithm as defined in [RFC2104]
 * where the Signature Base String is the text and the key is the concatenated values (each first
 * encoded per Parameter Encoding) of the Consumer Secret and Token Secret, separated by an '&'
 * character (ASCII code 38) even if empty.
 *   - Chapter 9.2 ("HMAC-SHA1")
 */
class Signature_Method_HMAC_SHA1 extends Base_Signature_Method implements Signature_Method {

	const METHOD = "HMAC-SHA1";

	public function getMethod() {
		return self::METHOD;
	}

	public function buildSignature( Request $oRequest, Consumer $oConsumer, Token $oToken ) {
		$sBaseString = $oRequest->getSignatureBaseString();
		$oRequest->setBaseString( $sBaseString ); // debug info

		$aKeyParts = array( $oConsumer->getSecret(), ( $oToken ) ? $oToken->getSecret() : "" );
		$aKeyParts = Util::urlencode_rfc3986( $aKeyParts );
		$sKey      = implode( '&', $aKeyParts );

		return base64_encode( hash_hmac( 'sha1', $sBaseString, $sKey, true ) );
	}
}
