<?php

namespace Eventflow\Interlink\OAuth;


/**
 * Based on the code by Andy Smith (oauth.net)
 *
 * An Interface for Signature Method strategy classes, s. section 9 ("Signing Requests") of the spec.
 */
interface Signature_Method {
	/**
	 * Needs to return the name of the Signature Method (HMAC-SHA1 etc.)
	 *
	 * @return string
	 */
	public function getMethod();

	/**
	 * Build up the signature
	 *
	 * NOTE: The output of this function MUST NOT be urlencoded. The encoding is handled in OAuthRequest when the final
	 * request is serialized
	 *
	 * @param Request $oRequest
	 * @param Consumer $oConsumer
	 * @param Token $token
	 *
	 * @return string
	 */
	public function buildSignature( Request $oRequest, Consumer $oConsumer, Token $oToken );

	/**
	 * Verifies that a given signature is correct by comparing it with the one built from the ground up
	 *
	 * @param Request $oRequest
	 * @param Consumer $oConsumer
	 * @param Token $oToken
	 * @param string $sSignature
	 *
	 * @return bool
	 */
	public function checkSignature( Request $oRequest, Consumer $oConsumer, Token $oToken, $sSignature );
}
