<?php

namespace Eventflow\Interlink\OAuth;


/**
 * Represents the identity of the Consumer via its shared secret with the Service Provider
 */
class Consumer {
	private $_sKey;
	private $_sSecret;
	private $_sCallbackURL;

	function __construct( $sKey, $sSecret, $sCallbackURL = null ) {
		$this->_sKey         = $sKey;
		$this->_sSecret      = $sSecret;
		$this->_sCallbackURL = $sCallbackURL;
	}

	function __toString() {
		return sprintf( "OAuthConsumer[key=%s,secret=%s]", $this->_sKey, $this->_sSecret );
	}

	function getKey() {
		return $this->_sKey;
	}

	function getSecret() {
		return $this->_sSecret;
	}

	function getCallbackURL() {
		return $this->_sCallbackURL;
	}
}
