<?php

namespace Eventflow\Interlink\OAuth;


/**
 * Base class for Signature Method implementations
 */
abstract class Base_Signature_Method implements Signature_Method {
	/**
	 * Verifies that a given signature is correct by comparing it with the one built from the ground up
	 *
	 * @param Request $oRequest
	 * @param Consumer $oConsumer
	 * @param Token $oToken
	 * @param string $sSignature
	 *
	 * @return bool
	 */
	public function checkSignature( Request $oRequest, Consumer $oConsumer, Token $oToken, $sSignature ) {
		return ( $this->buildSignature( $oRequest, $oConsumer, $oToken ) === $sSignature );
	}
}
