<?php

namespace Eventflow\Interlink\Client;


use WP_Http;

/**
 * Sending requests with WP_Http
 */
class WP_Http_Invoker extends Abstract_Invoker implements Invoker {
	/**
	 * @Override
	 * @return Response
	 */
	public function request() {
		if ( ! function_exists( 'wp_remote_post' ) ) {
			error_log( 'WP_Http class is not available, I shall try a curl fallback.' );

			return null;
		}

		$aResponse = $this->_execute();

		if ( is_wp_error( $aResponse ) ) {
			error_log( 'wp_error in class Eventflow\Interlink\Client\WP_Http_Invoker' );

			return null;
		} else {
			$oResponse = new Response();
			$oResponse->setStatusCode( $aResponse['response']['code'] );
			$oResponse->setHeaders( $aResponse['headers']->getAll() );
			$oResponse->setBody( $aResponse['body'] );

			return $oResponse;
		}
	}

	protected function _execute() {
		$httpClient = new WP_Http();
		$response   = $httpClient->request(
			$this->_oRequest->getURL(),
			array(
				'method'      => $this->_oRequest->getHTTPMethod() === 'GET' ? 'GET' : 'POST',
				'httpversion' => '1.1',
				'body'        => $this->_oRequest->getBody(),
				'headers'     => $this->_oRequest->getHeaders(),
				'sslverify'   => true,
				'timeout'     => 30   // an extended timeout, default is 5 sec
			)
		);
		if ( is_wp_error( $response ) ) {
			\Eventflow\Interlink\Plugin::DEBUG( $response );
		}

		return $response;
	}

}
